<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Douar;
use App\Models\SettingsActivites;
use App\Models\Commerce;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use stdClass;

class AppTerrainController extends Controller
{
    public function index()
    {
        $settingsActivites = SettingsActivites::all();
        if (Auth::user()->has_role('agent_terrain')) {
            return view('app_terrain.index', ["settingsActivites" => $settingsActivites]);
        }
    }

    public function show_media(String $document_id)
    {
        $document = BaraqueDocument::where('id', $document_id)->get()->first();
        return view('app_terrain.show_media', ["document" => $document]);
    }

    public function delete(Request $request)
    {
        $baraque = Baraque::where('id', $request->id)->get()->first();
        $baraque->active = 0;
        $baraque->save();
        return Response::json(['success' => 1]);
    }

    public function edit_geometry(Request $request)
    {
        $baraque = Baraque::where('id', $request->id)->get()->first();
        $baraque->timestamp = time();
        $baraque->geometry = $request->geometry;
        $baraque->save();
        return Response::json(['success' => 1]);
    }

    public function store(Request $request)
    {
        $baraque_data = json_decode($request->baraque);

        //check baraque numero
        if (strlen(trim($baraque_data->numero)) == 0) {
            return Response::json(['success' => 0, 'error' => "BARAQUE_NUMERO_MISSING"]);
        }
        //Check menages count
        if (count($baraque_data->menages) == 0 && count($baraque_data->commerces) == 0) {
            if($baraque_data->baraque_vide==0)
            {
                return Response::json(['success' => 0, 'error' => "NO_MENAGE"]);
            }
       
        }
        //Check CIN
        foreach ($baraque_data->menages as $menage) {

            if (strlen(trim($menage->chef_menage_cin)) == 0) {
                if ($menage->chef_menage_cin_non_disponible == 0) {
                    return Response::json(['success' => 0, 'error' => "MENAGE_NO_CIN"]);
                }
            }
            if ($menage->situation == "Marié") {
                if (strlen(trim($menage->conjoint_cin)) == 0) {
                    if ($menage->conjoint_cin_non_disponible == 0) {
                        return Response::json(['success' => 0, 'error' => "MENAGE_MARIE_NO_CONJOINT_CIN"]);
                    }
                }
            }
            if (count($menage->PHOTO_MENAGE_CIN) == 0) {
                if ($menage->chef_menage_cin_non_disponible == 0) {
                    return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_MENAGE_CIN"]);
                }
            }
            if ($menage->situation == "Marié") {

                if (count($menage->PHOTO_CIN_CONJOINT) == 0) {
                    if ($menage->conjoint_cin_non_disponible == 0) {
                        return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_CIN_CONJOINT"]);
                    }
                }
                if (count($menage->PHOTO_ACT_MARIAGE) == 0) {
                    if ($menage->acte_mariage_photo_non_disponible == 0) {
                        return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_ACT_MARIAGE"]);
                    }
                }
            }
            if ($menage->situation == "Divorcé") {

                if (count($menage->PHOTO_ACT_DIVORCE) == 0) {
                    if ($menage->acte_divorce_photo_non_disponible == 0) {
                        return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_ACT_DIVORCE"]);
                    }
                }
            }
            if ($menage->situation == "Veuf") {

                if (count($menage->PHOTO_ACT_DECES) == 0) {
                    if ($menage->acte_deces_photo_non_disponible == 0) {
                        return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_ACT_DECES"]);
                    }
                }
            }

            if (count($menage->PHOTO_BARAQUE) == 0) {
                return Response::json(['success' => 0, 'error' => "MISSING_PHOTO_BARAQUE"]);
            }
        }

        $baraque = new Baraque();

        if (is_null($baraque_data->id)) {
            $baraque->id = Str::uuid();
        } else {
            $baraque = Baraque::where('id', $baraque_data->id)->get()->first();
        }

        $baraque->baraque_vide = $baraque_data->baraque_vide;
        $baraque->rdc_obs = $baraque_data->rdc_obs;
        $baraque->e1_obs = $baraque_data->e1_obs;
        $baraque->e2_obs = $baraque_data->e2_obs;

        $baraque->numero = $baraque_data->numero;

        $baraque->geometry = $baraque_data->geometry;
        $baraque->lat = $baraque_data->lat;
        $baraque->lng = $baraque_data->lng;

        $baraque->timestamp = time();
        $baraque->equipe_id = Auth::user()->equipe->id;

        $baraque->user_id = Auth::user()->id;

        // foreach ($baraque->menages as $db_menage) {

        //     $db_menage->delete();
        // }

        // foreach ($baraque->commerces as $db_commerce) {
        //     $db_commerce->delete();
        // }

        foreach ($baraque_data->menages as $menage) {
            $db_menage = new Menage();
            $db_menage = Menage::where("id", $menage->id)->get()->first();
            if (is_null($db_menage)) {
                $db_menage = new Menage();
                $db_menage->id = Str::uuid();
            }

            if ($db_menage->verrification_etat == "Validé") {
                continue;
            }
            $db_menage->baraque_id = $baraque->id;
            $db_menage->niveau = $menage->niveau;
            $db_menage->chef_menage_cin = $menage->chef_menage_cin;
            $db_menage->situation = $menage->situation;
            $db_menage->conjoint_cin = $menage->conjoint_cin;
            $db_menage->sexe = $menage->sexe;

            $db_menage->chef_menage_nom = $menage->chef_menage_nom;
            $db_menage->chef_menage_prenom = $menage->chef_menage_prenom;


            $db_menage->donnees_non_fournie_par_chef_menage = $menage->donnees_non_fournie_par_chef_menage;
            $db_menage->chef_menage_cin_non_disponible = $menage->chef_menage_cin_non_disponible;
            $db_menage->chef_menage_cin_non_disponible_raision = $menage->chef_menage_cin_non_disponible_raision;
            $db_menage->acte_mariage_photo_non_disponible = $menage->acte_mariage_photo_non_disponible;
            $db_menage->conjoint_cin_non_disponible = $menage->conjoint_cin_non_disponible;
            $db_menage->acte_deces_photo_non_disponible = $menage->acte_deces_photo_non_disponible;
            $db_menage->acte_divorce_photo_non_disponible = $menage->acte_divorce_photo_non_disponible;

            $db_menage->save();

            foreach ($menage->PHOTO_MENAGE_CIN as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }

            foreach ($menage->PHOTO_ACT_MARIAGE as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }

            foreach ($menage->PHOTO_ACT_DIVORCE as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }

            foreach ($menage->PHOTO_ACT_DECES as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }

            foreach ($menage->PHOTO_CIN_CONJOINT as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }

            foreach ($menage->PHOTO_BARAQUE as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->menage_id = $db_menage->id;
                $document_db->save();
            }
        }

        foreach ($baraque_data->commerces as $commerce) {

            $db_commerce = new Commerce();
            $db_commerce = Commerce::where("id", $commerce->id)->get()->first();
            if (is_null($db_commerce)) {
                $db_commerce = new Commerce();
                $db_commerce->id = Str::uuid();
            }



            $db_commerce->baraque_id = $baraque->id;
            $db_commerce->niveau = $commerce->niveau;
            $db_commerce->cin = $commerce->cin;
            $db_commerce->type_activite = $commerce->type_activite;

            $db_commerce->save();

            foreach ($commerce->PHOTO_COMMERCE_CIN as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->commerce_id = $db_commerce->id;
                $document_db->save();
            }

            foreach ($commerce->PHOTO_COMMERCE as $document) {
                $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
                $document_db->baraque_id = $baraque->id;
                $document_db->commerce_id = $db_commerce->id;
                $document_db->save();
            }
        }


        foreach ($baraque_data->PHOTO_BARAQUE_VIDE as $document) {
            $document_db = BaraqueDocument::where('id', $document->id)->get()->first();
            $document_db->baraque_id = $baraque->id;
            $document_db->menage_id = null;
            $document_db->save();
        }
        $baraque->save();

        $documents_to_delete = json_decode($request->documents_to_delete);


        foreach ($documents_to_delete as $doc_id) {
            $document_db = BaraqueDocument::where('id',  $doc_id)->get()->first();
            $document_db->active = 0;
            $document_db->save();
        }

        Auth::user()->last_view_lat = $request->last_view_lat;
        Auth::user()->last_view_lng = $request->last_view_lng;
        Auth::user()->last_view_zoom = $request->last_view_zoom;

        Auth::user()->save();

        return Response::json(['success' => 1, 'error' => null]);
    }

    public function geometriesCount()
    {
        return Baraque::where("active", 1)->count();
    }


    public function loadGeometries(Request $request)
    {
        $baraques = Baraque::select('id', 'numero', 'geometry', 'timestamp', 'equipe_id')->with("equipe")->where("active", 1)->where('timestamp', '>=', $request->last_timestamp)->orderBy('timestamp', 'DESC')->get();

        $result = new stdClass();
        $result->baraques = $baraques;
        if (count($baraques) > 0) {
            $result->last_timestamp = $baraques[0]->timestamp;
        } else {
            $result->last_timestamp = 0;
        }

        return $result;
    }

    public function getBaraque(Request $request)
    {
        $baraque = Baraque::with('commerces')->with('menages')->where('id', $request->id)->get()->first();
        $baraque->PHOTO_BARAQUE_VIDE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE_VIDE")->where('baraque_id', $baraque->id)->get();

        foreach ($baraque->menages as $menage) {

            $menage->PHOTO_MENAGE_CIN = BaraqueDocument::where('type_document', "PHOTO_MENAGE_CIN")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_MARIAGE = BaraqueDocument::where('type_document', "PHOTO_ACT_MARIAGE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_ACT_DIVORCE = BaraqueDocument::where('type_document', "PHOTO_ACT_DIVORCE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_CIN_CONJOINT = BaraqueDocument::where('type_document', "PHOTO_CIN_CONJOINT")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
        }

        foreach ($baraque->commerces as $commerce) {

            $commerce->PHOTO_COMMERCE_CIN = BaraqueDocument::where('type_document', "PHOTO_COMMERCE_CIN")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
            $commerce->PHOTO_COMMERCE = BaraqueDocument::where('type_document', "PHOTO_COMMERCE")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
        }
        return $baraque;
    }

    public function upload(Request $request)
    {

        $now = Carbon::now();
        $now->hour(23);
        $now->minute(59);
        $now->second(59);


        $document = new BaraqueDocument();
        $document->id = Str::uuid();

        $file = $request->file('file');


        $document->filename = $file->getClientOriginalName();
        $document->nom =  $file->getClientOriginalName();
        $document->user_id =  Auth::user()->id;
        $document->date_document = $now->format('Y-m-d');
        $document->file_type = Str::upper($file->getClientOriginalExtension());
        $document->file_size =  $file->getSize();

        $document->type_document = $request->type_document;


        $document->save();


        $document->formated_created_at = $document->formated_created_at();

        $file->move("files/baraques_documents/" . $document->id . "/", $document->filename);

        return Response::json(['success' => 1, 'document' => $document]);
    }


    public function upload_tab(Request $request)
    {

        $now = Carbon::now();
        $now->hour(23);
        $now->minute(59);
        $now->second(59);


        $document = new BaraqueDocument();
        $document->id = Str::uuid();

        $file = $request->file('file');


        $document->filename = $file->getClientOriginalName();
        $document->nom =  $file->getClientOriginalName();
        $document->user_id =   $request->user_id;
        $document->date_document = $now->format('Y-m-d');
        $document->file_type = Str::upper($file->getClientOriginalExtension());
        $document->file_size =  $file->getSize();

        $document->type_document = $request->type_document;


        $document->save();


        $document->formated_created_at = $document->formated_created_at();

        $file->move("files/baraques_documents/" . $document->id . "/", $document->filename);

        return Response::json(['success' => 1, 'document' => $document]);
    }


    public function sync_photo_tab(Request $request)
    {

        $document =   BaraqueDocument::where('id', $request->id)->get()->first();
        if (is_null($document)) {
            return Response::json(['success' => 0, 'error' => 'DOCUMENT_NOT_FOUND']);
        } else {
            $file = $request->file('file');
            $document->file_size =  $file->getSize();
            $document->save();

            $file->move("files/baraques_documents/" . $document->id . "/", $document->filename);

            return Response::json(['success' => 1]);
        }
    }


    public function gerDouarsDatatable()
    {
        $douars = Douar::where('active', 1);

        $activated_douars = json_decode(Auth::user()->last_view_active_douars);
    

        return Datatables::eloquent($douars)

            ->addColumn('douar', function ($douar) {
                return '<span style="font-size:14px"><i class="fa-solid fa-map-location-dot mr-2"></i>' . '<span id="' . $douar->id . '" >' . $douar->nom . '</span></span>';
            })
            ->addColumn('actions', function ($douar) use ($activated_douars) {
                $active = false;
                foreach ($activated_douars as $activated_douar) {
                    if ($activated_douar->id == $douar->id) {
                        $active = true;
                    }
                }
                return '<input type="checkbox" id="' . $douar->id . '"   class="filled-in active_douar_cb" ' . ($active ? 'checked' : '') . '   />';
            })
            ->rawColumns(['douar', 'actions'])
            ->only(['douar', 'actions'])
            ->tojson();
    }

    public function basemap_tile(String $id, Int $z, Int $x, Int $y)
    {

        $path = base_path('files/basemap/' . $id . '/' . $z . '/' . $x . '/' . $y . '.png');


        if (file_exists($path)) {
            return response()->file($path);
        } {
            $path_jpg = base_path('files/basemap/' . $id . '/' . $z . '/' . $x . '/' . $y . '.jpg');
            if (file_exists($path_jpg)) {
                return response()->file($path_jpg);
            } {

                $transparent_img_path = base_path('files/basemap/transparent.png');
                return response()->file($transparent_img_path);
            }
        }
    }

    public function export_cin_photos()
    {
        $baraques = Baraque::where('active', 1)->get();
        foreach ($baraques as $baraque) {

            $PHOTO_MENAGE_CIN = $baraque->specific_documents("PHOTO_MENAGE_CIN");
            $PHOTO_CIN_CONJOINT = $baraque->specific_documents("PHOTO_MENAGE_CIN");
            $PHOTO_COMMERCE_CIN = $baraque->specific_documents("PHOTO_MENAGE_CIN");

            foreach ($PHOTO_MENAGE_CIN as $photo) {
                copy($photo->documentPath(), base_path('files/cin_photos/' . $photo->id . '.jpg'));
            }

            foreach ($PHOTO_CIN_CONJOINT as $photo) {
                copy($photo->documentPath(), base_path('files/cin_photos/' . $photo->id . '.jpg'));
            }

            foreach ($PHOTO_COMMERCE_CIN as $photo) {
                copy($photo->documentPath(), base_path('files/cin_photos/' . $photo->id . '.jpg'));
            }
        }
    }

    public function export_geometries()
    {
        $big_geojson = new stdClass();
        $big_geojson->type = "FeatureCollection";
        $big_geojson->crs = new stdClass();
        $big_geojson->crs->type = "name";
        $big_geojson->crs->properties = new stdClass();
        $big_geojson->crs->properties->name = "urn:ogc:def:crs:OGC:1.3:CRS84";
        $big_geojson->features = [];


        $baraques = Baraque::where('active', 1)->get();
        foreach ($baraques as $baraque) {
            if (!is_null($baraque->geometry)) {
                if (strlen($baraque->geometry) > 6) {
                    $feature = json_decode($baraque->geometry);

                    if (!is_null($feature)) {
                        $feature->properties = new stdClass();
                        $feature->properties->baraque_id = $baraque->id;
                        $feature->properties->numero = $baraque->equipe->prefix . $baraque->numero;
                        $big_geojson->features[] = $feature;
                    }

                    // foreach ($geojson->features as $feature) {

                    //     $feature->properties = new stdClass();
                    //     $feature->properties->baraque_id = $baraque->id;



                    //     // $feature->properties->equipe = $douar;
                    //     // $feature->properties->commune = $dossier->commune->nom;
                    //     // $feature->properties->cercle = $dossier->cercle->nom;
                    //     // $feature->properties->province = $dossier->province->nom;
                    //     // $feature->properties->cin =  $petitionnaire->cin;


                    //     $big_geojson->features[] = $feature;
                    // }
                }
            }
        }
        $fp = fopen(base_path("files/data.geojson"), 'w');
        fwrite($fp, json_encode($big_geojson));
        fclose($fp);
    }
}
