<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Douar;
use App\Models\SettingsActivites;
use App\Models\Appartement;
use App\Models\Mappe;
use App\Models\Commerce;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use stdClass;
use App\Models\PlanAmenagement;

use App\Models\Projet;

class CentreDonneesController extends Controller
{
    public function index()
    {
        $settingsActivites = SettingsActivites::all();
        return view('centre_donnees.index', ["settingsActivites" => $settingsActivites]);
    }

    public function get_projet(Request $request)
    {
        $projet = Projet::where('active', 1)->where("id", $request->id)->get()->first();
        return  $projet;
    }

    public function projets_datatable(Request $request)
    {
        $projets = Projet::where('active', 1);

        $menage_id = null;
        if (isset($request->menage_id)) {
            $menage_id = $request->menage_id;
        }
        if ($menage_id != null) {
            $menage = Menage::where('id', $menage_id)->with(['douar'])->get()->first();


            $projets = $projets->whereHas("appartements_douars", function ($query) use ($menage) {

                $query->where('appartements_douars.douar_id', '=', $menage->douar_id);
            });
        }

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }



            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $projets = $projets->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $projets = $projets->where($filter->column, '=', $filter->value);
                } else {
                    $projets = $projets->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }

        return Datatables::eloquent($projets)
            ->addColumn('projet', function ($projet) {
                return "<span style='color:#c0665b' ><span style='color:#c0665b'><i class='fa-solid fa-building-circle-arrow-right mr-2'></i>" . $projet->nom . "</span>";
            })
            ->addColumn('province', function ($projet) {
                return $projet->province->nom;
            })

            ->addColumn('promoteur', function ($projet) {
                return $projet->promoteur->societe;
            })
            ->addColumn('nbr_immeubles', function ($projet) {
                return $projet->immeubles->count();
            })
            ->addColumn('nbr_appartements', function ($projet) {
                return $projet->appartements->count();
            })
            ->addColumn('appartements_affectes', function ($projet) {
                return $projet->appartements->where('is_affected', 1)->count();
            })
            ->addColumn('taux_affectation', function ($projet) {

                $taux = round(($projet->appartements->where('is_affected', 1)->count() / $projet->appartements->count()) * 100, 2);
                return '<div class="progress mb-1">
                                    <div   class="progress-bar bg-info" role="progressbar" style="width: ' . $taux . '%;" aria-valuenow="' . $taux . '" aria-valuemin="0" aria-valuemax="100"> <span style="float: right;">' . $taux . ' %</span></div>
                                </div>';
            })
            ->addColumn('agence', function ($projet) {
                return  $projet->banque->agence;
            })
            ->addColumn('banque', function ($projet) {
                return  $projet->banque->banque;
            })
            ->addColumn('rib', function ($projet) {
                return  $projet->rib;
            })
            ->addColumn('actions', function ($projet) {

                return '<button projet_name="' . $projet->nom . '" projet_promoteur="' . $projet->promoteur->societe . '" id="' . $projet->id . '" type="button" class="btn btn-success affecter_projet_btn"><i class="fa-solid fa-check mr-1"></i>&nbsp;Affecter</button>';
            })

            ->rawColumns(['agence', 'banque', 'rib', 'actions', 'projet', 'province',  'promoteur', 'nbr_immeubles', 'nbr_appartements', 'appartements_affectes', 'taux_affectation'])
            ->only(['agence', 'banque', 'rib', 'actions', 'projet', 'province', 'promoteur', 'nbr_immeubles', 'nbr_appartements', 'appartements_affectes', 'taux_affectation'])
            ->tojson();
    }


    public function stock_datatable(Request $request)
    {
        $appartements = Appartement::where('active', 1)->where("projet_id", $request->projet_id);

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }


            if ($filter->column == 'assigne') {

                if($filter->value==1)
                {
    $appartements = $appartements->whereHas('douars');
                }
            
                continue;
            }
            if ($filter->column == 'affecte') {
                $appartements = $appartements->where('is_affected', $filter->value);
                continue;
            }
            if ($filter->column == 'tranche_id') {
                $appartements = $appartements->where($filter->column, $filter->value);
                continue;
            }

            if ($filter->column == 'immeuble_id') {
                $appartements = $appartements->where($filter->column, $filter->value);
                continue;
            }

            if ($filter->column == 'etage') {
                $appartements = $appartements->where("niveau", $filter->value);
                continue;
            }

            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $appartements = $appartements->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $appartements = $appartements->where($filter->column, '=', $filter->value);
                } else {
                    $appartements = $appartements->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }

        $appartements = $appartements->orderBy('tranche_id', 'ASC');

        return Datatables::eloquent($appartements)
            ->addColumn('numero', function ($appartement) {
                return " <span style='color:#c0665b;font-weight:500'><i class='fa-solid fa-building-circle-arrow-right mr-2'></i>" . $appartement->num . "</span>";
            })
            ->addColumn('numero_cb', function ($appartement) {
                return '<input type="checkbox" class="appartment_cb" item-id="' . $appartement->id . '" style="vertical-align: middle;margin-left:4px;">' . " <span style='color:#c0665b;font-weight:500'><i class='fa-solid fa-building-circle-arrow-right mr-2'></i>" . $appartement->num . "</span>";
            })
            ->addColumn('tranche', function ($appartement) {
                return $appartement->tranche->numero;
            })
            ->addColumn('immeuble', function ($appartement) {
                return $appartement->immeuble->numero;
            })
            ->addColumn('tf', function ($appartement) {
                return  $appartement->TF;
            })
            ->addColumn('surface', function ($appartement) {
                return $appartement->surface . " m²";
            })
            ->addColumn('niveau', function ($appartement) {
                if ($appartement->niveau == 0) {
                    return "RDC";
                }
                if ($appartement->niveau == 1) {
                    return "1er étage";
                }
                if ($appartement->niveau == 2) {
                    return "2ème étage";
                }
                if ($appartement->niveau == 3) {
                    return "3ème étage";
                }
                if ($appartement->niveau == 4) {
                    return "4ème étage";
                }
                if ($appartement->niveau == 5) {
                    return "5ème étage";
                }
                return  $appartement->niveau;
            })
            ->addColumn('douar', function ($appartement) {
                if ($appartement->douars->count() == 0) {
                    return '<span style="color:gray">Néant</span>';
                }

                if ($appartement->douars->count() == 1) {
                    return '<span style="color:black">' . $appartement->douars[0]->douar->nom . '</span>';
                }
                if ($appartement->douars->count() > 1) {

                    $html = '<select class="form-control select2nc">';
                    foreach ($appartement->douars as $douar) {
                        $html .= "<option>" . $douar->douar->nom . "</option>";
                    }
                    $html .= "</select>";
                    return $html;
                }
            })
            ->addColumn('affectation', function ($appartement) {

                if ($appartement->is_affected == 1) {
                    $menage = Menage::where("appartement_id", $appartement->id)->get()->first();
                    if (is_null($menage)) {
                        return '<span style="color:gray">Non</span>';
                    } else {
                        return '<a href="/menages/show/' . $menage->id . '" >' . $menage->chefs_menage_cin() . '</a>';
                    }
                } else {
                    return '<span style="color:gray">Non</span>';
                }
            })


            ->rawColumns(['numero_cb', 'numero', 'immeuble', 'tf', 'surface', 'niveau', 'affectation', 'douar', 'tranche'])
            ->only(['numero_cb', 'numero', 'immeuble', 'tf', 'surface', 'niveau', 'affectation', 'douar', 'tranche'])
            ->tojson();
    }





    public function mappe_getall(Request $request)
    {
        $mappes = Mappe::all();

        return $mappes;
    }

    public function mappe_datatable(Request $request)
    {
        $mappes = Mappe::where('active', 1);

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }



            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $mappes = $mappes->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $mappes = $mappes->where($filter->column, '=', $filter->value);
                } else {
                    $mappes = $mappes->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }

        return Datatables::eloquent($mappes)
            ->addColumn('numero', function ($mappe) {
                return "<a id='" . $mappe->id . "' href='javascript:void();'><span style='color:#115555'><i class='fa-solid fa-layer-group mr-2'></i>" . $mappe->num . "</span>";
            })
            ->addColumn('regime', function ($mappe) {
                return $mappe->regime;
            })
            ->addColumn('indice', function ($mappe) {
                return  $mappe->indice;
            })


            ->rawColumns(['numero', 'regime', 'indice'])
            ->only(['numero', 'regime', 'indice'])
            ->tojson();
    }


    public function pa_getall(Request $request)
    {
        $mappes = PlanAmenagement::all();

        return $mappes;
    }

    public function pa_datatable(Request $request)
    {
        $plan_amenagements = PlanAmenagement::where('active', 1);

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }



            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $plan_amenagements = $plan_amenagements->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $plan_amenagements = $plan_amenagements->where($filter->column, '=', $filter->value);
                } else {
                    $plan_amenagements = $plan_amenagements->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }

        return Datatables::eloquent($plan_amenagements)
            ->addColumn('zone', function ($plan_amenagement) {
                return "<a id='" . $plan_amenagement->id . "' href='javascript:void();'><span style='color:#115555'><i class='fa-solid fa-layer-group mr-2'></i>" . $plan_amenagement->zone . "</span>";
            })



            ->rawColumns(['zone'])
            ->only(['zone'])
            ->tojson();
    }
}
