<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Projet;
use App\Models\Menage;
use App\Models\User;
use App\Models\SettingsProduitType;
use Illuminate\Support\Facades\DB;
use App\Models\Arrondissement;
use App\Models\Baraque;
use Carbon\Carbon;
use App\Models\BaraqueDocument;
use stdClass;

class DashboardController extends Controller
{
    public function index()
    {
        if (Auth::user()->has_role('admin')) {

            $arrondissements = Arrondissement::orderBy('nom', 'ASC')->get();
            return view('dashboard.index', ["arrondissements" => $arrondissements]);
            //return redirect(route('menages'));
        }

        if (Auth::user()->has_role('verif') || Auth::user()->has_role('bet') || Auth::user()->has_role('banque') || Auth::user()->has_role('promoteur')) {
            return redirect(route('menages'));
        }

        if (Auth::user()->has_role('notaire') ) {
            return redirect(route('menages'));
        }


        if (Auth::user()->has_role('agent_terrain')) {
            return redirect(route('app_terrain'));
        }
    }


    public function getStats(Request $request)
    {
        $baraques = Baraque::where('active', 1)->with('menages')->with('commerces');

        if ($request->douar_id != "all") {
            $baraques =  $baraques->where('id_douar', $request->douar_id);
        }

        $baraques = $baraques->get();

        $result = new stdClass();
        $result->baraques_count = $baraques->count();
        $result->menages_count = 0;
        $result->commerces_count = 0;

        $result->menages_hommes = 0;
        $result->menages_femmes = 0;
        $result->menages_maries = 0;
        $result->menages_veufs = 0;
        $result->menages_celibataires = 0;
        $result->menages_divorces = 0;
        $result->menages_mere_celibataire = 0;
        $result->menages_abandonnes = 0;
        $result->baraques_occupees = 0;
        $result->baraques_vide = 0;
        $result->baraques_only_commerce = 0;
        $result->menages_divorces_h = 0;
        $result->menages_divorces_f = 0;
        $result->baraques_fermes = 0;

        $result->ATTRIBUTION_count = 0;
        $result->ATTRIBUTION_taux = 0;

        $result->decision_commision_valides_count = 0;
        $result->decision_commision_valides_taux = 0;

        $result->decision_commision_rejetes_count = 0;
        $result->decision_commision_rejetes_taux = 0;

        $result->decision_commision_ajournes_count = 0;
        $result->decision_commision_ajournes_taux = 0;

        $result->RECU_VERSEMENT_20000_count = 0;
        $result->RECU_VERSEMENT_20000_taux = 0;

        $result->PROJET_PV_AFFECTATION_count = 0;
        $result->PROJET_PV_AFFECTATION_taux = 0;

        $result->ATTESTATION_AFFECTATION_count = 0;
        $result->ATTESTATION_AFFECTATION_taux = 0;

        $result->REGLEMENT_AVANCE_80000_count = 0;
        $result->REGLEMENT_AVANCE_80000_taux = 0;

        $result->CONTRAT_VENTE_count = 0;
        $result->CONTRAT_VENTE_taux = 0;

        $result->ATTESTATION_REMISE_CLES_count = 0;
        $result->ATTESTATION_REMISE_CLES_taux = 0;



        foreach ($baraques as $baraque) {


            if ($baraque->ferme == 1) {
                $result->baraques_fermes++;
            }
            if ($baraque->ferme == 0 && $baraque->baraque_vide == 0) {
                foreach ($baraque->menages as $menage) {


                    $result->menages_count++;

                    if ($menage->sexe == "homme") {
                        $result->menages_hommes++;
                    }
                    if ($menage->sexe == "femme") {
                        $result->menages_femmes++;
                    }
                    if ($menage->situation == "Marié") {
                        $result->menages_maries++;
                    }
                    if ($menage->situation == "Divorcé") {
                        $result->menages_divorces++;
                        if ($menage->sexe == "homme") {
                            $result->menages_divorces_h++;
                        }
                        if ($menage->sexe == "femme") {

                            $result->menages_divorces_f++;
                        }
                    }
                    if ($menage->situation == "Célibataire") {
                        $result->menages_celibataires++;
                    }
                    if ($menage->situation == "Abandonné") {
                        $result->menages_abandonnes++;
                    }
                    if ($menage->situation == "Mère célibataire") {
                        $result->menages_mere_celibataire++;
                    }
                    if ($menage->situation == "Veuf") {
                        $result->menages_veufs++;
                    }

                    foreach ($menage->dossier_log as $log) {
                        if ($log->step == "ATTRIBUTION") {
                            $result->ATTRIBUTION_count++;
                        }
                        if ($log->step == "RECU_VERSEMENT_20000") {
                            $result->RECU_VERSEMENT_20000_count++;
                        }
                        if ($log->step == "PROJET_PV_AFFECTATION") {
                            $result->PROJET_PV_AFFECTATION_count++;
                        }
                        if ($log->step == "ATTESTATION_AFFECTATION") {
                            $result->ATTESTATION_AFFECTATION_count++;
                        }
                        if ($log->step == "REGLEMENT_AVANCE_80000") {
                            $result->REGLEMENT_AVANCE_80000_count++;
                        }
                        if ($log->step == "CONTRAT_VENTE") {
                            $result->CONTRAT_VENTE_count++;
                        }
                        if ($log->step == "ATTESTATION_REMISE_CLES") {
                            $result->ATTESTATION_REMISE_CLES_count++;
                        }
                    }

                    if ($menage->decision_commision == "validé") {
                        $result->decision_commision_valides_count++;
                    }
                    if ($menage->decision_commision == "rejeté") {
                        $result->decision_commision_rejetes_count++;
                    }
                    if ($menage->decision_commision == "ajourné") {
                        $result->decision_commision_ajournes_count++;
                    }
                }
            }
            foreach ($baraque->commerces as $commerce) {

                $result->commerces_count++;
            }

            if ($baraque->menages->count() == 0 && $baraque->commerces->count() > 0) {
                $result->baraques_only_commerce++;
            }

            if ($baraque->baraque_vide == 1 || ($baraque->menages->count() == 0 && $baraque->commerces->count() == 0)) {
                $result->baraques_vide++;
            }

            if ($baraque->menages->count() > 0  && $baraque->baraque_vide == 0) {
                $result->baraques_occupees++;
            }
        }
        //$result->baraques_count = $result->baraques_count - $result->baraques_only_commerce;
        $result->baraques_count = $result->baraques_count -  $result->baraques_fermes;



        if ($result->baraques_count == 0) {
            $result->taux_menages = 0;
            $result->baraques_occupees_taux = 0;
            $result->baraques_vide_taux = 0;
        } else {
            $result->taux_menages = round($result->menages_count / $result->baraques_count, 4);
            $result->baraques_occupees_taux = round($result->baraques_occupees / $result->baraques_count, 4);
            $result->baraques_vide_taux =  round($result->baraques_vide / $result->baraques_count, 4);
        }

        if ($result->menages_count > 0) {
            $result->ATTRIBUTION_taux = round($result->ATTRIBUTION_count / $result->menages_count, 4);
            $result->RECU_VERSEMENT_20000_taux = round($result->RECU_VERSEMENT_20000_count / $result->menages_count, 4);
        }

        if ($result->ATTRIBUTION_count > 0) {
            $result->decision_commision_valides_taux = round($result->decision_commision_valides_count / $result->ATTRIBUTION_count, 4);
            $result->decision_commision_rejetes_taux = round($result->decision_commision_rejetes_count / $result->ATTRIBUTION_count, 4);
            $result->decision_commision_ajournes_taux = round($result->decision_commision_ajournes_count / $result->ATTRIBUTION_count, 4);
        }

        if ($result->RECU_VERSEMENT_20000_count > 0) {
            $result->PROJET_PV_AFFECTATION_taux = round($result->PROJET_PV_AFFECTATION_count / $result->RECU_VERSEMENT_20000_count, 4);
            $result->ATTESTATION_AFFECTATION_taux = round($result->ATTESTATION_AFFECTATION_count / $result->RECU_VERSEMENT_20000_count, 4);
           
        }
        return $result;
    }

    public function evolution_des_avances_chart(Request $request)
    {
        $stats = new stdClass();
      
        $data=[];

        $menages = Menage::where('active', 1)->get();

        
        $documents = BaraqueDocument::where('type_document', "RECU_VERSEMENT_20000")->get();

        foreach($documents as $document)
        { 
 

            $date_doc = Carbon::createFromFormat('Y-m-d H:i:s',  $document->created_at)->endOfDay();

            $exists = false;
            foreach ($data as $row) {
                if ($row->date == $date_doc) {
                    $exists = true;
                    $row->value++;
                    break;
                }
            }
            if (!$exists) {
                $row = new stdClass();
                $row->date = $date_doc;
                $row->value = 1;
                $data[] = $row;
            }
        

           
        }

   
        $stats->data = [];
        $stats->values = [];


        if (count($data) > 0) {
            $min_date = $data[0]->date;
            $max_date = $data[0]->date;
            foreach ($data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);

       
            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($data as $row) {
                    if ($row->date == $date) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }
        return  $stats;

    }

    public function depot_dossiers_attribution_chart(Request $request)
    {
        $stats = new stdClass();
      
        $data=[];

        $menages = Menage::where('active', 1)->get();

        
        foreach($menages as $menage)
        { 

            if(!is_null($menage->decision_commision))
            {
                $date_demande = Carbon::createFromFormat('Y-m-d',  $menage->date_operation_decision_commision)->endOfDay();

                $exists = false;
                foreach ($data as $row) {
                    if ($row->date == $date_demande) {
                        $exists = true;
                        $row->value++;
                        break;
                    }
                }
                if (!$exists) {
                    $row = new stdClass();
                    $row->date = $date_demande;
                    $row->value = 1;
                    $data[] = $row;
                }
            }
        

           
        }

   
        $stats->data = [];
        $stats->values = [];


        if (count($data) > 0) {
            $min_date = $data[0]->date;
            $max_date = $data[0]->date;
            foreach ($data as $row) {

                if ($row->date->lessThan($min_date)) {
                    $min_date = $row->date;
                }

                if ($row->date->greaterThan($max_date)) {
                    $max_date = $row->date;
                }
            }
            $dates =  $this->generateDateRange($min_date, $max_date);

       
            foreach ($dates as  $date) {
                $stats->data[] = $date->format('d/m/Y');
                $value = 0;
                foreach ($data as $row) {
                    if ($row->date == $date) {
                        $value = $row->value;
                    }
                }
                $stats->values[] = $value;
            }
        }
        return  $stats;
    }

    private function generateDateRange(Carbon $start_date, Carbon $end_date)
    {
        $dates = [];

        for ($date = $start_date->copy(); $date->lte($end_date); $date->addDay()) {
            $dates[] =  Carbon::createFromFormat('Y-m-d', $date->format('Y-m-d'))->endOfDay();;
        }

        return $dates;
    }
}
