<?php

namespace App\Http\Controllers;

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
use App\Models\QR_Code;
use App\Models\Menage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\EtudePV;
use Carbon\Carbon;
use App\Models\PV_TAS;

use stdClass;
use Response;
use UnderflowException;

class DocumentGeneratorController extends Controller
{

    public function generate_AUTORISATION_VERSEMENT(Request $request)
    {


        $prefix = "AV";
        $target_id = $request->menage_id;

        $menage = Menage::where('id', $request->menage_id)->get()->first();
        if (is_null($menage)) {
            return Response::json(['success' => 0, 'error' => 'MENAGE_NOT_FOUND']);
        }
        if (is_null($menage->projet)) {
            return Response::json(['success' => 0, 'error' => 'PROJET_NOT_AFFECTED']);
        }

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $created_index = app('App\Http\Controllers\IndexingController')->store('AUTORISATION_VERSEMENT', $request->menage_id);
        $reference = "AV-" . $created_index->year . '-' . $created_index->month . '-' . $created_index->day . '-' . $created_index->numero;

        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = "AUTORISATION_VERSEMENT";
        $qr_code->target_id = $target_id;
        $qr_code->save();


        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' "' . $reference . '"';
        $qr_code->last_command = $command;
        $qr_code->save();

        $output = exec($command);

        $pdf_url = asset('files/generated/' . $qr_code->id . '/' . $reference . '.pdf');

        return Response::json(['success' => 1, 'generated_document_url' => $pdf_url]);
    }

    public function generate_ATTESTATION_ATTRIBUTION(Request $request)
    {
        $prefix = "AV";
        $target_id = $request->menage_id;

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $created_index = app('App\Http\Controllers\IndexingController')->store('ATTESTATION_ATTRIBUTION', $request->menage_id);
        $reference = "AAT-" . $created_index->year . '-' . $created_index->month . '-' . $created_index->day . '-' . $created_index->numero;

        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = "ATTESTATION_ATTRIBUTION";
        $qr_code->target_id = $target_id;
        $qr_code->save();


        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' "' . $reference . '"';
        $qr_code->last_command = $command;
        $qr_code->save();

        $output = exec($command);

        $pdf_url = asset('files/generated/' . $qr_code->id . '/' . $reference . '.pdf');

        return Response::json(['success' => 1, 'generated_document_url' => $pdf_url]);

        // $headers = array(
        //     'Content-Type: application/pdf',
        // );
        // return Response::download($pdf_path, $qr_code->type . ".pdf", $headers, 'inline');
    }



    public function generate_PV_ETUDE(string $pv_etude_id)
    {
        $pv_etude = EtudePV::where('id', $pv_etude_id)->get()->first();
        $target_id = $pv_etude_id;

        $prefix = "PVT";

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = "PV_ETUDE";
        $qr_code->target_id = $target_id;
        $qr_code->save();


        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' > /dev/null &';
        $qr_code->last_command = $command;
        $qr_code->save();

        exec($command);

        $pdf_url = asset('files/generated/' . $qr_code->id . '/' . $pv_etude->reference . '.pdf');

        return Response::json(['success' => 1, 'generated_document_url' => $pdf_url]);
    }


    public function generate_PV_TAS_STOCK(string $pv_tas_id)
    {
        $pv_tas = PV_TAS::where('id', $pv_tas_id)->get()->first();
        $pv_tas->stock_generating = 1;

        $pv_tas->save();
        $target_id = $pv_tas_id;
        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' PV_TAS_STOCK NULL ' . $target_id . ' > /dev/null &';
        exec($command);

        return Response::json(['success' => 1]);
    }

    public function generate_PV_TAS(string $pv_tas_id)
    {
        $pv_tas = PV_TAS::where('id', $pv_tas_id)->get()->first();
        $target_id = $pv_tas_id;

        $prefix = "PVT";

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = "PV_TAS";
        $qr_code->target_id = $target_id;
        $qr_code->save();


        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' > /dev/null &';
        $qr_code->last_command = $command;
        $qr_code->save();

        exec($command);

        $pdf_url = asset('files/generated/' . $qr_code->id . '/' . $pv_tas->reference . '.pdf');

        return Response::json(['success' => 1, 'generated_document_url' => $pdf_url]);
    }


    public function generate_PV_TAS_BONS(string $pv_tas_id)
    {
        $pv_tas = PV_TAS::where('id', $pv_tas_id)->get()->first();
        $target_id = $pv_tas_id;

        $prefix = "PVT";

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = "BONS";
        $qr_code->target_id = $target_id;
        $qr_code->save();


        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' > /dev/null &';
        $qr_code->last_command = $command;
        $qr_code->save();

        exec($command);

        $pdf_url = asset('files/generated/' . $qr_code->id . '/' . $pv_tas->reference . '-Bons.pdf');

        return Response::json(['success' => 1, 'generated_document_url' => $pdf_url]);
    }
}
