<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\GBaraque;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Douar;
use App\Models\SettingsActivites;
use App\Models\Commerce;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use stdClass;
use App\Models\Ortophoto;
use App\Models\Arrondissement;
use App\Models\AnnexeAdministrative;
use App\Models\Province;

class GeoportailController extends Controller
{
    public function index()
    {
        $douars = Douar::all();
        $douars_ortho = Ortophoto::all();
        $annexes_administratives = AnnexeAdministrative::all();
        $arrondissements = Arrondissement::orderBy('nom', 'asc')->get();
        $provinces = Province::orderBy('nom', 'asc')->get();
        return view('geoportail.index', [
            'douars_ortho' => $douars_ortho,
            'douars' => $douars,
            'annexes_administratives' => $annexes_administratives,
            'arrondissements' => $arrondissements,
            'provinces' => $provinces,
        ]);
    }

    public function map_get_baraques(Request $request)
    {
        $result = [];

        $filters = json_decode($request->filters);
        $baraques = Baraque::with('equipe')->where('active', 1)->whereNot('lat', 0);

        foreach ($filters as $filter) {

            if ($filter->column == 'situation') {
                $baraques = $baraques->whereHas('menages', function ($query) use ($filter) {
                    $query->where('menages.situation', '=', $filter->value);
                });
                continue;
            }


            if ($filter->column == 'chef_menage_cin') {
                $baraques = $baraques->whereHas('menages', function ($query) use ($filter) {
                    $query->where('menages.chef_menage_cin', '=', $filter->value);
                });
                continue;
            }
            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));
                $to->addDay();
                $baraques = $baraques->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $baraques = $baraques->where($filter->column, '=', $filter->value);
                } else {
                    $baraques = $baraques->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, '=', $filter->value);
                    });
                }
            }
        }


        $baraques = $baraques->with('orthophotos')->orderBy('created_at', 'desc')->get();



        foreach ($baraques as $baraque) {
            $plle = new stdClass();
            $plle->id = $baraque->id;
            $plle->numero = $baraque->full_num;
            $plle->color = $baraque->equipe->color;
            $plle->lat = $baraque->lat;
            $plle->lng = $baraque->lng;
            $plle->geometry = $baraque->geometry;
            $plle->orthophotos = [];
            foreach ($baraque->orthophotos as $ortho) {
                $plle->orthophotos[] = $ortho->orthophotoR_id;
            }

            $result[] = $plle;
        }


        return $result;
    }

    public function baraques_datatable(Request $request)
    {
        $filters = json_decode($request->filters);

        $baraques = Baraque::with('douar')->where('active', 1)->whereNotNull('douar_vf_id')->where('all_menages_verified', 1);

        foreach ($filters as $filter) {


            if ($filter->column == 'situation') {
                $baraques = $baraques->whereHas('menages', function ($query) use ($filter) {
                    $query->where('g_menages.situation', '=', $filter->value);
                });
                continue;
            }
            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));
                $to->addDay();
                $baraques = $baraques->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $baraques = $baraques->where($filter->column, '=', $filter->value);
                } else {
                    $baraques = $baraques->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, '=', $filter->value);
                    });
                }
            }
        }

        $baraques = $baraques->limit($request->limit)->offset($request->offset);


        return Datatables::of($baraques)
            ->addColumn('row', function ($baraque) {
                $etat = "";
                $accent_color = "#e5702e";
                $html = '<div  class="row dossier_row" lat="' . $baraque->lat . '" lng="' . $baraque->lng . '" item_id="' . $baraque->id . '"  >
                            <div class="col-2" style="padding:0px;opacity:0.8; background: ' . $accent_color . ';border-radius: 6px 0px 0px 6px;border-right: 1px #9d9d9d dashed;    height: 48px;">
                               <svg fill="#ffffff" style="height: 36px; display: block; margin: auto; margin-top: 8px;"  version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <path d="M488.724,442.178h-23.272V210.59l10.581,6.884c3.918,2.551,8.318,3.769,12.669,3.769c7.609,0,15.07-3.728,19.53-10.583 c7.01-10.774,3.958-25.189-6.816-32.2L268.692,27.04c-7.719-5.019-17.67-5.019-25.384,0L10.583,178.46 c-10.775,7.01-13.824,21.426-6.816,32.2c7.01,10.774,21.425,13.825,32.2,6.816l10.578-6.884V442.18H23.273 c-12.851,0-23.272,10.42-23.272,23.272s10.421,23.272,23.272,23.272h46.545h139.635h93.09h139.635h46.545 c12.854,0,23.272-10.42,23.272-23.272C511.996,452.598,501.578,442.178,488.724,442.178z M325.817,442.178h-23.272h-23.272 h-46.545h-23.272h-23.272V310.301c0-12.853,10.421-23.272,23.272-23.272h93.09c12.854,0,23.272,10.42,23.272,23.272V442.178z"></path> </g> </g> </g></svg>
                            </div>
                            <div class="col-10">
                                <b style="margin-top: 6px;color: #616161; border-bottom: 1px #7e7e7e dashed; width: 100%; display: block;"> Baraque numéro : ' . (is_null($baraque->full_num) ? '<span style="color:#9c9c9c">Néant</span>' : '<span style="color:#e5702e">' . $baraque->full_num . '</span>') . ' <b style="color: #787878; float: right; display: block; font-weight: 400;"> ' .   '</b></b>
                                <span style="margin-top: 6px;display:block;color: #616161 ; font-weight: 400; font-family: Roboto;">Douar : <span style="color:#e5702e">' . (is_null($baraque->douar) ? "-" : $baraque->douar->nom) . '</span></span>
                            </div>     
                        </div>';

                return $html;
            })


            ->rawColumns(['row'])
            ->only(['row'])
            ->make(true);
    }

    public function baraque_data(string $id)
    {
        $baraque = Baraque::with("menages")->with("commerces")->with("documents")->where('id', $id)->get()->first();
        return $baraque;
    }
}
