<?php

namespace App\Http\Controllers;

use App\Models\AnnexeAdministrative;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Projet;
use App\Models\Douar;
use App\Models\SettingsActivites;
use App\Models\Commerce;
use App\Models\Province;
use App\Models\Arrondissement;
use App\Models\Role;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use stdClass;

class GestionComptesController extends Controller
{
    public function index()
    {  
        $arrondissements = Arrondissement::all();
        $provinces = Province::all();
        $role_prestataires = Role::whereIn('name', ['bet', 'promoteur', 'notaire'])->get();
        return view('gestion_comptes.index', [
            'provinces' => $provinces,
            'arrondissements' => $arrondissements,
            'role_prestataires' => $role_prestataires,
        ]);
        
    }


    public function comptes_datatable(Request $request)
    {
        $filters = json_decode($request->filters);
        $prestataires = User::with('role')->where([['active', 1]]);

   

        $prestataires = $prestataires->orderBy('created_at', 'desc')->get();


     
        return Datatables::of($prestataires)
            ->addColumn('email', function ($prestataire) {

                if($prestataire->has_role("notaire"))
                {
                    return '<input style="vertical-align: middle;position: relative;" class="prestataire_cb" item_id="' . $prestataire->id . '" type="checkbox">&nbsp<a class="prestataire_a" item_id="' . $prestataire->id . '" href="javascript:;" >' . $prestataire->email .($prestataire->notaire_etude==1?'<b style="color: cornflowerblue;"> (étude)</b>':''). '</a>';

                }
                else{
                    return '<input style="vertical-align: middle;position: relative;" class="prestataire_cb" item_id="' . $prestataire->id . '" type="checkbox">&nbsp<a class="prestataire_a" item_id="' . $prestataire->id . '" href="javascript:;" >' . $prestataire->email . '</a>';

                }
            })
            ->addColumn('nom', function ($prestataire) {
                return $prestataire->nom;
            })
            ->addColumn('prenom', function ($prestataire) {
                return $prestataire->prenom;
            })
            ->addColumn('tel', function ($prestataire) {
                return $prestataire->tel;
            })
            ->addColumn('organisme_ste', function ($prestataire) {
                return $prestataire->organisme_ste;
            })
            ->addColumn('type', function ($prestataire) {
                return $prestataire->role->full_name;
            })
            ->addColumn('date', function ($prestataire) {

                return Carbon::createFromFormat('Y-m-d H:i:s', $prestataire->created_at)->format('d/m/Y H:i');
            })       
      
            ->addColumn('invitation', function ($prestataire) {
                return  $prestataire->invitation_status();
            })


            ->rawColumns(['invitation','email'])
            ->make(true);
    }





    public function check_permission($compte)
    {
        if (Auth::user()->has_role('Administrateur')) {

            // if ($dossier->filiale_id != Auth::user()->filiale_id) {

            //     abort(404);

            // }

        }
    }


}
