<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Carbon\Carbon;
use Illuminate\Http\Request;
use App\Models\Index;

class IndexingController extends Controller
{

    public function store($type, $target_id = null)
    {
        if ($type == "AUTORISATION_VERSEMENT") {
            $old_index = Index::where([['type', $type], ['target_id', $target_id]])->get()->first();
            if (!is_null($old_index)) {
                return $old_index;
            }
        }
        $now = Carbon::now();
        $index = new Index();
        $index->id = Str::uuid();
        $index->user_id = Auth::user()->id;
        $index->type = $type;
        $index->year = $now->year;
        $index->month = $now->month;
        $index->day = $now->day;
        $index->target_id = $target_id;

        $last_numero = Index::where([['type', $index->type], ['year', $index->year], ['month', $index->month], ['day', $index->day]])->max('numero');
        $index->numero =   $last_numero + 1;
        $index->save();

        return  $index;
    }
}
