<?php

namespace App\Http\Controllers;

use App\Models\AnnexeAdministrative;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\ChefMenage;
use App\Models\ChefMenageModif;
use App\Models\EnqMenage;

use App\Models\MenageDocument;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Douar;
use App\Models\Secteur;
use App\Models\SettingsActivites;
use App\Models\Commerce;
use App\Models\Projet;

use App\Models\Province;
use App\Models\Appartement;
use App\Models\Arrondissement;
use App\Models\DossierFinancement;
use App\Models\DossierAssocieCredit;
use App\Models\Ortophoto;
use App\Models\DossierLog;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use stdClass;
use App\Models\EtudePV;
use App\Models\EtudePV_Dossier;
use App\Models\EtudePV_Membre;
use App\Models\SituationScolarite;
use App\Models\PV_TAS;
use App\Models\PV_TAS_Dossier;
use App\Models\PV_TAS_Membre;



class MenagesController extends Controller
{
    public function index()
    {
        $douars = Douar::all();
        $secteurs = Secteur::all();
        $annexes_administratives = AnnexeAdministrative::all();
        $arrondissements = Arrondissement::orderBy('nom', 'asc')->get();
        $provinces = Province::orderBy('nom', 'asc')->get();

        $projets = Projet::where('active', 1)->get();
        if (Auth::user()->has_role('admin,verif,bet,banque,notaire')) {
            return view('menages.index', [
                'douars' => $douars,
                'secteurs' => $secteurs,
                'annexes_administratives' => $annexes_administratives,
                'arrondissements' => $arrondissements,
                'provinces' => $provinces,
                'projets' =>  $projets
            ]);
        }
    }
    public function show(String $id)
    {
        $menage = Menage::with(['projets_destination', 'chefs_menage', 'douar', 'annexe_administrative', 'arrondissement', 'province', 'ratissage', 'dossier_financement', 'dossier_financement.associes', 'projet', 'immeuble', 'appartement'])->find($id);
        if ($menage->active == 0) {
            abort(404);
        }
        $test = true;
        $notaires = User::whereHas('role', function ($query) {
            $query->where('name', 'notaire');
        })->get();
        $banques = User::whereHas('role', function ($query) {
            $query->where('name', 'banque');
        })->get();
        $this->check_permission($menage);

        // get the first chef menage
        $chef_menage = $menage->chefs_menage->first();

        $ATTESTATION_DEMOLITION_document = [
            'type_document' => 'ATTESTATION_DEMOLITION',
            'name' => 'Attestation de Démolition',
            'document' => null,
            'file_type' => 'pdf'
        ];
        if ($chef_menage) {
            $ATTESTATION_DEMOLITION_document['document'] = MenageDocument::where('chef_menage_id', $chef_menage->id)
                ->where('type_document', 'ATTESTATION_DEMOLITION')
                ->first();
        }


        $ENGAGEMENT_document = [
            'type_document' => 'ENGAGEMENT',
            'name' => "Engagement",
            'document' => $menage->specific_document('ENGAGEMENT'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('ENGAGEMENT'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,

        ];



        $affectation_p1_files_list = [
            [
                'type_document' => 'AUTORISATION_VERSEMENT',
                'name' => "Autorisation de versement",
                'document' => $menage->specific_document('AUTORISATION_VERSEMENT'),
                'file_type' => 'pdf',
                'w_roles' => 'bet',
                'r_roles' => 'all',
                'active' =>  $menage->document_can_be_imported('AUTORISATION_VERSEMENT'),
                'validation' => 1,
                'date_doc' => 0,
            ],
            [
                'type_document' => 'RECU_VERSEMENT_20000',
                'name' => "Recu de versement 20 000 DH",
                'document' => $menage->specific_document('RECU_VERSEMENT_20000'),
                'file_type' => 'pdf',
                'w_roles' => 'banque,bet',
                'r_roles' => 'all',
                'active' => $menage->document_can_be_imported('RECU_VERSEMENT_20000'),
                'validation' => 1,
                'date_doc' => 0,
            ],
            [
                'type_document' => 'ENGAGEMENT_BANQUE',
                'name' => "Engagement de la banque",
                'document' => $menage->specific_document('ENGAGEMENT_BANQUE'),
                'file_type' => 'pdf',
                'w_roles' => 'banque,bet',
                'r_roles' => 'all',
                'active' => $menage->document_can_be_imported('ENGAGEMENT_BANQUE'),
                'validation' => 1,
                'date_doc' => 0,
            ],
        ];
        $bon_tirage_au_sort = [
            'type_document' => 'BON_TIRAGE_AU_SORT',
            'name' => "Bon de tirage au sort",
            'document' => $menage->specific_document('BON_TIRAGE_AU_SORT'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('BON_TIRAGE_AU_SORT'),
            'validation' => 1,
            'date_doc' => 0
        ];


        $ATTESTATION_ATTRIBUTION_doc =  [
            'type_document' => 'ATTESTATION_ATTRIBUTION',
            'name' => "Attestation d'attribution",
            'document' => $menage->specific_document('ATTESTATION_ATTRIBUTION'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('ATTESTATION_ATTRIBUTION'),
            'validation' => 1,
            'date_doc' => 0
        ];
        $ATTESTATION_ATTRIBUTION_signee_doc =  [
            'type_document' => 'ATTESTATION_ATTRIBUTION_SIGNEE',
            'name' => "Attestation d'attribution (signée par le bénificiaire)",
            'document' => $menage->specific_document('ATTESTATION_ATTRIBUTION_SIGNEE'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' =>  $menage->document_can_be_imported('ATTESTATION_ATTRIBUTION_SIGNEE'),
            'validation' => 1,
            'date_doc' => 0
        ];

        $affectation_p2_files_list = [
            [
                'type_document' => 'ACCUSE_RECEPTION_AFFECTATION_BET',
                'name' => "Accusé de réception (BET)",
                'document' => $menage->specific_document('ACCUSE_RECEPTION_AFFECTATION_BET'),
                'file_type' => 'pdf',
                'w_roles' => 'bet',
                'r_roles' => 'all',
                'active' => $menage->document_can_be_imported('ACCUSE_RECEPTION_AFFECTATION_BET'),
                'validation' => 1,
                'date_doc' => 0
            ],
            [
                'type_document' => 'ACCUSE_RECEPTION_AFFECTATION_NOTAIRE',
                'name' => "Accusé de réception (Notaire)",
                'document' => $menage->specific_document('ACCUSE_RECEPTION_AFFECTATION_NOTAIRE'),
                'file_type' => 'pdf',
                'w_roles' => 'notaire',
                'r_roles' => 'all',
                'active' => $menage->document_can_be_imported('ACCUSE_RECEPTION_AFFECTATION_NOTAIRE'),
                'validation' => 1,
                'date_doc' => 0
            ],
        ];

        $recu_versement_fond_propre = [
            'type_document' => 'RECU_VERSEMENT_FOND_PROPRE',
            'name' => "Recu de versement",
            'document' => $menage->specific_document('RECU_VERSEMENT_FOND_PROPRE'),
            'file_type' => 'pdf',
            'w_roles' => 'banque,bet',
            'r_roles' => 'all',
            'active' => 1,
            'validation' => 1,
            'date_doc' => 0
        ];
        $contrat_vente = [
            'type_document' => 'CONTRAT_VENTE',
            'name' => "Contrat de vente",
            'document' => $menage->specific_document('CONTRAT_VENTE'),
            'file_type' => 'pdf',
            'w_roles' => 'notaire',
            'r_roles' => 'all',
            'active' => 1,
            'validation' => 1,
            'date_doc' => 0
        ];
        $attestation_remise_cles = [
            'type_document' => 'ATTESTATION_REMISE_CLES',
            'name' => "Attestation de la remise des cles",
            'document' => $menage->specific_document('ATTESTATION_REMISE_CLES'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => 1,
            'validation' => 1,
            'date_doc' => 0
        ];
        $compromis_vente = [
            'type_document' => 'COMPROMIS_VENTE',
            'name' => "Compromis vente",
            'document' => $menage->specific_document('COMPROMIS_VENTE'),
            'file_type' => 'pdf',
            'w_roles' => 'notaire',
            'r_roles' => 'all',
            'active' => 1,
            'validation' => 1,
            'date_doc' => 0
        ];
        $AUTORISATION_VERSEMENT_id = 'null';
        $AUTORISATION_VERSEMENT_date_document = 'null';
        $RECU_VERSEMENT_20000_id = 'null';
        $RECU_VERSEMENT_20000_date_document = 'null';
        $BON_TIRAGE_AU_SORT_id = 'null';
        $BON_TIRAGE_AU_SORT_date_document = 'null';
        $PROJET_PV_AFFECTATION_id = 'null';
        $PROJET_PV_AFFECTATION_date_document = 'null';
        $ATTESTATION_AFFECTATION_id = 'null';
        $ATTESTATION_AFFECTATION_date_document = 'null';
        $ACCUSE_RECEPTION_AFFECTATION_BET_id = 'null';
        $ACCUSE_RECEPTION_AFFECTATION_BET_date_document = 'null';
        $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_id = 'null';
        $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_date_document = 'null';
        $RECU_VERSEMENT_CREDIT_id = 'null';
        $RECU_VERSEMENT_CREDIT_date_document = 'null';
        $CONTRAT_VENTE_id = 'null';
        $CONTRAT_VENTE_date_document = 'null';
        $ATTESTATION_REMISE_CLES_id = 'null';
        $ATTESTATION_REMISE_CLES_date_document = 'null';
        $COMPROMIS_VENTE_id = 'null';
        $COMPROMIS_VENTE_date_document = 'null';
        $CIN_DOSSIER_ATTRIBUTION_id = 'null';
        $CIN_DOSSIER_ATTRIBUTION_date_document = 'null';
        $CIN_CONJOINT_DOSSIER_ATTRIBUTION_id = 'null';
        $CIN_CONJOINT_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_id = 'null';
        $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_id = 'null';
        $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_id = 'null';
        $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_id = 'null';
        $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_id = 'null';
        $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_date_document = 'null';
        $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_id = 'null';
        $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_date_document = 'null';
        $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_id = 'null';
        $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_date_document = 'null';
        $AUTORISATION_VERSEMENT = $menage->specific_document('AUTORISATION_VERSEMENT');
        if (!is_null($AUTORISATION_VERSEMENT)) {
            $AUTORISATION_VERSEMENT_id =  $AUTORISATION_VERSEMENT->id;
            $AUTORISATION_VERSEMENT_date_document = Carbon::createFromFormat('Y-m-d', $AUTORISATION_VERSEMENT->date_document)->format('d/m/Y');
        }
        $RECU_VERSEMENT_20000 = $menage->specific_document('RECU_VERSEMENT_20000');
        if (!is_null($RECU_VERSEMENT_20000)) {
            $RECU_VERSEMENT_20000_id =  $RECU_VERSEMENT_20000->id;
            $RECU_VERSEMENT_20000_date_document = Carbon::createFromFormat('Y-m-d', $RECU_VERSEMENT_20000->date_document)->format('d/m/Y');
        }
        $BON_TIRAGE_AU_SORT = $menage->specific_document('BON_TIRAGE_AU_SORT');
        if (!is_null($BON_TIRAGE_AU_SORT)) {
            $BON_TIRAGE_AU_SORT_id =  $BON_TIRAGE_AU_SORT->id;
            $BON_TIRAGE_AU_SORT_date_document = Carbon::createFromFormat('Y-m-d', $BON_TIRAGE_AU_SORT->date_document)->format('d/m/Y');
        }
        $PROJET_PV_AFFECTATION = $menage->specific_document('PROJET_PV_AFFECTATION');
        if (!is_null($PROJET_PV_AFFECTATION)) {
            $PROJET_PV_AFFECTATION_id =  $PROJET_PV_AFFECTATION->id;
            $PROJET_PV_AFFECTATION_date_document = Carbon::createFromFormat('Y-m-d', $PROJET_PV_AFFECTATION->date_document)->format('d/m/Y');
        }
        $ATTESTATION_AFFECTATION = $menage->specific_document('ATTESTATION_AFFECTATION');
        if (!is_null($ATTESTATION_AFFECTATION)) {
            $ATTESTATION_AFFECTATION_id =  $ATTESTATION_AFFECTATION->id;
            $ATTESTATION_AFFECTATION_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_AFFECTATION->date_document)->format('d/m/Y');
        }
        $ACCUSE_RECEPTION_AFFECTATION_BET = $menage->specific_document('ACCUSE_RECEPTION_AFFECTATION_BET');
        if (!is_null($ACCUSE_RECEPTION_AFFECTATION_BET)) {
            $ACCUSE_RECEPTION_AFFECTATION_BET_id =  $ACCUSE_RECEPTION_AFFECTATION_BET->id;
            $ACCUSE_RECEPTION_AFFECTATION_BET_date_document = Carbon::createFromFormat('Y-m-d', $ACCUSE_RECEPTION_AFFECTATION_BET->date_document)->format('d/m/Y');
        }
        $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE = $menage->specific_document('ACCUSE_RECEPTION_AFFECTATION_NOTAIRE');
        if (!is_null($ACCUSE_RECEPTION_AFFECTATION_NOTAIRE)) {
            $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_id =  $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE->id;
            $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_date_document = Carbon::createFromFormat('Y-m-d', $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE->date_document)->format('d/m/Y');
        }
        $RECU_VERSEMENT_CREDIT = $menage->specific_document('RECU_VERSEMENT_CREDIT');
        if (!is_null($RECU_VERSEMENT_CREDIT)) {
            $RECU_VERSEMENT_CREDIT_id =  $RECU_VERSEMENT_CREDIT->id;
            $RECU_VERSEMENT_CREDIT_date_document = Carbon::createFromFormat('Y-m-d', $RECU_VERSEMENT_CREDIT->date_document)->format('d/m/Y');
        }
        $CONTRAT_VENTE = $menage->specific_document('CONTRAT_VENTE');
        if (!is_null($CONTRAT_VENTE)) {
            $CONTRAT_VENTE_id =  $CONTRAT_VENTE->id;
            $CONTRAT_VENTE_date_document = Carbon::createFromFormat('Y-m-d', $CONTRAT_VENTE->date_document)->format('d/m/Y');
        }
        $ATTESTATION_REMISE_CLES = $menage->specific_document('ATTESTATION_REMISE_CLES');
        if (!is_null($ATTESTATION_REMISE_CLES)) {
            $ATTESTATION_REMISE_CLES_id =  $ATTESTATION_REMISE_CLES->id;
            $ATTESTATION_REMISE_CLES_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_REMISE_CLES->date_document)->format('d/m/Y');
        }
        $COMPROMIS_VENTE = $menage->specific_document('COMPROMIS_VENTE');
        if (!is_null($COMPROMIS_VENTE)) {
            $COMPROMIS_VENTE_id =  $COMPROMIS_VENTE->id;
            $COMPROMIS_VENTE_date_document = Carbon::createFromFormat('Y-m-d', $COMPROMIS_VENTE->date_document)->format('d/m/Y');
        }
        $CIN_DOSSIER_ATTRIBUTION = $menage->specific_document('CIN_DOSSIER_ATTRIBUTION');
        if (!is_null($CIN_DOSSIER_ATTRIBUTION)) {
            $CIN_DOSSIER_ATTRIBUTION_id =  $CIN_DOSSIER_ATTRIBUTION->id;
            $CIN_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $CIN_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $CIN_CONJOINT_DOSSIER_ATTRIBUTION = $menage->specific_document('CIN_CONJOINT_DOSSIER_ATTRIBUTION');
        if (!is_null($CIN_CONJOINT_DOSSIER_ATTRIBUTION)) {
            $CIN_CONJOINT_DOSSIER_ATTRIBUTION_id =  $CIN_CONJOINT_DOSSIER_ATTRIBUTION->id;
            $CIN_CONJOINT_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $CIN_CONJOINT_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION = $menage->specific_document('ACTE_MARRIAGE_DOSSIER_ATTRIBUTION');
        if (!is_null($ACTE_MARRIAGE_DOSSIER_ATTRIBUTION)) {
            $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_id =  $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION->id;
            $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION = $menage->specific_document('ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION');
        if (!is_null($ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION)) {
            $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_id =  $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION->id;
            $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ACTE_DIVORCE_DOSSIER_ATTRIBUTION = $menage->specific_document('ACTE_DIVORCE_DOSSIER_ATTRIBUTION');
        if (!is_null($ACTE_DIVORCE_DOSSIER_ATTRIBUTION)) {
            $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_id =  $ACTE_DIVORCE_DOSSIER_ATTRIBUTION->id;
            $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ACTE_DIVORCE_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION = $menage->specific_document('ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION');
        if (!is_null($ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION)) {
            $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_id =  $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION->id;
            $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION = $menage->specific_document('ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION');
        if (!is_null($ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION)) {
            $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_id =  $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION->id;
            $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION = $menage->specific_document('ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION');
        if (!is_null($ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION)) {
            $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_id =  $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION->id;
            $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }
        $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION = $menage->specific_document('CERTIFICAT_DECES_DOSSIER_ATTRIBUTION');
        if (!is_null($CERTIFICAT_DECES_DOSSIER_ATTRIBUTION)) {
            $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_id =  $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION->id;
            $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_date_document = Carbon::createFromFormat('Y-m-d', $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION->date_document)->format('d/m/Y');
        }

        $first = true;;
        foreach ($menage->chefs_menage as $chef_menage) {
            $chef_menage->first = $first;
            $first = false;

            $chef_menage->documents = [
                [
                    'type_document' => 'CM_MENAGE_CIN',
                    'name' => "CIN Chef de ménage",
                    'document' => $chef_menage->specific_document('CM_MENAGE_CIN'),
                    'file_type' => 'pdf',
                    'w_roles' => 'bet,gu',
                    'r_roles' => 'all',
                    'active' =>  $chef_menage->document_can_be_imported('CM_MENAGE_CIN'),
                    'validation' => 1,
                    'date_doc' => 0,
                    'show' => 1
                ],

                [
                    'type_document' => 'CM_ACT_DECES',
                    'name' => "Acte de décès",
                    'document' => $chef_menage->specific_document('CM_ACT_DECES'),
                    'file_type' => 'pdf',
                    'w_roles' => 'bet,gu',
                    'r_roles' => 'all',
                    'active' =>  $chef_menage->document_can_be_imported('CM_ACT_DECES'),
                    'validation' => 1,
                    'date_doc' => 0,
                    'show' => 1
                ],


                [
                    'type_document' => 'CM_ATT_ADMINISTRATIVE',
                    'name' => "Attestation administrative",
                    'document' => $chef_menage->specific_document('CM_ATT_ADMINISTRATIVE'),
                    'file_type' => 'pdf',
                    'w_roles' => 'bet,gu',
                    'r_roles' => 'all',
                    'active' =>  $chef_menage->document_can_be_imported('CM_ATT_ADMINISTRATIVE'),
                    'validation' => 1,
                    'date_doc' => 0,
                    'show' => 1
                ],

                [
                    'type_document' => 'CM_ATT_CELIBAT',
                    'name' => "Attestation de célibat",
                    'document' => $chef_menage->specific_document('CM_ATT_CELIBAT'),
                    'file_type' => 'pdf',
                    'w_roles' => 'bet,gu',
                    'r_roles' => 'all',
                    'active' =>  $chef_menage->document_can_be_imported('CM_ATT_CELIBAT'),
                    'validation' => 1,
                    'date_doc' => 0,
                    'show' => 1
                ],

                [
                    'type_document' => 'CM_ACT_DIVORCE',
                    'name' => "Acte de divorce",
                    'document' => $chef_menage->specific_document('CM_ACT_DIVORCE'),
                    'file_type' => 'pdf',
                    'w_roles' => 'bet,gu',
                    'r_roles' => 'all',
                    'active' =>  $chef_menage->document_can_be_imported('CM_ACT_DIVORCE'),
                    'validation' => 1,
                    'date_doc' => 0,
                    'show' => 1
                ],

            ];
        }



        foreach ($menage->chefs_menage as $chef_menage) {
            $data = [];
            $chef_menage->recensement = 1;
            $chef_menage->current = 0;
            $data[] = $chef_menage->replicate();
            foreach ($chef_menage->chef_menage_modifs as $modif) {
                $modif->current = 0;
                $data[] = $modif;
            }
            $data[count($data) - 1]->current = 1;
            $chef_menage->data = $data;
        }

        foreach ($menage->chefs_menage as $chef_menage) {

            foreach ($chef_menage->data as $donnee) {
                $donnee->chef_menage_nom_edited = 0;
                $donnee->chef_menage_prenom_edited = 0;
                $donnee->chef_menage_cin_edited = 0;
                $donnee->sexe_edited = 0;
                $donnee->situation_edited = 0;

                if ($donnee->chef_menage_nom != $chef_menage->chef_menage_nom) {
                    $donnee->chef_menage_nom_edited = 1;
                }
                if ($donnee->chef_menage_prenom != $chef_menage->chef_menage_prenom) {
                    $donnee->chef_menage_prenom_edited = 1;
                }
                if ($donnee->chef_menage_cin != $chef_menage->chef_menage_cin) {
                    $donnee->chef_menage_cin_edited = 1;
                }
                if ($donnee->sexe != $chef_menage->sexe) {
                    $donnee->sexe_edited = 1;
                }
                if ($donnee->situation != $chef_menage->situation) {
                    $donnee->situation_edited = 1;
                }

                $donnee->conjoints = $donnee->conjoints();

                $conjoint_index = 1;
                foreach ($donnee->conjoints as $conjoint) {

                    $conjoint->nom_edited = 0;
                    $conjoint->prenom_edited = 0;
                    $conjoint->cin_edited = 0;

                    if ($conjoint_index == 1) {
                        if ($conjoint->nom != $chef_menage->conjoint_nom) {
                            $conjoint->nom_edited = 1;
                        }
                        if ($conjoint->prenom != $chef_menage->conjoint_prenom) {
                            $conjoint->prenom_edited = 1;
                        }
                        if ($conjoint->cin != $chef_menage->conjoint_cin) {
                            $conjoint->cin_edited = 1;
                        }
                    }
                    if ($conjoint_index == 2) {
                        if ($conjoint->nom != $chef_menage->conjoint2_nom) {
                            $conjoint->nom_edited = 1;
                        }
                        if ($conjoint->prenom != $chef_menage->conjoint2_prenom) {
                            $conjoint->prenom_edited = 1;
                        }
                        if ($conjoint->cin != $chef_menage->conjoint2_cin) {
                            $conjoint->cin_edited = 1;
                        }
                    }

                    if ($conjoint_index == 3) {
                        if ($conjoint->nom != $chef_menage->conjoint3_nom) {
                            $conjoint->nom_edited = 1;
                        }
                        if ($conjoint->prenom != $chef_menage->conjoint3_prenom) {
                            $conjoint->prenom_edited = 1;
                        }
                        if ($conjoint->cin != $chef_menage->conjoint3_cin) {
                            $conjoint->cin_edited = 1;
                        }
                    }

                    if ($conjoint_index == 4) {
                        if ($conjoint->nom != $chef_menage->conjoint4_nom) {
                            $conjoint->nom_edited = 1;
                        }
                        if ($conjoint->prenom != $chef_menage->conjoint4_prenom) {
                            $conjoint->prenom_edited = 1;
                        }
                        if ($conjoint->cin != $chef_menage->conjoint4_cin) {
                            $conjoint->cin_edited = 1;
                        }
                    }

                    $conjoint->documents = [
                        [
                            'type_document' => 'CM_CIN_CONJOINT_' . $conjoint->index,
                            'name' => "CIN conjoint",
                            'document' => $chef_menage->specific_document('CM_CIN_CONJOINT_' . $conjoint->index),
                            'file_type' => 'pdf',
                            'w_roles' => 'bet,gu',
                            'r_roles' => 'all',
                            'active' => $chef_menage->document_can_be_imported('CM_CIN_CONJOINT_' . $conjoint->index),
                            'validation' => 1,
                            'date_doc' => 0,
                            'show' => 1
                        ],
                        [
                            'type_document' => 'CM_ACT_MARIAGE_' . $conjoint->index,
                            'name' => "Acte de mariage",
                            'document' => $chef_menage->specific_document('CM_ACT_MARIAGE_' . $conjoint->index),
                            'file_type' => 'pdf',
                            'w_roles' => 'bet,gu',
                            'r_roles' => 'all',
                            'active' => $chef_menage->document_can_be_imported('CM_ACT_MARIAGE_' . $conjoint->index),
                            'validation' => 1,
                            'date_doc' => 0,
                            'show' => 1
                        ],


                    ];
                    $conjoint_index++;
                }
            }
        }

        // $dossier_attribution_files_list = [];

        $notaire_etude_can_be_edited = 0;



        foreach ($menage->chefs_menage as $chef_menage) {
            $dossier_etude_files_list = [];

            $ATTESTATION_NON_IMPOSITION = $chef_menage->specific_document('ATTESTATION_NON_IMPOSITION');
            if (is_null($ATTESTATION_NON_IMPOSITION)) {
                $notaire_etude_can_be_edited = 1;
            } else {
                if ($ATTESTATION_NON_IMPOSITION->decision != 'Validé') {
                    $notaire_etude_can_be_edited = 1;
                }
            }
            $dossier_etude_files_list[] = [
                'type_document' => 'CM_MENAGE_CIN',
                'name' => "CIN Chef de ménage",
                'document' => $chef_menage->specific_document('CM_MENAGE_CIN'),
                'file_type' => 'pdf',
                'w_roles' => '',
                'r_roles' => 'all',
                'active' =>  $chef_menage->document_can_be_imported('CM_MENAGE_CIN'),
                'validation' => 1,
                'date_doc' => 0,
                'show' => 1,
                'break' => 0

            ];

            $dossier_etude_files_list[] = [
                'type_document' => 'ATTESTATION_NON_IMPOSITION',
                'name' => "Attestation de non imposition",
                'document' => $chef_menage->specific_document('ATTESTATION_NON_IMPOSITION'),
                'file_type' => 'pdf',
                'w_roles' => 'notaire',
                'r_roles' => 'all',
                'active' => $chef_menage->document_can_be_imported('ATTESTATION_NON_IMPOSITION'),
                'validation' => 1,
                'date_doc' => 0,
                'show' => 1,
                'break' => 0
            ];

            $dossier_etude_files_list[] = [
                'type_document' => 'ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION',
                'name' => "Attestation de residence",
                'document' => $chef_menage->specific_document('ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION'),
                'file_type' => 'pdf',
                'w_roles' => 'bet',
                'r_roles' => 'all',
                'active' => $chef_menage->document_can_be_imported('ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION'),
                'validation' => 1,
                'date_doc' => 0,
                'show' => 1,
                'break' => 0
            ];

            if ($chef_menage->situation == "Divorcé") {
                $dossier_etude_files_list[] = [
                    'type_document' => 'CM_ACT_DIVORCE',
                    'name' => " Acte de divorce",
                    'document' => $chef_menage->specific_document('CM_ACT_DIVORCE'),
                    'file_type' => 'pdf',
                    'w_roles' => '',
                    'r_roles' => 'all',
                    'active' => 1,
                    'validation' => $chef_menage->document_can_be_imported('CM_ACT_DIVORCE'),
                    'date_doc' => 0,
                    'show' => 1,
                    'break' => 0
                ];
            }

            if ($chef_menage->situation == "Veuf") {
                $dossier_etude_files_list[] = [
                    'type_document' => 'CM_ACT_DECES',
                    'name' => " Acte de décès",
                    'document' => $chef_menage->specific_document('CM_ACT_DECES'),
                    'file_type' => 'pdf',
                    'w_roles' => '',
                    'r_roles' => 'all',
                    'active' => 1,
                    'validation' => $chef_menage->document_can_be_imported('CM_ACT_DECES'),
                    'date_doc' => 0,
                    'show' => 1,
                    'break' => 0
                ];
            }

            $conjoint_dossier_etude_files_list = [];
            if ($chef_menage->situation == "Marié") {
                foreach ($chef_menage->conjoints() as $conjoint) {


                    $ATTESTATION_NON_IMPOSITION_cnj = $chef_menage->specific_document('ATTESTATION_NON_IMPOSITION_CONJOINT_' . $conjoint->index);
                    if (is_null($ATTESTATION_NON_IMPOSITION_cnj)) {
                        $notaire_etude_can_be_edited = 1;
                    } else {
                        if ($ATTESTATION_NON_IMPOSITION_cnj->decision != 'Validé') {
                            $notaire_etude_can_be_edited = 1;
                        }
                    }

                    $conjoint_dossier_etude_files_list[] = [
                        'type_document' => 'CM_CIN_CONJOINT_' . $conjoint->index,
                        'name' => "CIN conjoint",
                        'document' => $chef_menage->specific_document('CM_CIN_CONJOINT_' . $conjoint->index),
                        'file_type' => 'pdf',
                        'w_roles' => '',
                        'r_roles' => 'all',
                        'active' => 1,
                        'validation' => $chef_menage->document_can_be_imported('CM_CIN_CONJOINT_' . $conjoint->index),
                        'date_doc' => 0,
                        'show' => 1,
                        'break' => 0,
                        'CONJOINT_index' => $conjoint->index
                    ];

                    $conjoint_dossier_etude_files_list[] = [
                        'type_document' => 'CM_ACT_MARIAGE_' . $conjoint->index,
                        'name' => " Acte de mariage",
                        'document' => $chef_menage->specific_document('CM_ACT_MARIAGE_' . $conjoint->index),
                        'file_type' => 'pdf',
                        'w_roles' => '',
                        'r_roles' => 'all',
                        'active' => 1,
                        'validation' =>  $chef_menage->document_can_be_imported('CM_ACT_MARIAGE_' . $conjoint->index),
                        'date_doc' => 0,
                        'show' => 1,
                        'break' => 0,
                        'CONJOINT_index' => $conjoint->index
                    ];



                    $conjoint_dossier_etude_files_list[] = [
                        'type_document' => 'ATTESTATION_NON_IMPOSITION_CONJOINT_' . $conjoint->index,
                        'name' => "Attestation de non imposition",
                        'document' => $chef_menage->specific_document('ATTESTATION_NON_IMPOSITION_CONJOINT_' . $conjoint->index),
                        'file_type' => 'pdf',
                        'w_roles' => 'notaire',
                        'r_roles' => 'all',
                        'active' =>  $chef_menage->document_can_be_imported('ATTESTATION_NON_IMPOSITION_CONJOINT_' . $conjoint->index),
                        'validation' => 1,
                        'date_doc' => 0,
                        'show' => 1,
                        'break' => 0,
                        'CONJOINT_index' => $conjoint->index
                    ];

                    $conjoint_dossier_etude_files_list[] = [
                        'type_document' => 'ATTESTATION_RESIDENCE_CONJOINT_' . $conjoint->index,
                        'name' => "Attestation de residence",
                        'document' => $chef_menage->specific_document('ATTESTATION_RESIDENCE_CONJOINT_' . $conjoint->index),
                        'file_type' => 'pdf',
                        'w_roles' => 'bet',
                        'r_roles' => 'all',
                        'active' =>  $chef_menage->document_can_be_imported('ATTESTATION_RESIDENCE_CONJOINT_' . $conjoint->index),
                        'validation' => 1,
                        'date_doc' => 0,
                        'show' => 1,
                        'break' => 0,
                        'CONJOINT_index' => $conjoint->index
                    ];
                }
            }

            $chef_menage->dossier_etude_files_list = $dossier_etude_files_list;

            $chef_menage->conjoint_dossier_etude_files_list = $conjoint_dossier_etude_files_list;
        }



        if (!Auth::user()->has_role('admin')) {
            $notaire_etude_can_be_edited = 0;
        }

        $etude_pv = EtudePV::with('dossiers')->with('membres')->where('id', $menage->pv_etude_id)->get()->first();

        if (!is_null($etude_pv)) {
            foreach ($etude_pv->dossiers as $dossier) {
                $dossier->chef_menage = ChefMenage::where('id', $dossier->menage_id)->get()->first();
                $dossier->chef_menage->conjoints = $dossier->chef_menage->conjoints();
            }
            foreach ($etude_pv->membres as $membre) {
                $membre->user = User::where('id', $membre->membre_id)->get()->first();
                $membre->user->nom_complet = $membre->user->prenom . ' ' . $membre->user->nom;
            }
        }

        $menage->etude_pv = $etude_pv;

        $pv_tas = PV_TAS::with('dossiers')->with('membres')->where('id', $menage->pv_tas_id)->get()->first();
        $menage->pv_tas = $pv_tas;

        $PV_ETUDE_document = [
            'type_document' => 'PV_ETUDE',
            'name' => "PV d'étude",
            'document' => $menage->specific_document('PV_ETUDE'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('PV_ETUDE'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1
        ];

        $PV_TAS_document = [
            'type_document' => 'PV_TAS',
            'name' => "PV de tirage au sort",
            'document' => $menage->specific_document('PV_TAS'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('PV_TAS'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,
        ];

        $BON_TIRAGE_SORT_document = [
            'type_document' => 'BON_TIRAGE_SORT',
            'name' => "Bon de tirage au sort",
            'document' => $menage->specific_document('BON_TIRAGE_SORT'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('BON_TIRAGE_SORT'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,
        ];



        $PV_DESISTEMENT_document = [
            'type_document' => 'PV_DESISTEMENT',
            'name' => "PV de désistement",
            'document' => $menage->specific_document('PV_DESISTEMENT'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('PV_DESISTEMENT'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,

        ];

        $PROJET_ENGAGEMENT_document = [
            'type_document' => 'PROJET_ENGAGEMENT',
            'name' => "Engagement",
            'document' => $menage->specific_document('PROJET_ENGAGEMENT'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('PROJET_ENGAGEMENT'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,

        ];


        $ATT_DEMOLITION_document = [
            'type_document' => 'ATT_DEMOLITION',
            'name' => "Engagement",
            'document' => $menage->specific_document('ATT_DEMOLITION'),
            'file_type' => 'pdf',
            'w_roles' => 'bet',
            'r_roles' => 'all',
            'active' => $menage->document_can_be_imported('ATT_DEMOLITION'),
            'validation' => 0,
            'date_doc' => 0,
            'show' => 1,

        ];



        return view('menages.show', [
            'menage' => $menage,
            'chef_menage' => $chef_menage,
            'ENGAGEMENT_document' => $ENGAGEMENT_document,
            'ATTESTATION_DEMOLITION_document' => $ATTESTATION_DEMOLITION_document,
            'test' => 0,
            'notaires' => $notaires,
            'banques' => $banques,
            'dossier_numero' => '#EDIT',

            'affectation_p1_files_list' => $affectation_p1_files_list,
            'affectation_p2_files_list' => $affectation_p2_files_list,
            'bon_tirage_au_sort' => $bon_tirage_au_sort,
            'attestation_remise_cles' => $attestation_remise_cles,
            'recu_versement_fond_propre' => $recu_versement_fond_propre,
            'contrat_vente' => $contrat_vente,

            'compromis_vente' => $compromis_vente,
            'AUTORISATION_VERSEMENT_id' => $AUTORISATION_VERSEMENT_id,
            'RECU_VERSEMENT_20000_id' => $RECU_VERSEMENT_20000_id,
            'BON_TIRAGE_AU_SORT_id' => $BON_TIRAGE_AU_SORT_id,
            'PROJET_PV_AFFECTATION_id' => $PROJET_PV_AFFECTATION_id,
            'ATTESTATION_AFFECTATION_id' => $ATTESTATION_AFFECTATION_id,
            'ACCUSE_RECEPTION_AFFECTATION_BET_id' => $ACCUSE_RECEPTION_AFFECTATION_BET_id,
            'ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_id' => $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_id,
            'RECU_VERSEMENT_CREDIT_id' => $RECU_VERSEMENT_CREDIT_id,
            'CONTRAT_VENTE_id' => $CONTRAT_VENTE_id,
            'ATTESTATION_REMISE_CLES_id' => $ATTESTATION_REMISE_CLES_id,
            'COMPROMIS_VENTE_id' => $COMPROMIS_VENTE_id,
            'CIN_DOSSIER_ATTRIBUTION_id' => $CIN_DOSSIER_ATTRIBUTION_id,
            'CIN_CONJOINT_DOSSIER_ATTRIBUTION_id' => $CIN_CONJOINT_DOSSIER_ATTRIBUTION_id,
            'ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_id' => $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_id,
            'ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_id' => $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_id,
            'ACTE_DIVORCE_DOSSIER_ATTRIBUTION_id' => $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_id,
            'ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_id' => $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_id,
            'ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_id' => $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_id,
            'ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_id' => $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_id,
            'CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_id' => $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_id,
            'AUTORISATION_VERSEMENT_date_document' => $AUTORISATION_VERSEMENT_date_document,
            'RECU_VERSEMENT_20000_date_document' => $RECU_VERSEMENT_20000_date_document,
            'BON_TIRAGE_AU_SORT_date_document' => $BON_TIRAGE_AU_SORT_date_document,
            'PROJET_PV_AFFECTATION_date_document' => $PROJET_PV_AFFECTATION_date_document,
            'ATTESTATION_AFFECTATION_date_document' => $ATTESTATION_AFFECTATION_date_document,
            'ACCUSE_RECEPTION_AFFECTATION_BET_date_document' => $ACCUSE_RECEPTION_AFFECTATION_BET_date_document,
            'ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_date_document' => $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_date_document,
            'RECU_VERSEMENT_CREDIT_date_document' => $RECU_VERSEMENT_CREDIT_date_document,
            'CONTRAT_VENTE_date_document' => $CONTRAT_VENTE_date_document,
            'ATTESTATION_REMISE_CLES_date_document' => $ATTESTATION_REMISE_CLES_date_document,
            'COMPROMIS_VENTE_date_document' => $COMPROMIS_VENTE_date_document,
            'CIN_DOSSIER_ATTRIBUTION_date_document' => $CIN_DOSSIER_ATTRIBUTION_date_document,
            'CIN_CONJOINT_DOSSIER_ATTRIBUTION_date_document' => $CIN_CONJOINT_DOSSIER_ATTRIBUTION_date_document,
            'ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_date_document' => $ACTE_MARRIAGE_DOSSIER_ATTRIBUTION_date_document,
            'ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_date_document' => $ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION_date_document,
            'ACTE_DIVORCE_DOSSIER_ATTRIBUTION_date_document' => $ACTE_DIVORCE_DOSSIER_ATTRIBUTION_date_document,
            'ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_date_document' => $ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION_date_document,
            'ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_date_document' => $ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION_date_document,
            'ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_date_document' => $ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION_date_document,
            'CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_date_document' => $CERTIFICAT_DECES_DOSSIER_ATTRIBUTION_date_document,
            'PV_ETUDE_document' => $PV_ETUDE_document,
            'PV_TAS_document' => $PV_TAS_document,
            'PV_DESISTEMENT_document' => $PV_DESISTEMENT_document,
            'BON_TIRAGE_SORT_document' => $BON_TIRAGE_SORT_document,

            'PROJET_ENGAGEMENT_document' => $PROJET_ENGAGEMENT_document,
            'situations_solaire' => $menage->situations_solaire,
            'ATT_DEMOLITION_document' => $ATT_DEMOLITION_document,
            'ATTESTATION_ATTRIBUTION_doc' => $ATTESTATION_ATTRIBUTION_doc,
            'ATTESTATION_ATTRIBUTION_signee_doc' => $ATTESTATION_ATTRIBUTION_signee_doc,
            'notaire_etude_can_be_edited' => $notaire_etude_can_be_edited

        ]);
    }
    public function store(Request $request)
    {
        $dossier = Menage::where('id', $request->id)->get()->first();
        $documents = json_decode($request->documents);       

      
        $identification = $request['identification'];
        $mode_attribution = $request['mode_attribution'];

        $source_financement = json_decode($request['source_financement']);

        $situations_scolarite = json_decode($request['situation_scolarite_data']);
        // if ($decision_commision == null) {
        //     return Response::json(['success' => 0, 'error' => 'NO_DECISION_COMISSION'], 200);
        // }
        foreach ($documents as $document) {
            $dossier_document = MenageDocument::where('id', $document->id)->get()->first();
            if (is_null($dossier_document)) {
                $dossier_document->menage_id = $dossier->id;
                $dossier_document->save();
            }
        }
        //set active documents
        $dossiers_documents = MenageDocument::where('menage_id', $request->id)->get();
        // foreach ($dossiers_documents as $dossier_document) {

        //     $dossiers_documents_same_dossier_and_type = MenageDocument::where([['type_document', $dossier_document->type_document], ['menage_id', $dossier_document->menage_id]])->count();
        //     MenageDocument::where([['type_document', $dossier_document->type_document], ['menage_id', $dossier_document->menage_id]])->update(array('active' => 0));

        //     if ($dossiers_documents_same_dossier_and_type >= 1) {
        //         $last_dossier_document_same_dossier_and_type = MenageDocument::where([['type_document', $dossier_document->type_document], ['menage_id', $dossier_document->menage_id]])->orderBy('created_at', 'DESC')->get()->first();
        //         $last_dossier_document_same_dossier_and_type->active = 1;
        //         $last_dossier_document_same_dossier_and_type->save();
        //     }
        // }

        // if (is_object($source_financement) && !empty((array)$source_financement)) {

        //     if (!is_null($dossier->dossier_financement)) {
        //         $dossier->dossier_financement->delete();
        //     }
        //     $dossier_financement = new DossierFinancement();
        //     $dossier_financement->id = Str::uuid();
        //     $dossier_financement->fond_propre = $source_financement->fond_propre;
        //     $dossier_financement->credit = $source_financement->credit;
        //     $dossier_financement->is_with_associe = $source_financement->is_with_associe;
        //     $dossier_financement->save();



        //     $dossier->dossier_financement_id = $dossier_financement->id;
        // }
        // if ($request['date_dossier_credit_inpt'] != null) {
        //     $dossier->dossier_credit = 1;
        //     $dossier->date_operation_dossier_credit =  Carbon::createFromFormat('d/m/Y', $request['date_dossier_credit_inpt'])->format('Y-m-d H:i:s');
        // }
        // if ($request['date_octroi_credit_inpt'] != null) {
        //     $dossier->octroi_credit = 1;
        //     $dossier->date_operation_octroi_credit = Carbon::createFromFormat('d/m/Y', $request['date_octroi_credit_inpt'])->format('Y-m-d H:i:s');
        // }
        // if ($request['date_deblocage_aupres_notaire_inpt'] != null) {
        //     $dossier->deblocage_aupres_notaire = 1;
        //     $dossier->date_operation_deblocage_aupres_notaire = Carbon::createFromFormat('d/m/Y', $request['date_deblocage_aupres_notaire_inpt'])->format('Y-m-d H:i:s');
        // }
        // if ($request['date_deblocage_main_notaire_inpt'] != null) {
        //     $dossier->deblocage_main_notaire = 1;
        //     $dossier->date_operation_deblocage_main_notaire = Carbon::createFromFormat('d/m/Y', $request['date_deblocage_main_notaire_inpt'])->format('Y-m-d H:i:s');
        // }
        // $dossier->notaire_id = $notaire_id;
        // $dossier->banque_id = $banque_id;


        $dossier->identification = $identification;
        $dossier->mode_attribution = $mode_attribution;
        $dossier->save();




        // self::update_dossier_etat($dossier->id);
        // self::update_enq_menage($dossier->id);
        // self::update_verified_badge($dossier->id);
        // self::update_notaire_etude($dossier->id);

        return Response::json(['success' => 1], 201);
    }

    public function update_notaire_etude(string $id)
    {

        $now = Carbon::now();
        $menage =  Menage::where('id', $id)->get()->first();
        if ($menage->chef_menage_verified == 1) {
            if (is_null($menage->notaire_etude)) {
                $notaires_etude = User::where('active', 1)->where('notaire_etude', 1)->where('role_id', 'feefae8b-ce50-4af1-abd1-14f87f6916d5')->orderBy('notaire_etude_last_affectation', 'ASC')->get()->first();
                if (!is_null($notaires_etude)) {
                    $notaires_etude->notaire_etude_last_affectation = $now;
                    $notaires_etude->save();
                    $menage->notaire_etude_id = $notaires_etude->id;
                    app('App\Http\Controllers\wtspController')->send($notaires_etude->tel, 'Nous vous informons que vous avez été désigné pour procéder à la vérification de l’imposition fiscale du dossier *' . $menage->ref . '*, et à importer l’attestation de non-imposition si le dossier est non imposable. Merci pour votre collaboration');

                    $menage->save();
                }
            }
        }
    }

    public function update_verified_badge(string $id)
    {
        $menage =  Menage::where('id', $id)->get()->first();

        $verified = true;
        foreach ($menage->chefs_menage as $chef_menage) {
            if ($chef_menage->validation != "Validé") {
                $verified = false;
            }
        }

        if ($verified) {
            $menage->chef_menage_verified = 1;
            $menage->save();
        } else {
            $menage->chef_menage_verified = 0;
            $menage->save();
        }
    }

    public function menages_datatable(Request $request)
    {
        $menages = Menage::with('chefs_menage')->where([
            ['active', '=', 1],
            ['is_dossier', '=', 1]
        ]);

        $searchTerm = $request->searchTerm;

        $referer = "";
        if (isset($request->referer)) {
            $referer = $request->referer;
        }
        $highlighted_document = null;
        $verificateur = 'all';
        if (isset($request->verificateur)) {
            $verificateur = $request->verificateur;
        }
        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if (isset($filter->params)) {
                $params = explode(',', $filter->params);
                foreach ($params as $param) {
                    if ($param == "remove_spaces") {
                        $filter->value = str_replace(' ', '', $filter->value);
                    }
                }
            }
            if ($filter->column == 'menages_compromis_vente_tab') {
                if ($filter->value == 'All') {
                    continue;
                } else {
                    $menages = $menages->where('notaire_id', '=', Auth::user()->id);
                    continue;
                }
            }

            if ($filter->column == 'menages_etude_tab') {
                if ($filter->value == 'All') {
                    continue;
                } else {
                    $menages = $menages->where('notaire_etude_id', '=', Auth::user()->id);
                    continue;
                }
            }
            if ($filter->column == 'menages_all_tab') {
                continue;
            }
            if ($filter->column == 'decision_commision') {
                if ($filter->value == 'All') {
                    continue;
                } else {
                    $menages = $menages->where('decision_commision', '=', $filter->value);
                    continue;
                }
            }

            if ($filter->column == 'situation') {
                if ($filter->value == 'all') {
                    continue;
                } else {
                    $menages = $menages->whereHas('chefs_menage', function ($query) use ($filter) {
                        $query->where('situation', 'like', '%' . $filter->value . '%');
                    });
                    continue;
                }
            }

            if ($filter->column == 'chef_menage_cin') {

                $menages = $menages->whereHas('chefs_menage', function ($query) use ($filter) {
                    $query->where('chef_menage_cin', 'like', '%' . $filter->value . '%');
                });
                continue;
            }
            if ($filter->column == 'document_filter') {
                $document_filter = 1;
                if ($filter->value == "NO_DOCUMENTS") {
                    $menages = $menages->whereNotExists(function ($query) use ($filter) {
                        $query->select(DB::raw(1))
                            ->from('menages_documents')
                            ->where('active', 1)
                            ->whereRaw('menages_documents.menage_id = menages.id');
                        $query =  $query->where(function ($query_) {
                            $query_->whereRaw('menages_documents.type_document = "PV_ETUDE"')
                                ->orWhereRaw('menages_documents.type_document = "AUTORISATION_VERSEMENT"')
                                ->orWhereRaw('menages_documents.type_document = "RECU_VERSEMENT_20000"')
                                ->orWhereRaw('menages_documents.type_document = "PV_TAS"')
                                ->orWhereRaw('menages_documents.type_document = "BON_TIRAGE_SORT"')
                                ->orWhereRaw('menages_documents.type_document = "ATTESTATION_ATTRIBUTION"');
                        });
                    });
                } else {
                    $highlighted_document = $filter->value;
                    if ($filter->etat != "NO_DEPOT") {
                        $menages = $menages->whereHas('menages_documents', function ($query) use ($filter, $verificateur) {
                            $query->where([['menages_documents.type_document', $filter->value], ['active', 1]]);
                            if ($filter->etat != "all") {
                                $query->where([['menages_documents.decision', $filter->etat], ['active', 1]]);
                            }
                            if ($verificateur != 'all') {
                                $query->whereNotNull('menages_documents.verified_by');
                                $query->where([['menages_documents.verified_by', $verificateur]]);
                            }
                        });
                    } else {
                        $menages = $menages->whereNotExists(function ($query) use ($filter, $verificateur) {
                            $query->select(DB::raw(1))
                                ->from('menages_documents')
                                ->whereRaw('menages_documents.menage_id = menages.id');
                            $query =  $query->where(function ($query_) use ($filter, $verificateur) {
                                $query_->where([['menages_documents.type_document', $filter->value], ['active', 1]]);
                            });
                        });
                    }
                }
                continue;
            }
            if ($filter->column == 'etat_avancement') {
                $menages = $menages->where('menages.dossier_etat_actuel', '=', $filter->value);
                continue;
            }
            if ($filter->column == 'created_at') {
                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));
                $menages = $menages->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $menages = $menages->where($filter->column, '=', $filter->value);
                } else {
                    $menages = $menages->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }


        // if (Auth::user()->role->name == "bet") {
        //     $menages = $menages->where('menages.bet_id', Auth::user()->id);
        // }

        if (strlen($searchTerm) > 3) {
            $chefIds = ChefMenage::search($searchTerm)
                ->take(1000000)
                ->get()
                ->pluck('id');

            $menages = Menage::whereHas('chefs_menage', function ($query) use ($chefIds) {
                $query->whereIn('id', $chefIds);  // Filter menages that have chefs_menage with the matching IDs
            });
        }



        return Datatables::eloquent($menages)
            ->addColumn('dossier', function ($menage) {

                $verified_badge = '<i style="color:#cacaca" class="fa-solid fa-circle-check mr-1"></i>';

                if ($menage->chef_menage_verified == 1) {

                    $verified_badge = '<i style="color:#00b3ee" class="fa-solid fa-circle-check mr-1"></i>';
                }

                return "<a href=" . asset('') . 'menages/show/' . $menage->id . "><span style='color:#c0665b'><i class='fa-regular fa-folder-open mr-1'></i>" .  $verified_badge . $menage->ref . "</span>";
            })
            ->addColumn('chef_menage', function ($menage) {

                $html = '<select class="form-control select2nc">';
                foreach ($menage->chefs_menage as $chef_menage) {
                    $html .= '<option>' . $chef_menage->chef_menage_nom . ' ' . $chef_menage->chef_menage_prenom . '</option>';
                }
                $html .= '</select>';
                return $html;
            })
            ->addColumn('cin', function ($menage) {
                $html = '<select class="form-control select2nc">';
                foreach ($menage->chefs_menage as $chef_menage) {
                    $html .= '<option>' . $chef_menage->chef_menage_cin . '</option>';
                }
                $html .= '</select>';
                return $html;
            })

            ->addColumn('arrondissement', function ($menage) {
                if (is_null($menage->arrondissement)) {
                    return "-";
                } else {
                    return $menage->arrondissement->nom;
                }
            })

            ->addColumn('annexe_administrative', function ($menage) {
                if (is_null($menage->annexe_administrative)) {
                    return "-";
                } else {
                    return $menage->annexe_administrative->nom;
                }
            })
            ->addColumn('quartier', function ($menage) {
                if (is_null($menage->quartier)) {
                    return "-";
                } else {
                    return $menage->quartier->nom;
                }
            })

            ->addColumn('etat_avancement', function ($menage) {
                return $menage->dossier_etat_actuel;
            })


            ->addColumn('depot', function ($menage)  use ($highlighted_document, $referer) {
                $html = "";
                $count = 0;

                $documents = $menage->documents->where('active', 1)->unique('type_document');



                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "PV_ETUDE") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">PVE</b>,';
                        $count++;
                    }
                }

                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "AUTORISATION_VERSEMENT") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">AV</b>,';
                        $count++;
                    }
                }

                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "RECU_VERSEMENT_20000") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">RVV</b>,';
                        $count++;
                    }
                }


                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "PV_TAS") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">PVTS</b>,';
                        $count++;
                    }
                }

                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "BON_TIRAGE_SORT") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">BTS</b>,';
                        $count++;
                    }
                }

                foreach ($documents as $dossier_doc) {
                    if ($dossier_doc->type_document == "ATTESTATION_ATTRIBUTION") {

                        $html .= '<b style="' . (($highlighted_document == $dossier_doc->type_document) ? 'border: 1px #f97171 dashed !important; border-radius: 6px; padding: 0px 2px;' : '') . 'color:' . $dossier_doc->decision_color() . '">AA</b>,';
                        $count++;
                    }
                }

                if ($count == 0) {
                    $html = '<b style="color:gray">Aucun dépôt</b>';
                } else {
                    $html = substr($html, 0, strlen($html) - 1);
                }
                return $html;
            })
            ->rawColumns(['dossier', 'chef_menage', 'cin', 'arrondissement', 'annexe_administrative', 'quartier', 'etat_avancement', 'depot'])
            ->only(['dossier', 'chef_menage', 'cin', 'arrondissement', 'annexe_administrative', 'quartier', 'etat_avancement', 'depot'])
            ->tojson();
    }
    public function file(string $file_id)
    {
        $document = MenageDocument::where('id', $file_id)->get()->first();
        if (is_null($document)) {
            abort(404);
        } else {
            $headers = array(
                'Content-Type: application/pdf',
            );
            return Response::download($document->documentPath(), $document->filename, $headers, "inline");
        }
    }
    public function file_data(string $file_id)
    {
        $dossier_document = BaraqueDocument::where('id', $file_id)->get()->first();
        return $dossier_document;
    }

    public function upload(Request $request)
    {
        $now = Carbon::now();
        $now->hour(23);
        $now->minute(59);
        $now->second(59);
        $menage = Menage::find($request->menage_id);
        $dossier_document = new MenageDocument();
        if ($request->id != null) {
            $dossier_document = MenageDocument::where('id', $request->id)->get()->first();
        } else {
            $dossier_document->id = Str::uuid();
        }
        $file = $request->file('file');
        if ($file == null) {
        } else {
            $fileName = $file->getClientOriginalName();
            $file_extension = Str::upper($file->getClientOriginalExtension());
            $file_size = $file->getSize();
        }

        if (isset($request->chef_menage_id)) {
            $dossier_document->chef_menage_id = $request->chef_menage_id;
        }
        $dossier_document->menage_id = $menage->id;
        $dossier_document->filename = $fileName;
        $dossier_document->nom =  $fileName;
        $dossier_document->user_id =  Auth::user()->id;
        $check_for_date_doc = 1;
        if (
            $request->type_document == "CM_MENAGE_CIN"
            || str_starts_with($request->type_document, "CM_CIN_CONJOINT_")
            || str_starts_with($request->type_document, "CM_ACT_MARIAGE_")
            || $request->type_document == "CM_ACT_DIVORCE"
            || $request->type_document == "CM_ACT_DECES"

            || strpos($request->type_document, '_PHOTO') !== false
        ) {
            $check_for_date_doc = 0;
        }
        if ($check_for_date_doc == 1) {
            if ($request->date_document == null) {
                return Response::json(['success' => 0, 'error' => 'EMPTY_DATE_DOCUMENT']);
            } else {
                $date_doc = Carbon::createFromFormat('d/m/Y', $request->date_document);
                $date_doc->hour(00);
                $date_doc->minute(00);
                $date_doc->second(00);
                if ($date_doc->gt($now)) {
                    return Response::json(['success' => 0, 'error' => 'DATE_IN_FUTURE']);
                }
                $dossier_document->date_document = $date_doc->format('Y-m-d');
            }
        } else {
            $dossier_document->date_document = $now->format('Y-m-d');
        }

        if ($request->type_document == "ATT_DEMOLITION") {

            if (strlen(trim($request->att_demolition_reference)) == 0) {
                return Response::json(['success' => 0, 'error' => 'ATT_DEMOLITION_NO_REFERENCE']);
            }
            if (strlen(trim($request->att_demolition_code_topo)) == 0) {
                return Response::json(['success' => 0, 'error' => 'ATT_DEMOLITION_NO_CODE_TOPO']);
            }
        }

        $dossier_document->file_type = $file_extension;

        $dossier_document->decision = 'Validé';

        // $dossier_document->file_size = $file_size;
        // if (
        //     $request->type_document == "CIN_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "CIN_CONJOINT_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ACTE_MARRIAGE_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ATTESTATION_CELIBAT_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "CERTIFICAT_DECES_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ACTE_DIVORCE_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ATTESTATION_ADMINISTRATIVE_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ATTESTATION_NON_IMPOSITION_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION" ||
        //     $request->type_document == "RECU_VERSEMENT_20000" ||
        //     $request->type_document == "BON_TIRAGE_AU_SORT" ||
        //     $request->type_document == "PROJET_PV_AFFECTATION" ||
        //     $request->type_document == "ACCUSE_RECEPTION_AFFECTATION_BET" ||
        //     $request->type_document == "ACCUSE_RECEPTION_AFFECTATION_NOTAIRE" ||
        //     $request->type_document == "RECU_VERSEMENT_CREDIT" ||
        //     $request->type_document == "CONTRAT_VENTE" ||
        //     $request->type_document == "ATTESTATION_REMISE_CLES" ||
        //     $request->type_document == "COMPROMIS_VENTE"
        // ) {
        //     $dossier_document->decision = 'En attente';
        // } else {
        //     $dossier_document->decision = 'Validé';
        // }

        $dossier_document->type_document = $request->type_document;

        if ($request->type_document == "ATT_DEMOLITION") {
            $dossier_document->att_demolition_reference = $request->att_demolition_reference;
            $dossier_document->att_demolition_code_topo = $request->att_demolition_code_topo;
        }

        $dossier_document->save();
        $create_thumbnail = 0;
        if (
            $request->type_document == "ATT_DEMOLITION"
            ||  $request->type_document == "PV_ETUDE"
            ||  $request->type_document == "PV_TAS"
            ||  $request->type_document == "BON_TIRAGE_SORT"
            ||  $request->type_document == "ATTESTATION_ATTRIBUTION"
            ||  $request->type_document == "ATTESTATION_ATTRIBUTION_SIGNEE"
            ||  $request->type_document == "COMPROMIS_VENTE"
            ||  $request->type_document == "ATTESTATION_REMISE_CLES"
            ||  $request->type_document == "CONTRAT_VENTE"
        ) {
            $create_thumbnail = 1;


            self::update_dossier_etat($request->menage_id);
        }




        if ($request->date_document != null) {
            $dossier_document->formated_date_document = $dossier_document->formated_date_document();
        }
        $dossier_document->formated_created_at = $dossier_document->formated_created_at();
        $file->move("files/menages_documents/" . $dossier_document->id . "/", $fileName);


        if ($create_thumbnail == 1) {
            $resolution = 150;
            $width = 500;

            $pdfPathEscaped = escapeshellarg("{$dossier_document->documentPath()}[0]");
            $outputJpgEscaped = escapeshellarg($dossier_document->documentThumbnailPath());

            $cmd = "convert -density $resolution $pdfPathEscaped -background white -alpha remove -alpha off -quality 90 -resize {$width} $outputJpgEscaped";

            exec($cmd, $output, $return_var);
        }
        return Response::json(['success' => 1, 'document' => $dossier_document]);
    }


    public function check_permission($baraque)
    {
        if (Auth::user()->has_role('Administrateur')) {
            // if ($dossier->filiale_id != Auth::user()->filiale_id) {
            //     abort(404);
            // }
        }
    }
    public function update_dossier_etat($dossier_id)
    {
        $dossier = Menage::with('baraque', 'dossier_log')->find($dossier_id);
        if (!$dossier) {
            return;
        }
        $steps = [
            'RECENSEMENT_VALIDE' => [
                'custom_condition' => function ($dossier) {
                    $verified = true;
                    foreach ($dossier->chefs_menage as $chef_menage) {
                        if ($chef_menage->validation != "Validé") {
                            $verified = false;
                        }
                    }
                    return $verified;
                },
                'column' => 'RECENSEMENT_VALIDE_menage_number',
                'etat' => "Recensement validé"
            ],
            'DOISSIER_ETUDE_COMPLET' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'ATTESTATION_NON_IMPOSITION',
                        'ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION',

                    ];

                    foreach ($dossier->chefs_menage as $chef_menage) {
                        if ($chef_menage->situation == "Marié") {
                            foreach ($chef_menage->conjoints() as $conjoint) {
                                $required_documents[] = "ATTESTATION_NON_IMPOSITION_CONJOINT_" . $conjoint->index;
                            }
                        }
                    }

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document)) {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'DOISSIER_ETUDE_COMPLET_menage_number',
                'etat' => "Dossier d’étude complet"
            ],

            'DOISSIER_ETUDE_COMPLET_VALIDE' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'ATTESTATION_NON_IMPOSITION',
                        'ATTESTATION_RESIDENCE_DOSSIER_ATTRIBUTION',

                    ];

                    foreach ($dossier->chefs_menage as $chef_menage) {
                        if ($chef_menage->situation == "Marié") {
                            foreach ($chef_menage->conjoints() as $conjoint) {
                                $required_documents[] = "ATTESTATION_NON_IMPOSITION_CONJOINT_" . $conjoint->index;
                            }
                        }
                    }

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'DOISSIER_ETUDE_COMPLET_VALIDE_menage_number',
                'etat' => "Dossier d’étude complet validé"
            ],

            'ETUDE_VALIDEE' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'PV_ETUDE'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'ETUDE_VALIDEE_menage_number',
                'etat' => "Etude validée"
            ],

            'PROJET_DESTINATION_AFFECTED' => [
                'custom_condition' => function ($dossier) {


                    return !is_null($dossier->projet_id);
                },
                'column' => 'PROJET_DESTINATION_AFFECTED_menage_number',
                'etat' => "Projet de destination désigné"
            ],

            'AUTORISATION_VERSEMENT' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'AUTORISATION_VERSEMENT'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'AUTORISATION_VERSEMENT_menage_number',
                'etat' => "Autorisation de versement"
            ],

            'RECU_VERSEMENT_20000' => [
                'custom_condition' => function ($dossier) {

                    $RECU_VERSEMENT_20000 = $dossier->specific_document("RECU_VERSEMENT_20000");
                    $ENGAGEMENT_BANQUE = $dossier->specific_document("ENGAGEMENT_BANQUE");


                    if (!is_null($RECU_VERSEMENT_20000)) {
                        if ($RECU_VERSEMENT_20000->decision == "Validé") {
                            return true;
                        }
                    }
                    if (!is_null($ENGAGEMENT_BANQUE)) {
                        if ($ENGAGEMENT_BANQUE->decision == "Validé") {
                            return true;
                        }
                    }

                    return false;
                },
                'column' => 'RECU_VERSEMENT_20000_menage_number',
                'etat' => "Versement de l’avance de 20 000 DH"
            ],

            'BON_TIRAGE_AU_SORT' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'PV_TAS',
                        'BON_TIRAGE_SORT'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'BON_TIRAGE_AU_SORT_menage_number',
                'etat' => "Tirage au sort"
            ],

            'ATTESTATION_ATTRIBUTION' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'ATTESTATION_ATTRIBUTION'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'ATTESTATION_ATTRIBUTION_menage_number',
                'etat' => "Attestation d'attribution"
            ],

            'ACCUSE_RECEPTION_ATTRIBUTION_NOTAIRE' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'ACCUSE_RECEPTION_AFFECTATION_NOTAIRE'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'ACCUSE_RECEPTION_ATTRIBUTION_NOTAIRE_menage_number',
                'etat' => "Attestation d’attribution avec accusé de réception"
            ],
            'COMPROMIS_VENTE' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'COMPROMIS_VENTE'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'COMPROMIS_VENTE_menage_number',
                'etat' => "Compromis de vente"
            ],

            'CONTRAT_VENTE' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'CONTRAT_VENTE'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'CONTRAT_VENTE_menage_number',
                'etat' => "Contrat de vente"
            ],


            'ATTESTATION_REMISE_CLES' => [
                'custom_condition' => function ($dossier) {

                    $required_documents = [
                        'ATTESTATION_REMISE_CLES'
                    ];

                    foreach ($required_documents as $document_name) {
                        $document = $dossier->specific_document($document_name);
                        if (is_null($document) || $document->decision !== "Validé") {
                            return false;
                        }
                    }
                    return true;
                },
                'column' => 'ATTESTATION_REMISE_CLES_menage_number',
                'etat' => "Remise des clés"
            ],




            'REGLEMENT_AVANCE_80000' => [
                'custom_condition' => function ($dossier) {

                    if (!is_null($dossier->dossier_financement)) {


                        if ($dossier->dossier_financement->fond_propre > 0) {

                            $required_documents = [];

                            $required_documents[] = "RECU_VERSEMENT_FOND_PROPRE";

                            foreach ($required_documents as $document_name) {
                                $document = $dossier->specific_document($document_name);
                                if (is_null($document) || $document->decision !== "Validé") {
                                    return false;
                                }
                            }
                        }

                        if ($dossier->dossier_financement->credit > 0) {
                            if ($dossier->deblocage_main_notaire != 1) {
                                return false;
                            }
                        }
                        return true;
                    } else {
                        return false;
                    }
                },
                'column' => 'REGLEMENT_AVANCE_80000_menage_number',
                'etat' => "Compromis de vente"
            ],




        ];
        foreach ($steps as $step => $data) {
            // Determine if the step is validated
            $validated = $data['condition'] ?? false;
            if (isset($data['document'])) {
                $document = $dossier->baraque->specific_document($data['document']);
                $validated = !is_null($document) && $document->decision == "Validé";
            }
            if (isset($data['custom_condition']) && is_callable($data['custom_condition'])) {
                $validated = $data['custom_condition']($dossier);
            }
            if ($validated) {
                if (!$dossier->check_step_in_log($step)) {
                    DossierLog::create([
                        'id' => Str::uuid(),
                        'menage_id' => $dossier->id,
                        'step' => $step
                    ]);
                    $dossier->dossier_etat_actuel = $data['etat'];
                    //$dossier->baraque->increment($data['column']);
                }
            } else {
                if ($dossier->check_step_in_log($step)) {
                    DossierLog::where('menage_id', $dossier->id)->where('step', $step)->delete();
                    //$dossier->baraque->decrement($data['column']);
                }
            }
        }
        $dossier->save();
    }
    public function check_steps($dossier_id)
    {
        $dossier = Menage::where('id', $dossier_id)->get()->first();
        $AUTORISATION_VERSEMENT = $dossier->baraque->specific_document('AUTORISATION_VERSEMENT');
        $RECU_VERSEMENT_20000 = $dossier->baraque->specific_document('RECU_VERSEMENT_20000');
        $BON_TIRAGE_AU_SORT = $dossier->baraque->specific_document('BON_TIRAGE_AU_SORT');
        $ATTESTATION_AFFECTATION = $dossier->baraque->specific_document('ATTESTATION_AFFECTATION');
        $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE = $dossier->baraque->specific_document('ACCUSE_RECEPTION_AFFECTATION_NOTAIRE');
        $COMPROMIS_VENTE = $dossier->baraque->specific_document('COMPROMIS_VENTE');
        $CONTRAT_VENTE = $dossier->baraque->specific_document('CONTRAT_VENTE');
        $ATTESTATION_REMISE_CLES = $dossier->baraque->specific_document('ATTESTATION_REMISE_CLES');
        $ATTRIBUTION_step = 0;
        $AUTORISATION_VERSEMENT_step = 0;
        $RECU_VERSEMENT_20000_step = 0;
        $BON_TIRAGE_AU_SORT_step = 0;
        $ATTESTATION_AFFECTATION_step = 0;
        $ACCUSE_RECEPTION_AFFECTATION_NOTAIRE_step = 0;
        $COMPROMIS_VENTE_step = 0;
        $CONTRAT_VENTE_step = 0;
        $ATTESTATION_REMISE_CLES_step = 0;
        if ($dossier->decision_commision = "validé") {
            $ATTRIBUTION_step = 1;
        }
        if ($ATTRIBUTION_step == 0) {
            if ($dossier->check_step_in_log('ATTRIBUTION')) {
                foreach ($dossier->dossier_log as $step) {
                    if ($step->step == 'ATTRIBUTION') {
                        $step->delete();
                    }
                }
            }
        } else {
            if (!$dossier->check_step_in_log('ATTRIBUTION')) {
                $step = new DossierLog();
                $step->id = Str::uuid();
                $step->menage_id = $dossier->id;
                $step->step = 'ATTRIBUTION';
                $step->save();
            }
        }
    }
    public function validate_document(Request $request)
    {
        // if (Auth::user()->has_role('Vérificateur,Administrateur')) {
        $dosisser_document = BaraqueDocument::where('id', $request->id)->get()->first();
        $dosisser_document->decision = 'Validé';
        $dosisser_document->verified_by = Auth::user()->id;
        $dosisser_document->verified_at = Carbon::now();
        $dosisser_document->save();
        $this->update_dossier_etat($dosisser_document->menage_id);
        return Response::json(['success' => 1, 'error' => '', 'menage_id' => $dosisser_document->menage_id]);
        // } else {
        //     return Response::json(['success' => 0, 'error' => 'NOT_AUTHORIZED']);
        // }
    }
    public function rejeter_document(Request $request)
    {
        // if (Auth::user()->has_role('Vérificateur,Administrateur')) {
        $dosisser_document = BaraqueDocument::where('id', $request->id)->get()->first();
        $dosisser_document->decision = 'Rejeté';
        $dosisser_document->verified_by = Auth::user()->id;
        $dosisser_document->verified_at = Carbon::now();
        $dosisser_document->motif_rejet =  $request->motif_rejet;
        $dosisser_document->save();
        $this->update_dossier_etat($dosisser_document->menage_id);
        return Response::json(['success' => 1, 'error' => '']);
        // } else {
        //     return Response::json(['success' => 0, 'error' => 'NOT_AUTHORIZED']);
        // }
    }

    public function update_enq_menage(string $id)
    {
        $menage =  Menage::where('id', $id)->get()->first();

        foreach ($menage->chefs_menage as $chef_menage) {
            if ($chef_menage->validation != "Validé") {
                return;
            }
        }
        foreach ($menage->chefs_menage as $chef_menage) {
            if ($chef_menage->validation == "Validé") {
                $enq_menage = EnqMenage::where('chef_menage_cin', 'like', $chef_menage->chef_menage_cin)->get()->first();

                if (!is_null($enq_menage)) {
                    $chef_menage->enq_menage_id = $enq_menage->id;
                    $chef_menage->save();
                    $menage->baraque_id = $enq_menage->baraque_id;
                    $menage->save();
                }
            }
        }
    }

    public function edit_chef_menage(Request $request)
    {

        if (Auth::user()->has_role('verif,bet')) {
            $chef_menage = new ChefMenageModif();
            $chef_menage->id = str::uuid();

            $chef_menage->chef_menage_cin = $request->chef_menage_cin;
            $chef_menage->chef_menage_nom = $request->chef_menage_nom;
            $chef_menage->chef_menage_prenom = $request->chef_menage_prenom;
            $chef_menage->conjoint_cin = $request->conjoint_cin;
            $chef_menage->conjoint_nom = $request->conjoint_nom;
            $chef_menage->conjoint_prenom = $request->conjoint_prenom;

            $chef_menage->conjoint2_cin = $request->conjoint2_cin;
            $chef_menage->conjoint2_nom = $request->conjoint2_nom;
            $chef_menage->conjoint2_prenom = $request->conjoint2_prenom;

            $chef_menage->conjoint3_cin = $request->conjoint3_cin;
            $chef_menage->conjoint3_nom = $request->conjoint3_nom;
            $chef_menage->conjoint3_prenom = $request->conjoint3_prenom;

            $chef_menage->conjoint4_cin = $request->conjoint4_cin;
            $chef_menage->conjoint4_nom = $request->conjoint4_nom;
            $chef_menage->conjoint4_prenom = $request->conjoint4_prenom;


            $chef_menage->situation = $request->situation;
            $chef_menage->sexe = $request->sexe;
            $chef_menage->chef_menage_id = $request->chef_menage_id;
            $chef_menage->user_id = Auth::user()->id;

            $chef_menage->save();

            return Response::json(['success' => 1]);
        } else {
        }
        return Response::json(['success' => 0, 'error' => 'NOT_AUTHORIZED']);
    }
    public function validate_chef_menage(Request $request)
    {

        if (Auth::user()->has_role('verif')) {
            $chef_menage =  ChefMenage::where('id', $request->chef_menage_id)->get()->first();
            $chef_menage_last_modif = $chef_menage->last_modif();

            if (!is_null($chef_menage_last_modif)) {
                $chef_menage->chef_menage_cin = $chef_menage_last_modif->chef_menage_cin;
                $chef_menage->chef_menage_nom = $chef_menage_last_modif->chef_menage_nom;
                $chef_menage->chef_menage_prenom = $chef_menage_last_modif->chef_menage_prenom;
                $chef_menage->conjoint_cin = $chef_menage_last_modif->conjoint_cin;
                $chef_menage->conjoint_nom = $chef_menage_last_modif->conjoint_nom;
                $chef_menage->conjoint_prenom = $chef_menage_last_modif->conjoint_prenom;

                $chef_menage->conjoint2_cin = $chef_menage_last_modif->conjoint2_cin;
                $chef_menage->conjoint2_nom = $chef_menage_last_modif->conjoint2_nom;
                $chef_menage->conjoint2_prenom = $chef_menage_last_modif->conjoint2_prenom;

                $chef_menage->conjoint3_cin = $chef_menage_last_modif->conjoint3_cin;
                $chef_menage->conjoint3_nom = $chef_menage_last_modif->conjoint3_nom;
                $chef_menage->conjoint3_prenom = $chef_menage_last_modif->conjoint3_prenom;


                $chef_menage->conjoint4_cin = $chef_menage_last_modif->conjoint4_cin;
                $chef_menage->conjoint4_nom = $chef_menage_last_modif->conjoint4_nom;
                $chef_menage->conjoint4_prenom = $chef_menage_last_modif->conjoint4_prenom;

                $chef_menage->situation = $chef_menage_last_modif->situation;
                $chef_menage->sexe = $chef_menage_last_modif->sexe;
            }
            $chef_menage->validation = "Validé";
            $chef_menage->validation_by = Auth::user()->id;
            $chef_menage->validation_date = Carbon::now();
            $chef_menage->save();

            self::update_dossier_etat($chef_menage->id_menage);
            self::update_enq_menage($chef_menage->id_menage);
            self::update_verified_badge($chef_menage->id_menage);
            self::update_notaire_etude($chef_menage->id_menage);

            return Response::json(['success' => 1]);
        } else {
        }
        return Response::json(['success' => 0, 'error' => 'NOT_AUTHORIZED']);
    }

    public function affcetation_projet(Request $request)
    {

        $now = Carbon::now();
        $now->hour(23);
        $now->minute(59);
        $now->second(59);

        $menage = Menage::where('id', $request->menage_id)->get()->first();



        $file = $request->file('engagement');
        if (is_null($file) && count($menage->projets_destination) > 1) {
            return Response::json(['success' => 0, 'error' => 'ENGAGEMENT_FILE_MISSING']);
        }
        if (!is_null($menage)) {
            $menage->projet_id = $request->projet_id;
            $menage->save();
        }

        if (!is_null($file)) {
            $dossier_document = new MenageDocument();
            $dossier_document->id = Str::uuid();

            $fileName = $file->getClientOriginalName();
            $file_extension = Str::upper($file->getClientOriginalExtension());
            $file_size = $file->getSize();

            if (isset($request->chef_menage_id)) {
                $dossier_document->chef_menage_id = $request->chef_menage_id;
            }
            $dossier_document->menage_id = $menage->id;
            $dossier_document->filename = $fileName;
            $dossier_document->nom =  $fileName;
            $dossier_document->user_id =  Auth::user()->id;
            $check_for_date_doc = 1;

            $dossier_document->date_document = $now->format('Y-m-d');

            $dossier_document->file_type = $file_extension;
            $dossier_document->decision = 'Validé';
            $dossier_document->type_document = "PROJET_ENGAGEMENT";
            $create_thumbnail = 1;
            $dossier_document->save();

            if ($request->date_document != null) {
                $dossier_document->formated_date_document = $dossier_document->formated_date_document();
            }
            $dossier_document->formated_created_at = $dossier_document->formated_created_at();
            $file->move("files/menages_documents/" . $dossier_document->id . "/", $fileName);


            if ($create_thumbnail == 1) {
                $resolution = 150;
                $width = 500;

                $pdfPathEscaped = escapeshellarg("{$dossier_document->documentPath()}[0]");
                $outputJpgEscaped = escapeshellarg($dossier_document->documentThumbnailPath());

                $cmd = "convert -density $resolution $pdfPathEscaped -background white -alpha remove -alpha off -quality 90 -resize {$width} $outputJpgEscaped";

                exec($cmd, $output, $return_var);
            }
        }


        return Response::json(['success' => 1]);
    }

    public function get_menage(Request $request)
    {
        $menage = Menage::with('appartement')->with('projet.province')->with('immeuble')->with('douar')->with('arrondissement')->with('projet.banque')->with('chefs_menage')->where('id', $request->menage_id)->get()->first();

        $etude_pv = EtudePV::with('dossiers')->with('membres')->where('id', $menage->pv_etude_id)->get()->first();
        $menage->etude_pv = $etude_pv;

        $pv_tas = PV_TAS::with('dossiers')->with('membres')->where('id', $menage->pv_tas_id)->get()->first();
        $menage->pv_tas = $pv_tas;



        return $menage;
    }

    public function edit_notaire_etude(Request $request)
    {

        $menage = Menage::where('id', $request->menage_id)->get()->first();
        $menage->notaire_etude_id = $request->notaire_etude_id;
        $menage->notaire_etude_date = Carbon::now();
        $menage->save();
        return Response::json(['success' => 1]);
    }
}
