<?php

namespace App\Http\Controllers;

use App\Http\Requests\UpdatePasswordRequest;
use App\Http\Requests\UpdateProfileRequest;
use App\Models\Profile;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Response;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        return view('profile.index');
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(Profile $profile)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Profile $profile)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request)
    {

        if (Auth::user()->id == $request->user_id) {
            $user = User::findOrFail($request->user_id);

            $user->nom = $request->nom;
            $user->prenom = $request->prenom;
            $user->email = $request->email;
            $user->tel = $request->tel;
            $user->save();

            $avatar = $request->file('avatar');

          
            if ($avatar) {
                $mimeType = File::mimeType($avatar->getPathname());
       
                $validMimeTypes = ['image/jpeg', 'image/png', 'image/gif'];
                if (in_array($mimeType, $validMimeTypes)) {
                    $avatar->move("files/users/" . $request->user_id . "/profile/", "profile.png");
                } else {
                    $filePath = $avatar->getPathname();
                    if (File::exists($filePath)) {
                        File::delete($filePath);
                    }
                }
               
            }

            return Response::json(['success' => 1], 200);
        } else {
            return Response::json(['success' => 0, 'error' => "NOT_AUTHORIZED"]);
        }
    }

    public function updatePassword(Request $request)
    {
        $user = Auth::user();

        if (!Hash::check($request->old_password, $user->password)) {
            return Response::json(['success' => 0, 'error' => "BAD_CURRENT_PWD"]);
        }

        if ($request->password == $request->password_confirmation) {

            if (strlen($request->password) < 8) {
                return Response::json(['success' => 0, 'error' => "SHORT_PASSWORD"]);
            }
            if (!preg_match("#[0-9]+#", $request->password)) {

                return Response::json(['success' => 0, 'error' => "PASSWORD_NO_NUMBER"]);
            }

            if (!preg_match("#[A-Z]+#", $request->password)) {

                return Response::json(['success' => 0, 'error' => "PASSWORD_NO_UPPERCASE"]);
            }
            if (!preg_match("#[a-z]+#", $request->password)) {

                return Response::json(['success' => 0, 'error' => "PASSWORD_NO_LOWERCASE"]);
            }
            if (!preg_match("/[^a-zA-Z\d]/", $request->password)) {

                return Response::json(['success' => 0, 'error' => "PASSWORD_NO_SYMBOLE"]);
            }
            $user->password = Hash::make($request->password);
            $user->save();
            return Response::json(['success' => 1]);
        } else {
            return Response::json(['success' => 0, 'error' => "PASSWORDS_MISS_MATCHED"]);
        }
    }



    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Profile $profile)
    {
        //
    }
}
