<?php

namespace App\Http\Controllers;

use chillerlan\QRCode\QRCode;
use chillerlan\QRCode\QROptions;
use App\Models\QR_Code;
use App\Models\Menage;
use App\Models\ChefMenage;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\EtudePV;
use App\Models\PV_TAS;
use Carbon\Carbon;
use App\Models\MenageDocument;
use stdClass;
use Response;
use UnderflowException;
use App\Models\EtudePV_Dossier;
use App\Models\PV_TAS_Dossier;

class QRCodeController extends Controller
{
    public function  show(string $id)
    {
        $qr_code = QR_Code::where('id',  $id)->get()->first();
       



        if ($qr_code->type == "PV_TAS") {
            $pv_tas_dossier = PV_TAS_Dossier::where('pv_id', $qr_code->target_id)->get()->first();

            $chef_menage = ChefMenage::where('id', $pv_tas_dossier->menage_id)->get()->first();

            $document = $chef_menage->menage->specific_document('PV_TAS');
            $document_name =   "PV tirage au sort";
        }

        if ($qr_code->type == "PV_ETUDE") {
            $pv_etude_dossier = EtudePV_Dossier::where('pv_id', $qr_code->target_id)->get()->first();

            $chef_menage = ChefMenage::where('id', $pv_etude_dossier->menage_id)->get()->first();

            $document = $chef_menage->menage->specific_document('PV_ETUDE');
            $document_name =   "PV d'étude";
        }

        if ($qr_code->type == "ATTESTATION_ATTRIBUTION") {
          
            $menage = Menage::where('id',$qr_code->target_id)->get()->first();

            $document = $menage->specific_document('ATTESTATION_ATTRIBUTION');
            $document_name =   "Attestation d'attribution";
        }

        if ($qr_code->type == "AUTORISATION_VERSEMENT") {
          
            $menage = Menage::where('id',$qr_code->target_id)->get()->first();

            $document = $menage->specific_document('AUTORISATION_VERSEMENT');
            $document_name =   "Autorisation de versement";
        }

        return view('qr_code.show', [
            'qr_code' => $qr_code,
             
            'document_name' => $document_name,
            'document' => $document

        ]);
    }

    public function generate_qrcode(Request $request)
    {
        $prefix = "";
        if ($request->type = "AUTORISATION_VERSEMENT") {
            $prefix = "QAV";
        }
        if ($request->type = "PROJET_PV_AFFECTATION") {
            $prefix = "QPA";
        }
        if ($request->type = "ATTESTATION_AFFECTATION") {
            $prefix = "QAA";
        }
        if ($request->type = "PV_ETUDE") {
            $prefix = "GPVE";
        }

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }
        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = $request->type;
        $qr_code->target_id = $request->menage_id;
        $qr_code->save();
        return $qr_code;
    }

    public function generate_qrcode_image(Request $request)
    {

        $download = 0;
        if ($request->download) {
            $download  = $request->download;
        }

        $qr_code = QR_Code::where('id',  $request->id)->get()->first();

        if ($qr_code == null) {
            abort('404');
        }

        $options = new QROptions([
            'version'      => 7,
            'outputType'   => QRCode::OUTPUT_IMAGE_PNG,
            'scale'        => 5,
            'imageBase64'  => false,
            'drawCircularModules' => false
        ]);

        $qrcode = new QRCode($options);
        $pngAbsoluteFilePath = uniqid('MyApp', true) . '.png';

        $data = env("APP_URL") . "/qr_code/show/" . $qr_code->id;


        $qrcode->render($data, $pngAbsoluteFilePath);

        $border = 10;

        // Create Image From Existing File
        $jpg_image = imagecreatefrompng($pngAbsoluteFilePath);

        $width = imagesx($jpg_image);
        $height = imagesy($jpg_image);
        $img_adj_width = $width + (2 * $border);
        $img_adj_height = $height + (2 * $border);
        $newimage = imagecreatetruecolor($img_adj_width, $img_adj_height);

        $border_color = imagecolorallocate($newimage, 255, 255, 255);
        imagefilledrectangle($newimage, 0, 0, $img_adj_width, $img_adj_height, $border_color);

        imagecopyresized(
            $newimage,
            $jpg_image,
            $border,
            $border,
            0,
            0,
            $width,
            $height,
            $width,
            $height
        );
        $white = imagecolorallocate($jpg_image, 0, 0, 0);
        $font_path = base_path('fonts/roboto/RobotoCondensed-Regular.ttf');
        $text = $qr_code->number;
        $font_size = 20;
        $text_bound = imageftbbox($font_size, 0, $font_path, $text);
        $lower_left_x =  $text_bound[0];
        $lower_left_y =  $text_bound[1];
        $lower_right_x = $text_bound[2];
        $lower_right_y = $text_bound[3];
        $upper_right_x = $text_bound[4];
        $upper_right_y = $text_bound[5];
        $upper_left_x =  $text_bound[6];
        $upper_left_y =  $text_bound[7];
        $text_width =  $lower_right_x - $lower_left_x;
        $text_height = $lower_right_y - $upper_right_y;
        imagettftext($newimage,  $font_size, 0, 132 - ($text_width / 2.0), 278, $white, $font_path, $text);
        header('Content-type: image/png');
        imagepng($newimage);
        imagedestroy($newimage);

        if (readfile($pngAbsoluteFilePath)) {
            unlink($pngAbsoluteFilePath);
        }
    }

    public function generate_document(Request $request)
    {
        $prefix = "";
        $target_id = '';
        if ($request->type == "AUTORISATION_VERSEMENT") {
            $prefix = "QAV";
            $target_id =  $request->menage_id;
        }
        if ($request->type == "PROJET_PV_AFFECTATION") {
            $prefix = "QPA";
            $target_id =  $request->menage_id;
        }
        if ($request->type == "ATTESTATION_AFFECTATION") {
            $prefix = "QAA";
            $target_id =  $request->menage_id;
        }
        if ($request->type == "PV_ETUDE") {
            $prefix = "GPVE";
            $target_id =  $request->pv_etude_id;
        }

        while (true) {
            $random_str = $prefix . Str::upper(Str::random(12));
            if (QR_Code::where([['number', $random_str]])->count() == 0) {
                break;
            }
        }


        $qr_code = new QR_Code();
        $qr_code->id = Str::uuid();
        $qr_code->number = $random_str;
        $qr_code->type = $request->type;
        $qr_code->target_id = $target_id;
        $qr_code->save();
        if ($request->type == "PV_ETUDE") {
            $etude_pv = EtudePV::where('id',  $target_id)->get()->first();
            $etude_pv->pv_generated_id =  $qr_code->id;
            $etude_pv->save();
        }

        $headers = array(
            'Content-Type: application/pdf',
        );
        $command = "/bin/mono " . base_path('app/DocGEN/vsb_doc_gen.exe') . ' ' . $qr_code->type . ' ' . $qr_code->id . ' ' . $target_id . ' > /dev/null &';
        $qr_code->last_command = $command;
        $qr_code->save();
        $output = exec($command);
        $pdf_path = base_path('files/generated/' . $qr_code->id . '/' . $qr_code->type . '.pdf');

        return Response::json(['success' => 1]);
        //return Response::download($pdf_path, $qr_code->type . ".pdf", $headers, 'inline');
    }
}
