<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Models\GBaraque;
use App\Models\Baraque;
use App\Models\Menage;
use App\Models\BaraqueDocument;
use App\Models\User;
use App\Models\Douar;
use App\Models\SettingsActivites;
use App\Models\Commerce;
use Illuminate\Support\Facades\Storage;
use DataTables;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Response;
use Carbon\Carbon;
use App\Models\Commune;
use App\Models\Province;
use stdClass;
use App\Models\RecensementRow;
use App\Models\NewDouar;


class RecoupementController extends Controller
{
    public function index()
    {
        $douars = NewDouar::all();
        $communes = Commune::all();
        $provinces =  Province::all();

        return view('recoupement.index', [
            'provinces' => $provinces,

            'communes' => $communes,
            'douars' => $douars
        ]);
    }

    public function fix_menages_active()
    {
        $baraques = Baraque::where("active", 0)->with('menages')->get();


        foreach ($baraques as $baraque) {
            foreach ($baraque->menages as $menage) {
                $menage->active = 0;
                $menage->save();
            }
        }
    }

    public function menages_datatable(Request $request)
    {
        $tab = $request->tab;
        //$menages = Menage::where('active', 1)->where('verrification_etat', 'Validé');

        $menages = Menage::where('menages.active', 1)
            ->where('verrification_etat', 'Validé')
            ->join('baraques', 'menages.baraque_id', '=', 'baraques.id')
            ->join('new_douars', 'baraques.id_douar', '=', 'new_douars.id')
            ->join('communes', 'new_douars.commune_id', '=', 'communes.id')
            ->join('provinces', 'communes.province_id', '=', 'provinces.id')
            ->select('menages.*', 'communes.id as commune_id', 'provinces.id as province_id');

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $menages = $menages->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $menages = $menages->where($filter->column, '=', $filter->value);
                } else {
                    $menages = $menages->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }



        $menages = $menages->whereHas('baraque', function ($query) {
            $query->whereNotNull('baraques.id_douar');
        });

        if ($tab == "found_recensement_cin") {
            $menages = $menages->where('found_recensement_cin', 1)->where('found_recensement_nom', 0);
        }

        if ($tab == "found_recensement_nom") {
            $menages = $menages->where('found_recensement_nom', 1)->where('found_recensement_cin', 0);
        }

        if ($tab == "not_found_recensement") {
            $menages = $menages->where('not_found_recensement', 1);
        }

        $menages->orderBy("created_at", "DESC");

        return Datatables::eloquent($menages)

            ->addColumn('cin', function ($menage) {
                return '<span style="font-size:14px"><i class="fa-solid fa-map-location-dot mr-2"></i>' . '<span id="' . $menage->id . '" >' . $menage->chef_menage_cin . '</span></span>';
            })
            ->addColumn('nom', function ($menage) {
                return  $menage->chef_menage_nom;
            })
            ->addColumn('prenom', function ($menage) {
                return  $menage->chef_menage_prenom;
            })
            ->addColumn('conjoint_cin', function ($menage) {
                return  $menage->conjoint_cin;
            })
            ->addColumn('conjoint_nom', function ($menage) {
                return  $menage->conjoint_nom;
            })
            ->addColumn('conjoint_prenom', function ($menage) {
                return  $menage->conjoint_prenom;
            })
            ->rawColumns(['cin', 'nom', 'prenom', 'conjoint_cin', 'conjoint_nom', 'conjoint_prenom'])
            ->only(['cin', 'nom', 'prenom', 'conjoint_cin', 'conjoint_nom', 'conjoint_prenom'])
            ->tojson();
    }


    public function recensement_datatable(Request $request)
    {
        $tab = $request->tab;
        $recencement_rows = RecensementRow::where('non_trouve', 1);

        $recencement_rows = RecensementRow::where('non_trouve', 1)
            ->join('new_douars', 'recensement.id_douar', '=', 'new_douars.id')
            ->join('communes', 'new_douars.commune_id', '=', 'communes.id')
            ->join('provinces', 'communes.province_id', '=', 'provinces.id')
            ->select('recensement.*', 'communes.id as commune_id', 'provinces.id as province_id');

        if ($tab == "localises") {
            $recencement_rows = $recencement_rows->where('non_trouve_localise', 1);
        }

        if ($tab == "non_localises") {
            $recencement_rows = $recencement_rows->where('non_trouve_localise', 0);
        }

        $filters = json_decode($request->filters);
        foreach ($filters as $filter) {
            $filter->value = trim($filter->value);
            if ($filter->column == 'created_at') {

                $from =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[0]));
                $to =  Carbon::createFromFormat('d/m/Y', trim(explode('-', $filter->value)[1]));

                $recencement_rows = $recencement_rows->whereBetween($filter->column, [$from, $to]);
            } else {
                if ($filter->table == '') {
                    $recencement_rows = $recencement_rows->where($filter->column, '=', $filter->value);
                } else {
                    $recencement_rows = $recencement_rows->whereHas($filter->table, function ($query) use ($filter) {
                        $query->where($filter->table . '.' . $filter->column, 'like', '%' . $filter->value . '%');
                    });
                }
            }
        }
        $recencement_rows->orderBy("created_at", "DESC");

        return Datatables::eloquent($recencement_rows)

            ->addColumn('cin', function ($recencement_row) {
                return '<span style="font-size:14px"><i class="fa-solid fa-map-location-dot mr-2"></i>' . '<span id="' . $recencement_row->id . '" >' . $recencement_row->cin_chef . '</span></span>';
            })
            ->addColumn('nom', function ($recencement_row) {
                return  $recencement_row->nom_chef;
            })
            ->addColumn('prenom', function ($recencement_row) {
                return  $recencement_row->prenom_chef;
            })
            ->addColumn('conjoint_cin', function ($recencement_row) {
                return  $recencement_row->cin_conj;
            })
            ->addColumn('conjoint_nom', function ($recencement_row) {
                return  $recencement_row->nom_conj;
            })
            ->addColumn('conjoint_prenom', function ($recencement_row) {
                return  $recencement_row->prenom_conj;
            })
            ->rawColumns(['cin', 'nom', 'prenom', 'conjoint_cin', 'conjoint_nom', 'conjoint_prenom'])
            ->only(['cin', 'nom', 'prenom', 'conjoint_cin', 'conjoint_nom', 'conjoint_prenom'])
            ->tojson();
    }

    public function process()
    {
        ini_set('memory_limit', '-1');
        $menages = Menage::where('active', 1)->with('baraque')->where('verrification_etat', 'Validé');

        $menages = $menages->whereHas('baraque', function ($query) {
            $query->whereNotNull('baraques.id_douar');
        });
        $menages = $menages->get();
        foreach ($menages as $menage) {
            $menage->recensement_check = 1;
            $menage->save();
        }


        $menages = Menage::where('recensement_check', 1)->get();


        foreach ($menages as $menage) {

            $menage->found_recensement_cin = 0;
            $menage->found_recensement_nom = 0;
            $menage->not_found_recensement = 0;

            $menage->istimara = null;
            $menage->save();
        }
        $recensement_rows = RecensementRow::all();
        foreach ($recensement_rows as $recensement_row) {
            $recensement_row->trouve = 0;
            $recensement_row->trouve_count = 0;
            $recensement_row->non_trouve = 0;
            $recensement_row->save();
        }

        foreach ($menages as $menage) {

            $found = false;



            $recensement_row = RecensementRow::where(function ($query)  use ($menage) {
                if (!is_null($menage->chef_menage_cin)) {
                    $query->where('cin_chef', $menage->chef_menage_cin);
                }
                if (!is_null($menage->conjoint_cin)) {
                    $query->orWhere('cin_conj', $menage->conjoint_cin);
                }
                if (!is_null($menage->conjoint_cin)) {
                    $query->orWhere('cin_chef', $menage->conjoint_cin);
                }
                if (!is_null($menage->chef_menage_cin)) {
                    $query->orWhere('cin_conj', $menage->chef_menage_cin);
                }
            });
            $recensement_row = $recensement_row->where('id_douar', $menage->baraque->id_douar)->get()->first();

            if (!is_null($recensement_row)) {
                $found = true;
            }
            if ($found) {

                if ($recensement_row->trouve == 1) {
                    $recensement_row->trouve_count += 1;
                } else {
                    $recensement_row->trouve_count = 1;
                }
                $recensement_row->trouve = 1;
                $recensement_row->save();
                $menage->istimara = $recensement_row->istimara;
                $menage->found_recensement_cin = 1;
                $menage->save();
            }
        }
        foreach ($menages as $menage) {

            if ($menage->found_recensement_cin == 0) {
                $found = false;

                $recensement_row = RecensementRow::where(function ($query)  use ($menage) {

                    if (!is_null($menage->chef_menage_nom) && !is_null($menage->chef_menage_prenom)) {
                        $query->where([['nom_chef', $menage->chef_menage_nom], ['prenom_chef', $menage->chef_menage_prenom]]);
                        $query->where([['nom_chef', $menage->chef_menage_nom], ['prenom_chef', $menage->chef_menage_prenom]]);
                    }                
                 

                    if (!is_null($menage->conjoint_nom) && !is_null($menage->conjoint_prenom)) {
                        $query->orWhere([['nom_conj', $menage->conjoint_nom], ['prenom_conj', $menage->conjoint_prenom]]);
                        $query->orWhere([['nom_chef', $menage->conjoint_nom], ['prenom_chef', $menage->conjoint_prenom]]);
                    }

                  
                    //$query->orWhere([['nom_conj', $menage->chef_menage_nom], ['prenom_conj', $menage->chef_menage_prenom]]);
         
                });
                $recensement_row = $recensement_row->where('id_douar', $menage->baraque->id_douar)->get()->first();

                if (!is_null($recensement_row)) {
                    $found = true;
                }
                if ($found) {
                    if ($recensement_row->trouve == 1) {
                        $recensement_row->trouve_count += 1;
                    } else {
                        $recensement_row->trouve_count = 1;
                    }
                    $recensement_row->trouve = 1;
                    $recensement_row->save();
                    $menage->istimara = $recensement_row->istimara;
                    $menage->found_recensement_nom = 1;
                    $menage->save();
                }
            }
        }


        $menages = Menage::where('found_recensement_cin', 0)->where('found_recensement_nom', 0)->where('active', 1)->with('baraque')->where('verrification_etat', 'Validé');

        $menages = $menages->whereHas('baraque', function ($query) {
            $query->whereNotNull('baraques.id_douar');
        });

        $menages = $menages->get();

        foreach ($menages as $menage) {
            $menage->not_found_recensement = 1;
            $menage->save();
        }





        // foreach ($recensement_rows as $recensement_row) {


        //     $recensement_row->non_trouve = 0;

        //     $menage = Menage::with('baraque')->where(function ($query)  use ($recensement_row) {

        //         $query->where('chef_menage_cin', $recensement_row->cin_chef)
        //             ->orWhere('conjoint_cin', $recensement_row->cin_conj)
        //             ->orWhere('conjoint_cin', $recensement_row->cin_chef)
        //             ->orWhere('chef_menage_cin', $recensement_row->cin_conj);
        //     });

        //     $menage = $menage->whereHas('baraque', function ($query) use ($recensement_row) {
        //         $query->where('baraques.id_douar', $recensement_row->id_douar);
        //     })->get()->first();



        //     if (is_null($menage)) {

        //         $menage_with_nom = Menage::with('baraque')->where(function ($query)  use ($recensement_row) {


        //             $query->where([['chef_menage_nom', $recensement_row->nom_chef], ['chef_menage_prenom', $recensement_row->prenom_chef]])
        //                 ->orWhere([['chef_menage_nom', $recensement_row->nom_chef], ['chef_menage_prenom', $recensement_row->prenom_chef]])
        //                 ->orWhere([['conjoint_nom', $recensement_row->nom_conj], ['conjoint_prenom', $recensement_row->prenom_conj]])
        //                 ->orWhere([['conjoint_nom', $recensement_row->nom_conj], ['conjoint_prenom', $recensement_row->prenom_conj]]);
        //         });

        //         $menage_with_nom = $menage_with_nom->whereHas('baraque', function ($query) use ($recensement_row) {
        //             $query->where('baraques.id_douar', $recensement_row->id_douar);
        //         })->get()->first();

        //         if (is_null($menage_with_nom)) {
        //             $recensement_row->non_trouve = 1;
        //         }
        //     }
        //     $recensement_row->save();
        // }


        //$recensement_rows = RecensementRow::where('non_trouve', 1)->get();


        $recensement_rows = RecensementRow::where('trouve', 0)->get();
        foreach ($recensement_rows as $recensement_row) {

            $recensement_row->non_trouve = 1;
            $recensement_row->non_trouve_localise = 0;
            $recensement_row->non_trouve_non_localise = 0;
            $menage_with_same_istimara = Menage::with('baraque')->where(function ($query)  use ($recensement_row) {
                $query->where('istimara', $recensement_row->istimara);
            })->get()->first();

            if (!is_null($menage_with_same_istimara)) {
                $recensement_row->non_trouve_localise = 1;
            }
            $recensement_row->save();
        }


        $result = new stdClass();
        $result->done = 1;
        return $result;
    }
}
