<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Mail\InvitationMail;
use App\Models\Ville;
use App\Models\Role;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use App\Mail\ForgotPwdMail;
use DataTables;
use stdClass;
use Response;
use App\Models\User;
use App\Models\Menage;
use App\Models\ChefMenage;
use App\Models\ChefMenageModif;
use App\Models\Province;
use App\Models\Arrondissement;
use App\Models\AnnexeAdministrative;
use App\Models\Douar;
use Carbon\Carbon;
use App\Models\EtudePV;
use App\Models\EtudePV_Dossier;
use App\Models\EtudePV_Membre;
use App\Models\MenageDocument;
use App\Models\Projet;
use App\Models\Immeuble;
use App\Models\Appartement;

use App\Models\AppartementDouar;
use App\Models\PV_TAS;
use App\Models\PV_TAS_Dossier;
use App\Models\PV_TAS_Membre;
use App\Models\PV_TAS_Projet;
use App\Models\QR_Code;

class TravauxCommissionsController extends Controller
{
    public function index()
    {
        $annexes_administratives = AnnexeAdministrative::all();
        $arrondissements = Arrondissement::orderBy('nom', 'asc')->get();
        $provinces = Province::orderBy('nom', 'asc')->get();
        $douars = Douar::orderBy('nom', 'asc')->get();

        $projets = Projet::all();

        if (Auth::user()->has_role('admin')) {


            return view('travaux_commissions.index', [
                'annexes_administratives' => $annexes_administratives,
                'arrondissements' => $arrondissements,
                'provinces' => $provinces,
                'douars' => $douars,
                'projets' => $projets
            ]);
        } else {
            abort(404);
        }
    }

    public function membres_datatable(Request $request)
    {

        $users = User::where('active', 1)->where('role_id', '8d158f5c-56f7-4fc9-9850-874f004b1cd6');


        return Datatables::eloquent($users)
            ->addColumn('organisme_ste', function ($user) {

                return $user->organisme_ste;
            })

            ->addColumn('nom', function ($user) {
                return $user->nom;
            })
            ->addColumn('prenom', function ($user) {
                return $user->prenom;
            })
            ->addColumn('tel', function ($user) {
                return $user->tel;
            })
            ->addColumn('email', function ($user) {

                return '<input style="vertical-align: middle;position: relative;" class="prestataire_cb" item_id="' . $user->id . '" type="checkbox">&nbsp<a class="prestataire_a" item_id="' . $user->id . '" href="javascript:;" >' . $user->email . '</a>';
            })
            ->addColumn('date', function ($user) {
                return $user->created_at;
            })

            ->addColumn('invitation', function ($prestataire) {
                return  $prestataire->invitation_status();
            })
            ->addColumn('nom_complet', function ($user) {

                return  '<button style="text-align: left;" membre_role="' . $user->membre_role . '" organisme_ste="' . $user->organisme_ste . '" nom_complet="' . ($user->prenom . ' ' . $user->nom) . '" id="' . $user->id . '" class="btn btn-success etude_dossier_select_membre_btn"><i class="fa-solid fa-check mr-1"></i>' . $user->prenom . ' ' . $user->nom . '</button>';
            })
            ->addColumn('province', function ($user) {
                return $user->membre_province->nom;
            })
            ->addColumn('arrondissement', function ($user) {
                return  $user->membre_arrondissement->nom;
            })
            ->addColumn('annexe_administrative', function ($user) {
                return  $user->membre_annexe_administrative->nom;
            })
            ->addColumn('membre_role', function ($user) {
                return  $user->membre_role;
            })
            ->addColumn('dossier_etude_actions', function ($user) {
                return  '<button membre_role="' . $user->membre_role . '" organisme_ste="' . $user->organisme_ste . '" nom_complet="' . ($user->prenom . ' ' . $user->nom) . '" id="' . $user->id . '" class="btn btn-success etude_dossier_select_membre_btn"><i class="fa-solid fa-check mr-1"></i>Sélectionner</button>';
            })
            ->rawColumns(['dossier_etude_actions', 'membre_role', 'nom_complet', 'province', 'arrondissement', 'annexe_administrative', 'date', 'organisme_ste', 'nom', 'prenom', 'tel', 'email', 'ville', 'role', 'invitation'])
            ->only(['dossier_etude_actions', 'membre_role', 'nom_complet', 'province', 'arrondissement', 'annexe_administrative', 'date', 'organisme_ste', 'nom', 'prenom', 'tel', 'email', 'ville', 'role', 'invitation'])
            ->tojson();
    }

    public function store_membre(Request $request)
    {
        $user = new User();
        if ($request->id == null) {
            $user->id = Str::uuid();

            $users_same_email = $user->where([['active', 1], ['email', $request->email]])->count();
            if ($users_same_email > 0) {
                return Response::json(['success' => 0, 'error', 'EMAIL_ALREADY_EXISTS'], 200);
            }
        } else {
            $user = User::where('id', $request->id)->get()->first();
        }
        if (!is_null($request->email)) {
            if (is_null($user->validation_completed_date)) {
                $user->email = $request->email;
            }
        }
        $user->password =  null;
        $user->nom = $request->nom;
        $user->prenom = $request->prenom;

        $user->organisme_ste = $request->organisme_ste;
        $user->role_id = "8d158f5c-56f7-4fc9-9850-874f004b1cd6";
        $user->tel = $request->tel;
        $user->membre_role = $request->membre_role;
        $user->nom_ar = $request->nom_ar;
        $user->prenom_ar = $request->prenom_ar;


        if ($request->id == null) {
            $user->token =  Str::random(64);
        }
        $user->save();

        return Response::json(['success' => 1], 200);
    }

    public function check_cin(Request $request)
    {
        $chef_menage = ChefMenage::where('chef_menage_cin', $request->cin)->get()->first();

        if (is_null($chef_menage)) {
            return Response::json(['success' => 0, 'error' => 'CIN_DOESNT_EXISTS'], 200);
        } else {
            $chef_menage->conjoints = $chef_menage->conjoints();

            $chef_menage->tahssine_html = $chef_menage->resultat_tahssine_html();
            $chef_menage->tahssine_date = $chef_menage->resultat_tahssine_fdate();

            foreach ($chef_menage->conjoints as $conjoint) {
                $conjoint->tahssine_html = $chef_menage->resultat_tahssine_conjoint_html($conjoint->index);
                $conjoint->tahssine_date = $chef_menage->resultat_tahssine_conjoint_fdate($conjoint->index);
            }
            return Response::json(['success' => 1, 'chef_menage' => $chef_menage], 200);
        }
    }


    public function etudes_pv_datatable(Request $request)
    {

        $etudes_PVs = EtudePV::where('active', 1);

        $etudes_PVs = $etudes_PVs->orderBy('created_at', 'DESC');

        return Datatables::eloquent($etudes_PVs)
            ->addColumn('pv_etude_id', function ($etude_pv) {
                return   $etude_pv->id;
            })
            ->addColumn('reference', function ($etude_pv) {
                return '<a class="etude_pv_a" id="' . $etude_pv->id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-file-circle-check mr-1"></i>' . $etude_pv->reference . '</span></a>';
            })
            ->addColumn('date', function ($etude_pv) {
                return $etude_pv->created_at->format('d/m/Y H:i:s');
            })

            ->addColumn('province', function ($etude_pv) {
                return $etude_pv->province->nom;
            })
            ->addColumn('arrondissement', function ($etude_pv) {
                return $etude_pv->arrondissement->nom;
            })
            ->addColumn('annexe_administrative', function ($etude_pv) {
                return $etude_pv->annexe_administrative->nom;
            })
            ->addColumn('cin', function ($etude_pv) {
                $html = '<select class="form-control select2nc">';
                foreach ($etude_pv->dossiers as $dossier) {
                    $html .= '<option>' . $dossier->chef_menage->chef_menage_cin . ' - ' . $dossier->chef_menage->chef_menage_prenom . ' ' . $dossier->chef_menage->chef_menage_nom . '</option>';
                }
                $html .= '</select>';
                return  $html;
            })
            ->addColumn('pv_etude_generated', function ($etude_pv) {

                return '<span class="pv_etude_cell" id="' . $etude_pv->id . '">' . $etude_pv->pv_generation_html() . '</span>';
            })
            ->addColumn('pv_etude_signed', function ($etude_pv) {

                if ($etude_pv->pv_signed == 1) {
                    return '<a  class="etude_pv_signed_download" id="' . $etude_pv->pv_signed_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' . $etude_pv->pv_signed_at . '</span></a>';
                } else {
                    return '<a  pv_id="' . $etude_pv->id . '" class="upload_doc_link" file_type="pdf" type_document="PV_ETUDE" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-upload mr-1"></i>Importer</span></a>';
                }
            })
            ->rawColumns(['pv_etude_id', 'reference', 'date', 'province', 'arrondissement', 'annexe_administrative', 'cin', 'pv_etude_generated', 'pv_etude_signed'])
            ->only(['pv_etude_id', 'reference', 'date', 'province', 'arrondissement', 'annexe_administrative', 'cin', 'pv_etude_generated', 'pv_etude_signed'])
            ->tojson();
    }

    public function get_pv_etude(Request $request)
    {
        $etude_pv = EtudePV::with('province')->with('arrondissement')->with('annexe_administrative')->with('dossiers')->with('membres')->where('id', $request->id)->get()->first();


        foreach ($etude_pv->dossiers as $dossier) {
            $dossier->chef_menage = ChefMenage::where('id', $dossier->menage_id)->get()->first();
            $dossier->chef_menage->conjoints = $dossier->chef_menage->conjoints();
            $dossier->menage = Menage::with('douar')->where('id',  $dossier->chef_menage->id_menage)->get()->first();
        }
        foreach ($etude_pv->membres as $membre) {
            $membre->user = User::where('id', $membre->membre_id)->get()->first();
            $membre->user->target = "ETUDE_PV";
            $membre->user->nom_complet = $membre->user->prenom . ' ' . $membre->user->nom;
        }

        $formatter = new \IntlDateFormatter(
            'ar@calendar=gregorian;numbers=latn', // Arabic locale
            \IntlDateFormatter::FULL, // Date format
            \IntlDateFormatter::NONE // No time
        );

        // Format the date
        $etude_pv->created_at_ar = $formatter->format($etude_pv->created_at);
        $etude_pv->dossiers_count = count($etude_pv->dossiers);
        return $etude_pv;
    }

    public function pv_etude_store(Request $request)
    {
        $request->dossiers = json_decode($request->dossiers);
        $request->membres = json_decode($request->membres);


        if (count($request->dossiers) == 0) {
            return Response::json(['success' => 0, 'error' => 'NO_DOSSIER']);
        }

        if (count($request->membres) == 0) {
            return Response::json(['success' => 0, 'error' => 'NO_MEMBRE']);
        }

        foreach ($request->dossiers as $dossier) {
            $menage = Menage::find($dossier->id_menage);
            $menage->cins_list = $menage->chefs_menage_cin();

            $RECENSEMENT_VALIDE = $menage->check_step_in_log('RECENSEMENT_VALIDE');
            $DOISSIER_ETUDE_COMPLET_VALIDE = $menage->check_step_in_log('DOISSIER_ETUDE_COMPLET_VALIDE');
            $PV_ETUDE = $menage->check_step_in_log('PV_ETUDE');

            if (!$RECENSEMENT_VALIDE) {
                return Response::json(['success' => 0, 'error' => 'RECENSEMENT_VALIDE_FALSE', 'menage' => $menage]);
            }
            if (!$DOISSIER_ETUDE_COMPLET_VALIDE) {
                return Response::json(['success' => 0, 'error' => 'DOISSIER_ETUDE_COMPLET_VALIDE_FALSE', 'menage' => $menage]);
            }

            if ($PV_ETUDE) {
                return Response::json(['success' => 0, 'error' => 'ETUDE_ALEADY_VALIDATED', 'menage' => $menage]);
            }
        }

        $etude_pv = new EtudePV();
        $etude_pv->id = Str::uuid();

        if ($request->id != '') {
            $etude_pv = EtudePV::where('id', $request->id)->get()->first();

            if ($etude_pv->pv_signed == 1) {
                return Response::json(['success' => 1]);
            }
            foreach ($etude_pv->dossiers as $dossier) {
                $dossier->delete();
            }
            foreach ($etude_pv->membres as $membre) {
                $membre->delete();
            }
        }



        $etude_pv->province_id = $request->province_id;
        $etude_pv->arrondissement_id = $request->arrondissement_id;
        $etude_pv->annexe_administrative_id = $request->annexe_administrative_id;
        if ($request->id == '') {

            $created_index = app('App\Http\Controllers\IndexingController')->store('PV_ETUDE');
            $etude_pv->reference = "PVE-" . $created_index->year . '-' . $created_index->numero;
        }
        $etude_pv->pv_generated = 0;
        $etude_pv->pv_generated_id = null;
        $etude_pv->pv_generated_at = null;
        $etude_pv->pv_generating = 1;
        $etude_pv->user_id = Auth::user()->id;
        $etude_pv->save();

        foreach ($request->dossiers as $dossier) {
            $etude_pv_dossier = new EtudePV_Dossier();
            $etude_pv_dossier->id = Str::uuid();
            $etude_pv_dossier->pv_id = $etude_pv->id;
            $etude_pv_dossier->menage_id = $dossier->id;
            $etude_pv_dossier->decision = $dossier->decision;
             $etude_pv_dossier->motif_rejet = $dossier->motif_rejet;
            $etude_pv_dossier->save();
        }

        foreach ($request->membres as $membre) {
            $etude_pv_membre = new EtudePV_Membre();
            $etude_pv_membre->id = Str::uuid();
            $etude_pv_membre->pv_id = $etude_pv->id;
            $etude_pv_membre->membre_id = $membre->id;
            $etude_pv_membre->save();
        }
        $request = new Request([
            'type' => 'PV_ETUDE',
            'pv_etude_id' => $etude_pv->id,
        ]);

        app('App\Http\Controllers\DocumentGeneratorController')->generate_PV_ETUDE($etude_pv->id);
        return Response::json(['success' => 1]);
    }


    public function downloadPVEtudeGenerated(string $id)
    {
        $pv_etude = EtudePV::where('id', $id)->get()->first();

        if (is_null($pv_etude)) {
            abort(404);
        } else {


            $headers = array(
                'Content-Type: application/pdf',
            );
            return Response::download($pv_etude->pv_documentPath(), $pv_etude->reference . '.pdf', $headers, "inline");
        }
    }

    public function upload_signed_pv_etude(Request $request)
    {


        $etude_pv = EtudePV::where('id', $request->pv_id)->get()->first();


        $first_upload = 1;
        $first_upload_document = null;

        foreach ($etude_pv->dossiers as $dossier) {

            $menage = Menage::where('id', $dossier->chef_menage->id_menage)->get()->first();

            $menage->decision_commision = $dossier->decision;
            $menage->pv_etude_id = $dossier->pv_id;
            $menage->save();

            if ($first_upload == 1) {
                $clonedRequest = $request->duplicate();
                $clonedRequest->merge(['menage_id' => $dossier->chef_menage->id_menage]);
                $upload_resp = app('App\Http\Controllers\MenagesController')->upload($clonedRequest)->getData();
                $first_upload_document = MenageDocument::where('id', $upload_resp->document->id)->get()->first();
                $first_upload = 0;
            } else {
                $document = $first_upload_document->replicate();
                $document->id = Str::uuid();
                $document->menage_id = $dossier->chef_menage->id_menage;
                $document->save();

                mkdir($document->documentDirPath());
                copy($first_upload_document->documentPath(),  $document->documentPath());
                copy($first_upload_document->documentThumbnailPath(),  $document->documentThumbnailPath());
            }
        }
        $etude_pv->pv_signed = 1;
        $etude_pv->pv_signed_at = Carbon::now();;
        $etude_pv->save();
        return Response::json(['success' => 1]);
    }

    public function PV_ETUDE_generated(Request $request)
    {
        $etude_pv = EtudePV::where('id', $request->id)->get()->first();
        $etude_pv->pv_generated = 1;
        $etude_pv->pv_generating = 0;
        $etude_pv->pv_generated_id =   $etude_pv->id;
        $etude_pv->pv_generated_at = Carbon::now();
        $etude_pv->save();
        return Response::json(['success' => 1]);
    }


    public function pv_etude_generation_stats(Request $request)
    {
        $pv_etude_list = EtudePV::whereIn('id', explode(',', $request->ids))->get();
        $result = [];
        foreach ($pv_etude_list as  $pv_etude) {

            $row = new stdClass();
            $row->id = $pv_etude->id;
            $row->pv_generation_html = $pv_etude->pv_generation_html();
            $result[] = $row;
        }
        return  $result;
    }

    //////////////////////////////////////////////////////////////////TAS///////////////////////////////////////////////////////////////////////////////
    public function pv_tas_datatable(Request $request)
    {

        $etudes_PVs = PV_TAS::where('active', 1);

        $etudes_PVs = $etudes_PVs->orderBy('created_at', 'DESC');

        return Datatables::eloquent($etudes_PVs)
            ->addColumn('pv_tas_id', function ($pv_tas) {
                return   $pv_tas->id;
            })
            ->addColumn('reference', function ($pv_tas) {
                return '<a class="pv_tas_a" id="' . $pv_tas->id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-file-circle-check mr-1"></i>' . $pv_tas->reference . '</span></a>';
            })
            ->addColumn('date', function ($pv_tas) {
                return $pv_tas->created_at->format('d/m/Y H:i:s');
            })

            ->addColumn('province', function ($pv_tas) {
                return $pv_tas->province->nom;
            })
            ->addColumn('arrondissement', function ($pv_tas) {
                return $pv_tas->arrondissement->nom;
            })
            ->addColumn('annexe_administrative', function ($pv_tas) {
                return $pv_tas->annexe_administrative->nom;
            })
            ->addColumn('cin', function ($pv_tas) {
                if (count($pv_tas->dossiers) == 0) {
                    return '<span style="font-weight:500;color:gray">Néant</span>';
                }
                $html = '<select class="form-control select2nc">';
                foreach ($pv_tas->dossiers as $dossier) {
                    $html .= '<option>' . $dossier->chef_menage->chef_menage_cin . ' - ' . $dossier->chef_menage->chef_menage_prenom . ' ' . $dossier->chef_menage->chef_menage_nom . '</option>';
                }
                $html .= '</select>';
                return  $html;
            })
            ->addColumn('pv_tas_generated', function ($pv_tas) {

                return '<span class="pv_tas_pv_cell" id="' . $pv_tas->id . '">' . $pv_tas->pv_generation_html() . '</span>';
            })
            ->addColumn('pv_tas_signed', function ($pv_tas) {

                if ($pv_tas->pv_signed == 1) {
                    return '<a  class="pv_tas_signed_download" id="' . $pv_tas->pv_signed_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' . $pv_tas->pv_signed_at . '</span></a>';
                } else {
                    return '<a  pv_id="' . $pv_tas->id . '" class="upload_doc_link" file_type="pdf" type_document="PV_TAS" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-upload mr-1"></i>Importer</span></a>';
                }
            })
            ->addColumn('projet', function ($pv_tas) {

                if ($pv_tas->projets_tas->count() == 0) {
                    return '<span style="font-weight:500;color:gray">Néant</span>';
                }

                $html = '';

                foreach ($pv_tas->projets_tas as $projet_tas) {
                    $immeuble = $projet_tas->immeuble;
                    $immeuble_html = '';
                    if ($immeuble != null) {
                        $immeuble_html = ' - immeuble : <b style="color:#d87250" >' . $immeuble->numero . "</b>";
                    }
                    $html .= '<span style="color: gray;font-weight: 500;text-align: left;display:block">• <b style="color:#d87250">' . $projet_tas->projet->nom . '</b>' . $immeuble_html . '</span>';
                }

                return  $html;
            })
            ->addColumn('stock', function ($pv_tas) {


                return '<span class="pv_tas_stock_cell" id="' . $pv_tas->id . '">' . $pv_tas->stock_generation_html() . '</span>';
            })
            ->addColumn('bons', function ($pv_tas) {

                return '<span class="pv_tas_bons_cell" id="' . $pv_tas->id . '">' . $pv_tas->bons_generation_html() . '</span>';
            })
            ->rawColumns(['pv_tas_id', 'projet', 'stock', 'bons', 'reference', 'date', 'province', 'arrondissement', 'annexe_administrative', 'cin', 'pv_tas_generated', 'pv_tas_signed'])
            ->only(['pv_tas_id', 'projet', 'stock', 'bons', 'reference', 'date', 'province', 'arrondissement', 'annexe_administrative', 'cin', 'pv_tas_generated', 'pv_tas_signed'])
            ->tojson();
    }

    public function pv_tas_get_immeubles(Request $request)
    {
        $projet = Projet::where('id', $request->projet_id)->get()->first();
        if (is_null($projet)) {
            return Response::json(['success' => 1, 'error' => 'PROJET_NOT_FOUND']);
        }
        return $projet->immeubles;
    }


    public function pv_tas_get_douars(Request $request)
    {
        $projet = Projet::where('id', $request->projet_id)->get()->first();
        if (is_null($projet)) {
            return Response::json(['success' => 1, 'error' => 'PROJET_NOT_FOUND']);
        }
        return $projet->projet_douars();
    }


    public function pv_tas_get_stock_from_immeuble(Request $request)
    {
        $immeuble = Immeuble::where('id', $request->immeuble_id)->get()->first();
        if (is_null($immeuble)) {
            return Response::json(['success' => 1, 'error' => 'IMMEUBLE_NOT_FOUND']);
        }
        return $immeuble->appartements;
    }

    public function pv_tas_get_stock_from_projet(Request $request)
    {
        $projet = Projet::where('id', $request->projet_id)->get()->first();
        if (is_null($projet)) {
            return Response::json(['success' => 1, 'error' => 'PROJET_NOT_FOUND']);
        }
        return $projet->appartements;
    }

    public function pv_tas_get_stock_stats(Request $request)
    {
        $result = new stdClass();
        $result->stock_total = 0;
        $result->stock_disponible = 0;

        $appartements_douars = AppartementDouar::with('appartement')->where('projet_id', $request->projet_id);

        if ($request->douar_id != "all") {
            $appartements_douars =   $appartements_douars->where('douar_id', $request->douar_id);
        }




        $appartements_douars = $appartements_douars->get();

        foreach ($appartements_douars as  $appartement_douar) {
            $result->stock_total++;
            if ($appartement_douar->appartement->is_affected == 0) {
                $result->stock_disponible++;
            }
        }


        return   $result;
    }

    public function pv_tas_store(Request $request)
    {
        $request->dossiers = json_decode($request->dossiers);
        $request->membres = json_decode($request->membres);
        $request->projets_tas = json_decode($request->projets_tas);



        //TAHSSINE


        if ($request->id == '') {
            foreach ($request->projets_tas as $projet_tas) {
                $projet = Projet::where('id', $projet_tas->projet_id)->get()->first();
                if ($projet->blocked == 1) {
                    return Response::json(['success' => 0, 'error' => 'PROJET_BLOCKED', 'projet' => $projet]);
                }
            }

            if (count($request->projets_tas) == 0) {
                return Response::json(['success' => 0, 'error' => 'NO_PROJET']);
            }
        }
        if (count($request->membres) == 0) {
            return Response::json(['success' => 0, 'error' => 'NO_MEMBRE']);
        }

        if ($request->id != '') {
            if (count($request->dossiers) == 0) {
                return Response::json(['success' => 0, 'error' => 'NO_DOSSIER']);
            }

            foreach ($request->dossiers as $dossier) {
                $menage = Menage::find($dossier->id_menage);
                $menage->cins_list = $menage->chefs_menage_cin();

                $RECU_VERSEMENT_20000 = $menage->specific_document('RECU_VERSEMENT_20000');
                $ENGAGEMENT_BANQUE = $menage->specific_document('ENGAGEMENT_BANQUE');

                if (is_null($RECU_VERSEMENT_20000) && is_null($ENGAGEMENT_BANQUE)) {
                    return Response::json(['success' => 0, 'error' => 'NO_RECU_VERSEMENT_20000_OR_ENGAGEMENT_BANQUE', 'menage' => $menage]);
                }
                if (!is_null($RECU_VERSEMENT_20000)) {
                    if ($RECU_VERSEMENT_20000->decision != "Validé") {
                        return Response::json(['success' => 0, 'error' => 'RECU_VERSEMENT_20000_NOT_VALIDTED', 'menage' => $menage]);
                    }
                }

                if (!is_null($ENGAGEMENT_BANQUE)) {
                    if ($ENGAGEMENT_BANQUE->decision != "Validé") {
                        return Response::json(['success' => 0, 'error' => 'ENGAGEMENT_BANQUE_NOT_VALIDTED', 'menage' => $menage]);
                    }
                }
            }

            foreach ($request->dossiers as $dossier) {
                if (!isset($dossier->selected_appartement)) {
                    return Response::json(['success' => 0, 'error' => 'DOSSIER_WITH_NO_SELECTED_APPRTEMENT', 'menage' => $menage]);
                }

                $appartement =  Appartement::with('projet')->where('id', $dossier->selected_appartement)->get()->first();

                if (is_null($appartement)) {
                    return Response::json(['success' => 0, 'error' => 'DOSSIER_WITH_NO_SELECTED_APPRTEMENT', 'menage' => $menage]);
                } else {
                    $menage = Menage::with('projet')->find($dossier->id_menage);
                    $menage->cins_list = $menage->chefs_menage_cin();
                    if ($appartement->projet_id != $menage->projet_id) {
                        return Response::json(['success' => 0, 'error' => 'WRONG_PROJET_DESTINATION', 'menage' => $menage, 'projet_dossier' => $menage->projet->nom, 'projet_selected' => $appartement->projet->nom]);
                    }
                }
            }
        }
        $pv_tas = new PV_TAS();
        $pv_tas->id = Str::uuid();

        if ($request->id != '') {
            $pv_tas = PV_TAS::where('id', $request->id)->get()->first();

            if ($pv_tas->pv_signed == 1) {
                return Response::json(['success' => 1]);
            }

            foreach ($pv_tas->dossiers as $dossier) {
                $dossier->delete();
            }
            foreach ($pv_tas->membres as $membre) {
                $membre->delete();
            }
        }

        if ($request->id == '') {
            foreach ($pv_tas->projets_tas as $projet_tas) {
                $projet_tas->delete();
            }
            foreach ($request->projets_tas as $projet_tas) {
                $projet = Projet::where('id', $projet_tas->projet_id)->get()->first();
                $projet->blocked = 1;
                $projet->save();
            }

            foreach ($request->projets_tas as $projet_tas) {
                $projet_tas_db = new PV_TAS_Projet();
                $projet_tas_db->id = Str::uuid();
                $projet_tas_db->pv_tas_id = $pv_tas->id;
                $projet_tas_db->projet_id = $projet_tas->projet_id;

                if ($projet_tas_db->douar_id != "all") {
                    $projet_tas_db->douar_id = $projet_tas->douar_id;
                }

                $projet_tas_db->save();
            }
        }






        $pv_tas->province_id = $request->province_id;
        $pv_tas->arrondissement_id = $request->arrondissement_id;
        $pv_tas->annexe_administrative_id = $request->annexe_administrative_id;
        if ($request->id == '') {

            $created_index = app('App\Http\Controllers\IndexingController')->store('PV_TAS');
            $pv_tas->reference = "PVT-" . $created_index->year . '-' . $created_index->numero;
            app('App\Http\Controllers\wtspController')->send('212661847758', "Nous vous informons qu'un tirage au sort a été lancé dans la province de *" . $pv_tas->province->nom . "* et que la génération de la liste de stock vient d'être effectuée par le responsable du guichet unique");
        }


        if ($request->id == '') {

            $pv_tas->stock_generating = 1;
            $pv_tas->stock_generated = 0;
            $pv_tas->stock_generated_id = null;
            $pv_tas->stock_generated_at = null;
        }

        $pv_tas->pv_generated = 0;
        $pv_tas->pv_generated_id = null;
        $pv_tas->pv_generated_at = null;
        $pv_tas->pv_generating = 0;
        $pv_tas->user_id = Auth::user()->id;
        $pv_tas->save();



        foreach ($request->dossiers as $dossier) {
            $pv_tas_dossier = new PV_TAS_Dossier();
            $pv_tas_dossier->id = Str::uuid();
            $pv_tas_dossier->pv_id = $pv_tas->id;
            $pv_tas_dossier->menage_id = $dossier->id;
            $pv_tas_dossier->selected_appartement_id = $dossier->selected_appartement;
            $pv_tas_dossier->save();
        }

        foreach ($request->membres as $membre) {
            $pv_tas_membre = new PV_TAS_Membre();
            $pv_tas_membre->id = Str::uuid();
            $pv_tas_membre->pv_id = $pv_tas->id;
            $pv_tas_membre->membre_id = $membre->id;

            $pv_tas_membre->save();
        }



        if ($request->id == '') {
            app('App\Http\Controllers\DocumentGeneratorController')->generate_PV_TAS_STOCK($pv_tas->id);
        }

        if ($request->id != '') {

            $pv_tas->pv_generated = 0;
            $pv_tas->pv_generated_id = null;
            $pv_tas->pv_generated_at = null;
            $pv_tas->pv_generating = 1;

            $pv_tas->bons_generated = 0;
            $pv_tas->bons_generated_id = null;
            $pv_tas->bons_generated_at = null;
            $pv_tas->bons_generating = 1;
            $pv_tas->save();

            app('App\Http\Controllers\DocumentGeneratorController')->generate_PV_TAS($pv_tas->id);
            app('App\Http\Controllers\DocumentGeneratorController')->generate_PV_TAS_BONS($pv_tas->id);
        }
        return Response::json(['success' => 1]);
        // $request = new Request([
        //     'type' => 'PV_ETUDE',
        //     'pv_etude_id' => $etude_pv->id,
        // ]);
        // app('App\Http\Controllers\QRCodeController')->generate_document($request);
    }

    public function get_pv_tas(Request $request)
    {
        $pv_tas = PV_TAS::with(['province', 'projets_tas.projet', 'projets_tas.douar'])->with('arrondissement')->with('annexe_administrative')->with('dossiers.selected_appartement.immeuble.projet')->with('membres')->where('id', $request->id)->get()->first();


        foreach ($pv_tas->dossiers as $dossier) {
            $dossier->chef_menage = ChefMenage::where('id', $dossier->menage_id)->get()->first();
            $dossier->chef_menage->conjoints = $dossier->chef_menage->conjoints();
            $dossier->menage = Menage::with('douar')->where('id',  $dossier->chef_menage->id_menage)->get()->first();
        }
        foreach ($pv_tas->membres as $membre) {
            $membre->user = User::where('id', $membre->membre_id)->get()->first();
            $membre->user->target = "PV_TAS";
            $membre->user->nom_complet = $membre->user->prenom . ' ' . $membre->user->nom;
        }

        $formatter = new \IntlDateFormatter(
            'ar@calendar=gregorian;numbers=latn', // Arabic locale
            \IntlDateFormatter::FULL, // Date format
            \IntlDateFormatter::NONE // No time
        );

        // Format the date
        $pv_tas->created_at_ar = $formatter->format($pv_tas->created_at);
        $pv_tas->dossiers_count = count($pv_tas->dossiers);

        $appartements = [];
        foreach ($pv_tas->projets_tas as $projet_tas) {
            // $pv_tas_appartements = Appartement::with('immeuble')->where('projet_id', $projet_tas->projet_id)->where('active', 1)->where('is_affected', 0);

            // if (!is_null($projet_tas->immeuble)) {
            //     $pv_tas_appartements = $pv_tas_appartements->where('immeuble_id', $projet_tas->immeuble_id);
            // }



            // $pv_tas_appartements =  $pv_tas_appartements->get();


            $appartements_douars = AppartementDouar::with('appartement.immeuble')->where('projet_id', $projet_tas->projet_id);

            if ($request->douar_id != "all") {
                $appartements_douars =   $appartements_douars->where('douar_id', $projet_tas->douar_id);
            }




            $appartements_douars = $appartements_douars->get();

            foreach ($appartements_douars as $appartement_douar) {
                $appartement_douar->appartement->projet_nom = $projet_tas->projet->nom;
                $appartement_douar->appartement->douar_id = $projet_tas->douar_id;
                $appartements[] = $appartement_douar->appartement;
            }
        }




        $pv_tas->stock =  $appartements;
        return $pv_tas;
    }

    public function PV_TAS_STOCK_generated(Request $request)
    {
        $pv_tas = PV_TAS::where('id', $request->id)->get()->first();
        $pv_tas->stock_generated = 1;
        $pv_tas->stock_generating = 0;
        $pv_tas->stock_generated_id = $pv_tas->id;
        $pv_tas->stock_generated_at = Carbon::now();
        $pv_tas->save();
        return Response::json(['success' => 1]);
    }


    public function PV_TAS_generated(Request $request)
    {
        $pv_tas = PV_TAS::where('id', $request->id)->get()->first();
        $pv_tas->pv_generated = 1;
        $pv_tas->pv_generating = 0;
        $pv_tas->pv_generated_id = $pv_tas->id;
        $pv_tas->pv_generated_at = Carbon::now();
        $pv_tas->save();
        return Response::json(['success' => 1]);
    }

    public function PV_TAS_BONS_generated(Request $request)
    {
        $pv_tas = PV_TAS::where('id', $request->id)->get()->first();
        $pv_tas->bons_generated = 1;
        $pv_tas->bons_generating = 0;
        $pv_tas->bons_generated_id = $pv_tas->id;
        $pv_tas->bons_generated_at = Carbon::now();
        $pv_tas->save();
        return Response::json(['success' => 1]);
    }

    public function pv_tas_generation_stats(Request $request)
    {

        $pv_tas_list = PV_TAS::whereIn('id', explode(',', $request->ids))->get();

        $result = [];
        foreach ($pv_tas_list as  $pv_tas) {

            $row = new stdClass();
            $row->id = $pv_tas->id;
            $row->stock_generation_html = $pv_tas->stock_generation_html();
            $row->pv_generation_html = $pv_tas->pv_generation_html();
            $row->bons_generation_html = $pv_tas->bons_generation_html();
            $result[] = $row;
        }

        return  $result;
    }



    public function download_pv_tas_stock_Generated(string $id)
    {
        $pv_tas = PV_TAS::where('id', $id)->get()->first();

        if (is_null($pv_tas)) {
            abort(404);
        } else {


            $headers = array(
                'Content-Type: application/pdf',
            );
            return Response::download($pv_tas->stock_documentPath(), $pv_tas->reference . ' - Stock.pdf', $headers, "inline");
        }
    }

    public function download_pv_tas_Generated(string $id)
    {
        $pv_tas = PV_TAS::where('id', $id)->get()->first();

        if (is_null($pv_tas)) {
            abort(404);
        } else {


            $headers = array(
                'Content-Type: application/pdf',
            );
            return Response::download($pv_tas->pv_documentPath(), $pv_tas->reference . '.pdf', $headers, "inline");
        }
    }

    public function download_pv_tas_bons_Generated(string $id)
    {
        $pv_tas = PV_TAS::where('id', $id)->get()->first();

        if (is_null($pv_tas)) {
            abort(404);
        } else {


            $headers = array(
                'Content-Type: application/pdf',
            );
            return Response::download($pv_tas->bons_documentPath(), $pv_tas->reference . '-Bons.pdf', $headers, "inline");
        }
    }


    public function upload_signed_pv_tas(Request $request)
    {


        $pv_tas = PV_TAS::where('id', $request->pv_id)->get()->first();


        $first_upload = 1;
        $first_upload_document = null;

        foreach ($pv_tas->dossiers as $dossier) {

            $menage = Menage::where('id', $dossier->chef_menage->id_menage)->get()->first();


            $menage->pv_tas_id = $dossier->pv_id;

            $menage->appartement_id = $dossier->selected_appartement_id;

            $appartement = Appartement::where('id', $dossier->selected_appartement_id)->get()->first();
            $appartement->is_affected = 1;
            $appartement->save();
            $menage->immeuble_id = $appartement->immeuble_id;


            $menage->save();

            if ($first_upload == 1) {
                $clonedRequest = $request->duplicate();
                $clonedRequest->merge(['menage_id' => $dossier->chef_menage->id_menage]);
                $upload_resp = app('App\Http\Controllers\MenagesController')->upload($clonedRequest)->getData();
                $first_upload_document = MenageDocument::where('id', $upload_resp->document->id)->get()->first();
                $first_upload = 0;
            } else {
                $document = $first_upload_document->replicate();
                $document->id = Str::uuid();
                $document->menage_id = $dossier->chef_menage->id_menage;
                $document->save();

                mkdir($document->documentDirPath());
                copy($first_upload_document->documentPath(),  $document->documentPath());
                copy($first_upload_document->documentThumbnailPath(),  $document->documentThumbnailPath());
            }
        }

        foreach ($pv_tas->projets_tas as $projet_tas) {


            $projet_tas->projet->blocked = 0;
            $projet_tas->projet->save();
        }

        $pv_tas->pv_signed = 1;
        $pv_tas->pv_signed_at = Carbon::now();;
        $pv_tas->save();
        return Response::json(['success' => 1]);
    }
}
