<?php

namespace App\Http\Controllers;

use App\Models\User;
use Carbon\Carbon;
use App\Models\Role;
use App\Models\Commune;
use App\Models\Ville;
use App\Models\Province;
use App\Models\Cercle;
use App\Models\Affectation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use DataTables;
use stdClass;
use Response;
use App\Models\Demande;
use App\Models\Dossier_document;
use App\Mail\InvitationMail;
use App\Models\Etat_engagement;
use App\Mail\ForgotPwdMail;

use Hofmannsven\Brevo\BrevoServiceProvider;
use Hofmannsven\Brevo\Facades\Brevo;

use Illuminate\Support\Facades\Mail;

class UserController extends Controller
{

    public function gestion_compte_index()
    {
        $role_prestataires = Role::whereNot('name', 'admin')->get();
        $villes = Ville::all();
        $users_count =  User::where('demande', 0)->where('is_proposition', 0)->where('active', 1)->whereNot('role_id', '2d89c150-81ae-48cc-995b-87cc3ce6f391')->count();
        $demandes_count = User::where('demande', 1)->where('is_proposition', 0)->where('active', 1)->whereNot('role_id', '2d89c150-81ae-48cc-995b-87cc3ce6f391')->count();
        $propositions_count = User::where('demande', 0)->where('is_proposition', 1)->where('active', 1)->whereNot('role_id', '2d89c150-81ae-48cc-995b-87cc3ce6f391')->count();
        return view('gestion_comptes.index', [
            'role_prestataires' => $role_prestataires,
            'villes' => $villes,
            'users_count' => $users_count,
            'demandes_count' => $demandes_count,
            'propositions_count'=>$propositions_count
        ]);
    }


    public function datatable(Request $request)
    {

        $users = User::where('demande', $request->demande)->where('is_proposition', $request->proposition)->where('active', 1)->whereNot('role_id', '2d89c150-81ae-48cc-995b-87cc3ce6f391');


        return Datatables::eloquent($users)
            ->addColumn('organisme_ste', function ($user) {

                $raison_sociale = $user->organisme_ste;

                if ($user->type_client == "Personne physique" && $user->role->name == "moa" || $user->organisme_ste == null) {
                    $raison_sociale = $user->nom . ' ' . $user->prenom;
                }

                return '<input style="vertical-align: middle;position: relative;" class="prestataire_cb" item_id="' . $user->id . '" type="checkbox">&nbsp<a class="prestataire_a" item_id="' . $user->id . '" href="javascript:;" >' . $raison_sociale . '</a>';
            })
            ->addColumn('role', function ($user) {
                return $user->role->full_name;
            })
            ->addColumn('nom', function ($user) {
                return $user->nom;
            })
            ->addColumn('prenom', function ($user) {
                return $user->prenom;
            })
            ->addColumn('tel', function ($user) {
                return $user->tel;
            })
            ->addColumn('email', function ($user) {
                return $user->email;
            })
            ->addColumn('membre_role', function ($user) {
                return $user->membre_role;
            })
            ->addColumn('ville', function ($user) {
                if (!is_null($user->ville)) {
                    return $user->ville->nom;
                } else {
                    return $user->adresse;
                }
            })
            ->addColumn('invitation', function ($prestataire) {
                return  $prestataire->invitation_status();
            })
            ->rawColumns(['membre_role','organisme_ste', 'nom', 'prenom', 'tel', 'email', 'ville', 'role', 'invitation'])
            ->only(['membre_role','organisme_ste', 'nom', 'prenom', 'tel', 'email', 'ville', 'role', 'invitation'])
            ->tojson();
    }


    public function show(string $id)
    {
        $user = User::where([['id', $id]])->whereIn('role_id', ['29a4359b-52c1-486b-8ede-b5fcda314a8b', '77970795-73b6-4f2f-8e4c-e97d25636598', 'cccfaaf5-9e6e-45eb-bbd3-0f813a085791', 'f652fd43-e591-4562-9220-ce2ab98542af'])->get()->first();
        if ($user == null) {
            abort(404);
        }
        $role_prestataires = Role::where('prestataire', 1)->get();
        return view('prestataire.show', [
            'user' => $user,
            'role_prestataires' => $role_prestataires

        ]);
    }

    public function store(Request $request)
    {
        $user = new User();
        if ($request->id == null) {
            $user->id = Str::uuid();

            $users_same_email = $user->where([['active', 1], ['email', $request->email]])->count();
            if ($users_same_email > 0) {
                return Response::json(['success' => 0, 'error', 'EMAIL_ALREADY_EXISTS'], 200);
            }
        } else {
            $user = User::where('id', $request->id)->get()->first();
        }
        if (!is_null($request->email)) {
            if (is_null($user->validation_completed_date)) {
                $user->email = $request->email;
            }
        }
        $user->password =  null;
        $user->nom = $request->nom;
        $user->prenom = $request->prenom;

        $user->organisme_ste = $request->organisme_ste;
        $user->role_id = $request->role_id;
        $user->tel = $request->tel;
        $user->rib1 = $request->rib1;
        $user->rib2 = $request->rib2;
        $user->rib3 = $request->rib3;

        if ($request->id == null) {
            $user->token =  Str::random(64);
        }

        
      
       
        $user->save();

        return Response::json(['success' => 1], 200);
    }

    


    public function store_proposition(Request $request)
    {
        $user = new User();
        if ($request->id == null) {
            $user->id = Str::uuid();

            $users_same_email = $user->where([['active', 1], ['email', $request->email]])->count();
            if ($users_same_email > 0) {
                return Response::json(['success' => 0, 'error', 'EMAIL_ALREADY_EXISTS'], 200);
            }
        } else {
            $user = User::where('id', $request->id)->get()->first();
        }
        if (!is_null($request->email)) {
            if (is_null($user->validation_completed_date)) {
                $user->email = $request->email;
            }
        }

        $user->role_id = Role::where('name', $request->role_name)->get()->first()->id;
        $user->nom = $request->nom;
        $user->prenom = $request->prenom;
        $user->organisme_ste = $request->organisme_ste;
        $user->tel = $request->tel;
        $user->identifiant_ste = $request->identifiant_ste;

        if ($request->id == null) {
            $user->token =  Str::random(64);
        }
        $user->is_proposition = 1;
        $user->save();

        return Response::json(['success' => 1,'user'=>$user], 200);
    }


    public function delete(Request $request)
    {
        User::whereIn('id', explode(',', $request->ids))->update(array('active' => 0));
        return Response::json(['success' => 1], 200);
    }

    public function get(string $id)
    {
        $user = User::with('role')->where('id', $id)->get()->first();
        if ($user != null) {
            return   $user;
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }


    public function reset_pwd(string $user_id, string $token)
    {
        $user = User::where('id', $user_id)->first();


        if ($user == null) {
            return redirect('/login');
        }
        if ($user->token != $token) {
            return  redirect('/login');
        }
        return view('reset_pwd.show', [

            'user' => $user,
            'token' => $token,
        ]);
    }

    public function reset_save_pwd(Request $request)
    {
        $req = $request->all();
        $user_id = $req['user_id'];
        $token = $req['token'];
        $password = $req['password'];
        $confirmation_password = $req['password_confirmation'];


        $user = User::where('id', $user_id)->first();

        if (strlen(trim($password)) < 8) {
            return response()->json(['success' =>  0, "message" => "Le mot de passe doit comporter au moins 8 caractères en longueur."]);
        }
        if ($password != $confirmation_password) {
            return response()->json(['success' =>  0, "message" => "Mots de passes ne correspondent pas"]);
        }
        if ($user != null) {
            if ($user->token == null) {
                return response()->json(['success' =>  0, "message" => "Lien expiré."]);
            }

            if ($user->token == $token) {
                $user->token = null;
                $user->password = Hash::make($password);
                $user->save();
                return response()->json(['success' =>  1]);
            } else {
                return response()->json(['success' =>  0, "message" => "Invalid token"]);
            }
        } else {
            return response()->json(['success' =>  0, "message" => "Invalid user_id"]);
        }
    }

    public function send_invitation_mail(string $user_id)
    {
        $auth_user = Auth::user();
        $user = User::where('id', $user_id)->get()->first();
        if ($user != null) {
            if ($auth_user->role->name == 'admin') {
                if ($user->validation_completed_date == null) {
                    Mail::to($user->email)->send(new InvitationMail($user_id));
                    $user->validation_sent_date = Carbon::now();
                    $user->save();
                    return Response::json(['success' => 1, 'error' => null, 'email' => $user->email], 200);
                } else {
                    return Response::json(['success' => 1, 'error' => 'ACCOUNT_VERIFIED'], 200);
                }
            } else {
                return Response::json(['success' => 1, 'error' => 'UNAUTHORIZED'], 200);
            }
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }

    public function send_forgotpwd_mail(Request $request)
    {

        $email = $request->email;
        $user = User::where('email', $email)->get()->first();
        if ($user != null) {
            $user->token = Str::random(64);
            $user->save();
            Mail::to($user->email)->send(new ForgotPwdMail($user->id));
        } else {
            return Response::json(['success' => 0, 'error' => 'UNKNOWN_USER'], 200);
        }
    }
}
