<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\File;
use App\Models\Baraque;
use App\Models\BaraqueDocument;
use Illuminate\Support\Facades\Schema;
use App\Models\Commerce;
use App\Models\Menage;
use App\Models\ChefMenage; 
use DataTables;
use Response;
use stdClass;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Http;

class VerificationController extends Controller
{
    public function index()
    {
        $baraques_count = Baraque::where('active', 1)->count();
        $baraques_verifiees_count = Baraque::where('active', 1)->where('verification_completed', 1)->count();
        if (Auth::user()->has_role('verif')) {
            return view('verification.index', [
                'baraques_count' => $baraques_count,
                'baraques_verifiees_count' => $baraques_verifiees_count
            ]);
        }
    }

    public function updateVerified(Request $request)
    {
        $baraques_verified = Baraque::where('active', 1)->with('commerces')->with('menages')->where('verification_completed', 1)->get();

        $result = new stdClass();
        $result->data = [];
        foreach ($baraques_verified as $baraque) {

            $not_completed = 0;
            foreach ($baraque->menages as $menage) {
                if ($menage->verrification_etat == "En attente") {
                    $not_completed = 1;
                }
            }
            foreach ($baraque->commerces as $commerce) {
                if ($commerce->verrification_etat == "En attente") {
                    $not_completed = 1;
                }
            }

            if ($not_completed == 1) {
                $baraque->verification_completed = 0;
                $baraque->save();
                $result->data[] = $baraque->id;
            }
        }

        return $result;
    }

    public function index_v2()
    {

        $baraques_count = Baraque::where('active', 1)->where('verification_completed', 1)->count();
        $baraques_verifiees_count = Baraque::where('active', 1)->where('verification_2_completed', 1)->where('verification_completed', 1)->count();
        if (Auth::user()->has_role('verif')) {
            return view('verification2.index', [
                'baraques_count' => $baraques_count,
                'baraques_verifiees_count' => $baraques_verifiees_count
            ]);
        }
    }

    public function downloadPhotos(Request $request)
    {
        $baraque = Baraque::with('menages')->with('commerces')->where('id', $request->id)->first();

        $tmp_path = base_path('files/temp/' . $request->id);

        if (!file_exists($tmp_path)) {
            mkdir($tmp_path);
        }


        foreach ($baraque->menages as $menage) {
            $tmp_path = base_path('files/temp/' . $request->id . '/' . $menage->chef_menage_cin);
            if (!file_exists($tmp_path)) {
                mkdir($tmp_path);
            }

            $photos = BaraqueDocument::where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            foreach ($photos as $photo) {
                copy($photo->documentPath(), base_path('files/temp/' . $request->id . '/' . $menage->chef_menage_cin . '/' . $photo->id . '.jpg'));
            }
        }
    }

    public function show(String $id)
    {
        $baraque = Baraque::with('menages')->with('commerces')->where('id', $id)->first();

        if ($baraque->active == 0) {
            abort(404);
        }

        $baraque->PHOTO_GENERAL = BaraqueDocument::where([['baraque_id', $baraque->id], ['is_duplicate', 0]])->get();
        foreach ($baraque->menages as $menage) {

            $menage->PHOTO_MENAGE_CIN = BaraqueDocument::where('type_document', "PHOTO_MENAGE_CIN")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_MARIAGE = BaraqueDocument::where('type_document', "PHOTO_ACT_MARIAGE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_ACT_DIVORCE = BaraqueDocument::where('type_document', "PHOTO_ACT_DIVORCE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_CIN_CONJOINT = BaraqueDocument::where('type_document', "PHOTO_CIN_CONJOINT")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE_VIDE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE_VIDE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
        }

        foreach ($baraque->commerces as $commerce) {

            $commerce->PHOTO_COMMERCE_CIN = BaraqueDocument::where('type_document', "PHOTO_COMMERCE_CIN")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
            $commerce->PHOTO_COMMERCE = BaraqueDocument::where('type_document', "PHOTO_COMMERCE")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
        }

        if (Auth::user()->has_role('verif')) {
            return view('verification.show', ['baraque' => $baraque]);
        }
    }

    public function affectation_photos(Request $request)
    {
        $menage_commerce_id = $request->input('menage_commerce_id');
        $type_document = $request->input('type_document');
        $selected_photos = json_decode($request->input('selected_photos'));
        $type = $request->input('type');

        $column_to_update = $type === 'menage' ? 'menage_id' : 'commerce_id';

        if (!empty($selected_photos) && is_array($selected_photos)) {
            foreach ($selected_photos as $id) {
                // Fetch the existing record
                $baraque_document = BaraqueDocument::where('id', $id)->first();

                if ($baraque_document) {
                    $isMenageEmpty = empty($baraque_document->menage_id) || $baraque_document->menage_id === null;
                    $isCommerceEmpty = empty($baraque_document->commerce_id) || $baraque_document->commerce_id === null;
                    if ($isMenageEmpty && $isCommerceEmpty) {
                        $baraque_document->update([
                            $column_to_update => $menage_commerce_id,
                            'type_document' => $type_document
                        ]);
                    } else {
                        $new_baraque_docuement = $baraque_document->replicate();
                        $new_baraque_docuement->id = Str::uuid();
                        $new_baraque_docuement->$column_to_update = $menage_commerce_id;
                        $new_baraque_docuement->type_document = $type_document;


                        $originalFilePath = $baraque_document->documentPath(); // Original file path
                        $newFilename = Str::uuid() . '_' . $baraque_document->filename; // New unique filename
                        $newFilePath = base_path('files/baraques_documents/' . $new_baraque_docuement->id . '/' . $newFilename); // New file path
                        $newFolder = dirname($newFilePath); // Extract folder path

                        // Ensure the directory exists
                        if (!File::exists($newFolder)) {
                            File::makeDirectory($newFolder, 0777, true, true);
                        }

                        // Copy the file
                        if (File::exists($originalFilePath)) {
                            File::copy($originalFilePath, $newFilePath);
                            $new_baraque_docuement->filename = $newFilename;
                            $new_baraque_docuement->is_duplicate = 1;
                        } else {
                            return Response::json(['success' => 0, 'message' => 'Original file does not exist']);
                        }

                        $new_baraque_docuement->save();
                    }

                    if ($type == "menage") {
                        DB::table('menages')
                            ->where('id', $request->input('menage_commerce_id'))
                            ->update(['photo' => 1]);
                    } else {
                        DB::table('commerce')
                            ->where('id', $request->input('menage_commerce_id'))
                            ->update(['photo' => 1]);
                    }
                }
            }
        }


        //return the new baraque
        $baraque = Baraque::with('menages')->with('commerces')->where('id', $request->input('baraque_id'))->first();



        $baraque->PHOTO_GENERAL = BaraqueDocument::where([['baraque_id', $baraque->id], ['is_duplicate', 0]])->get();
        foreach ($baraque->menages as $menage) {

            $menage->PHOTO_MENAGE_CIN = BaraqueDocument::where('type_document', "PHOTO_MENAGE_CIN")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_MARIAGE = BaraqueDocument::where('type_document', "PHOTO_ACT_MARIAGE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_ACT_DIVORCE = BaraqueDocument::where('type_document', "PHOTO_ACT_DIVORCE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_CIN_CONJOINT = BaraqueDocument::where('type_document', "PHOTO_CIN_CONJOINT")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE_VIDE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE_VIDE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
        }

        foreach ($baraque->commerces as $commerce) {

            $commerce->PHOTO_COMMERCE_CIN = BaraqueDocument::where('type_document', "PHOTO_COMMERCE_CIN")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
            $commerce->PHOTO_COMMERCE = BaraqueDocument::where('type_document', "PHOTO_COMMERCE")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
        }

        return Response::json(['success' => 1, 'updated_baraque' => $baraque, 'message' => 'Affecté avec succès']);
    }


    public function delete_selected_photo(Request $request)
    {

        $id = $request->input('id');

        // Find the document
        $baraque_document = BaraqueDocument::find($id);

        if (!$baraque_document) {
            return Response::json(['success' => 0, 'message' => 'Document introuvable']);
        }

        $menage_id = $baraque_document->menage_id;
        $commerce_id = $baraque_document->commerce_id;
        // Check if is_duplicate = 0
        if ($baraque_document->is_duplicate == 0) {
            // Just update the row
            $baraque_document->update([
                'type_document' => 'PHOTO_GENERAL',
                'menage_id' => null,
                'commerce_id' => null
            ]);
        } else {
            // Delete the row
            $baraque_document->delete();
        }

        if ($menage_id) {
            $remainingPhotos = BaraqueDocument::where('menage_id', $menage_id)->count();
            if ($remainingPhotos === 0) {
                DB::table('menages')->where('id', $menage_id)->update(['photo' => 0]);
            }
        }


        if ($commerce_id) {
            $remainingPhotosCommerce = BaraqueDocument::where('commerce_id', $commerce_id)->count();
            if ($remainingPhotosCommerce === 0) {
                DB::table('commerces')->where('id', $commerce_id)->update(['photo' => 0]);
            }
        }

        return Response::json(['success' => 1, 'message' => 'Operation effectuée avec succès']);
    }


    public function v2_show(String $id)
    {
        $baraque = Baraque::with('menages')->with('commerces')->where('id', $id)->first();


        foreach ($baraque->menages as $menage) {

            $menage->PHOTO_MENAGE_CIN = BaraqueDocument::where('type_document', "PHOTO_MENAGE_CIN")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_MARIAGE = BaraqueDocument::where('type_document', "PHOTO_ACT_MARIAGE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_ACT_DECES = BaraqueDocument::where('type_document', "PHOTO_ACT_DECES")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_ACT_DIVORCE = BaraqueDocument::where('type_document', "PHOTO_ACT_DIVORCE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();

            $menage->PHOTO_CIN_CONJOINT = BaraqueDocument::where('type_document', "PHOTO_CIN_CONJOINT")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
            $menage->PHOTO_BARAQUE = BaraqueDocument::where('type_document', "PHOTO_BARAQUE")->where('baraque_id', $baraque->id)->where('menage_id', $menage->id)->get();
        }

        foreach ($baraque->commerces as $commerce) {

            $commerce->PHOTO_COMMERCE_CIN = BaraqueDocument::where('type_document', "PHOTO_COMMERCE_CIN")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
            $commerce->PHOTO_COMMERCE = BaraqueDocument::where('type_document', "PHOTO_COMMERCE")->where('baraque_id', $baraque->id)->where('commerce_id', $commerce->id)->get();
        }
        if (Auth::user()->has_role('verif')) {
            return view('verification2.show', ['baraque' => $baraque]);
        }
    }


    public function get_next()
    {
        $old_baraque = Baraque::where('active', 1)->orderBy('created_at', 'ASC')->where('verif_id', Auth::user()->id)->where('verification_completed', 0)->first();

        if (!is_null($old_baraque)) {

            return Response::json(['success' => 1, 'id' => $old_baraque->id]);
        }

        $next_baraque = Baraque::where('active', 1)->orderBy('created_at', 'ASC')->whereNull('verif_id')->where('verification_completed', 0)->first();
        $next_baraque->verif_id = Auth::user()->id;
        $next_baraque->save();

        return Response::json(['success' => 1, 'id' => $next_baraque->id]);
    }

    public function v2_get_next()
    {
        $old_baraque = Baraque::where('active', 1)->orderBy('created_at', 'ASC')->where('verif2_id', Auth::user()->id)->where('verification_completed', 1)->where('verification_2_completed', 0)->first();

        if (!is_null($old_baraque)) {

            return Response::json(['success' => 1, 'id' => $old_baraque->id]);
        }

        $next_baraque = Baraque::where('active', 1)->orderBy('created_at', 'ASC')->whereNull('verif2_id')->where('verification_completed', 1)->where('verification_2_completed', 0)->first();
        $next_baraque->verif2_id = Auth::user()->id;
        $next_baraque->save();

        return Response::json(['success' => 1, 'id' => $next_baraque->id]);
    }


    public function complete_validation(Request $request)
    {
        $baraque = Baraque::where('id', $request->id)->first();

        $not_completed = 0;
        // foreach ($baraque->menages as $menage) {
        //     if ($menage->verrification_etat == "En attente") {
        //         $not_completed = 1;
        //     }
        // }

        // foreach ($baraque->commerces as $commerce) {

        //     if ($commerce->verrification_etat == "En attente") {
        //         $not_completed = 1;
        //     }
        // }

        if ($not_completed == 0) {
            $baraque->verification_completed = 1;
            $baraque->save();
        }
        return self::get_next();
    }


    public function complete_affectation(Request $request)
    {
        $baraque = Baraque::where('id', $request->id)->first();
        $baraque->verification_completed = 1;
        $baraque->save();
        return Response::json(['success' => 1]);
    }

    public function complete_validation2(Request $request)
    {
        $baraque = Baraque::where('id', $request->id)->first();

        $not_completed = 0;
        foreach ($baraque->menages as $menage) {
            if ($menage->verrification_2_etat == "En attente") {
                $not_completed = 1;
            }
        }

        foreach ($baraque->commerces as $commerce) {

            if ($commerce->verrification_2_etat == "En attente") {
                $not_completed = 1;
            }
        }

        if ($not_completed == 0) {
            $baraque->verification_2_completed = 1;
            $baraque->save();
        }
        return self::v2_get_next();
    }

    public function validate_menage(Request $request)
    {
        $menage = Menage::where('id', $request->id)->first();
        $menage->verrification_etat = "Validé";
        $menage->chef_menage_cin = $request->menage_cin;
        $menage->chef_menage_nom = $request->menage_nom;
        $menage->chef_menage_prenom = $request->menage_prenom;
        $menage->adresse = $request->menage_adresse;


        $menage->conjoint_cin = $request->menage_conjoint_cin;
        $menage->conjoint_nom = $request->menage_conjoint_nom;
        $menage->conjoint_prenom = $request->menage_conjoint_prenom;

        $menage->save();

        $menage->verrification_etat_color = $menage->verrification_etat_color();
        return Response::json(['success' => 1, 'menage' => $menage]);
    }

    public function reject_menage(Request $request)
    {
        $menage = Menage::where('id', $request->id)->first();
        $menage->verrification_motif_rejet = $request->motif;
        $menage->verrification_etat = "Rejeté";
        $menage->save();

        $menage->verrification_etat_color = $menage->verrification_etat_color();
        return Response::json(['success' => 1, 'menage' => $menage]);
    }


    public function validate_commerce(Request $request)
    {
        $commerce = Commerce::where('id', $request->id)->first();
        $commerce->verrification_etat = "Validé";
        $commerce->cin = $request->commerce_cin;
        $commerce->nom = $request->commerce_nom;
        $commerce->prenom = $request->commerce_prenom;
        $commerce->adresse = $request->commerce_adresse;
        $commerce->save();
        $commerce->verrification_etat_color = $commerce->verrification_etat_color();
        return Response::json(['success' => 1, 'commerce' => $commerce]);
    }

    public function reject_commerce(Request $request)
    {
        $commerce = Commerce::where('id', $request->id)->first();
        $commerce->verrification_motif_rejet = $request->motif;
        $commerce->verrification_etat = "Rejeté";
        $commerce->save();

        $commerce->verrification_etat_color = $commerce->verrification_etat_color();
        return Response::json(['success' => 1, 'commerce' => $commerce]);
    }


    public function validate_menage_2(Request $request)
    {
        $menage = Menage::where('id', $request->id)->first();
        $menage->verrification_2_etat = "Validé";
        $menage->chef_menage_cin = $request->menage_cin;
        $menage->chef_menage_nom = $request->menage_nom;
        $menage->chef_menage_prenom = $request->menage_prenom;
        $menage->adresse = $request->menage_adresse;


        $menage->conjoint_cin = $request->menage_conjoint_cin;
        $menage->conjoint_nom = $request->menage_conjoint_nom;
        $menage->conjoint_prenom = $request->menage_conjoint_prenom;

        $menage->save();

        $menage->verrification_2_etat_color = $menage->verrification_2_etat_color();
        return Response::json(['success' => 1, 'menage' => $menage]);
    }

    public function validate_commerce_2(Request $request)
    {
        $commerce = Commerce::where('id', $request->id)->first();
        $commerce->verrification_2_etat = "Validé";
        $commerce->cin = $request->commerce_cin;
        $commerce->nom = $request->commerce_nom;
        $commerce->prenom = $request->commerce_prenom;
        $commerce->adresse = $request->commerce_adresse;
        $commerce->save();
        $commerce->verrification_2_etat_color = $commerce->verrification_2_etat_color();
        return Response::json(['success' => 1, 'commerce' => $commerce]);
    }
    public function get_baraques_refuses()
    {
        // $baraques = Baraque::with('menages')->with('commerces')->where('active', 1);

        // $baraques = $baraques->whereHas('commerces', function ($query) {
        //     $query->where([['commerces.verrification_etat', "Rejeté"]]);
        // })->orWhereHas('menages', function ($query) {
        //     $query->where([['menages.verrification_etat', "Rejeté"]]);
        // });
        // $baraques->orderBy("created_at", "DESC");

        // return Datatables::eloquent($baraques)

        //     ->addColumn('baraque', function ($baraque) {
        //         return "<a href='/verification/show/$baraque->id'>Baraque N ° $baraque->numero</a>";
        //     })
        //     ->addColumn('equipe', function ($baraque) {
        //         return "<span>" . $baraque->equipe->prefix . "</span>";
        //     })
        //     ->rawColumns(['baraque', 'equipe'])
        //     ->only(['baraque', 'equipe'])
        //     ->tojson();

        $baraques = DB::table('baraques')
            ->join('equipes', function ($join) {
                $join->on('baraques.equipe_id', '=', 'equipes.id');
            })
            ->join('menages', function ($join) {
                $join->on('baraques.id', '=', 'menages.baraque_id')
                    ->where('menages.verrification_etat', '=', 'Rejeté');
            })
            ->where('baraques.active', 1)

            ->select('baraques.*', 'equipes.prefix as prefix')
            ->union(
                DB::table('baraques')
                    ->join('equipes', function ($join) {
                        $join->on('baraques.equipe_id', '=', 'equipes.id');
                    })
                    ->join('commerces', function ($join) {
                        $join->on('baraques.id', '=', 'commerces.baraque_id')
                            ->where('commerces.verrification_etat', '=', 'Rejeté');
                    })
                    ->where('baraques.active', 1)

                    ->select('baraques.*', 'equipes.prefix as prefix')
            )
            ->distinct()->get();


        return Datatables::of($baraques)

            ->addColumn('baraque', function ($baraque) {
                return "<a href='/verification/show/$baraque->id'>Baraque N ° $baraque->numero</a>";
            })
            ->addColumn('equipe', function ($baraque) {
                return "<span>" . $baraque->prefix . "</span>";
            })
            ->rawColumns(['baraque', 'equipe'])
            ->only(['baraque', 'equipe'])
            ->tojson();
    }

    public function get_baraques_en_attente()
    {

        $baraques = DB::table('baraques')
            ->join('equipes', function ($join) {
                $join->on('baraques.equipe_id', '=', 'equipes.id');
            })
            ->join('menages', function ($join) {
                $join->on('baraques.id', '=', 'menages.baraque_id')
                    ->where('menages.verrification_etat', '=', 'En attente');
            })
            ->where('baraques.active', 1)
            ->whereDate("baraques.created_at", "2025-01-31")
            ->select('baraques.*', 'equipes.prefix as prefix')
            ->union(
                DB::table('baraques')
                    ->join('equipes', function ($join) {
                        $join->on('baraques.equipe_id', '=', 'equipes.id');
                    })
                    ->join('commerces', function ($join) {
                        $join->on('baraques.id', '=', 'commerces.baraque_id')
                            ->where('commerces.verrification_etat', '=', 'En attente');
                    })
                    ->where('baraques.active', 1)
                    ->whereDate("baraques.created_at", "2025-01-31")
                    ->select('baraques.*', 'equipes.prefix as prefix')
            )
            ->distinct()->get();


        return Datatables::of($baraques)

            ->addColumn('baraque', function ($baraque) {
                return "<a href='/verification/show/$baraque->id'>Baraque N ° $baraque->numero</a>";
            })
            ->addColumn('equipe', function ($baraque) {
                return "<span>" . $baraque->prefix . "</span>";
            })
            ->rawColumns(['baraque', 'equipe'])
            ->only(['baraque', 'equipe'])
            ->tojson();
    }

    public function get_baraques_en_attente_v2()
    {

        $baraques = Baraque::where('baraques.active', 1)->with("menages")->with("commerces");

        $baraques = $baraques->whereHas('commerces', function ($query) {
            $query->where([['commerces.verrification_etat', "En attente"]]);
        })->orWhereHas('menages', function ($query) {
            $query->where([['menages.verrification_etat', "En attente"]]);
        });
        $baraques = $baraques->whereDate("baraques.created_at", "2025-01-22");
        $baraques = $baraques->where("baraques.active", 1);


        return Datatables::eloquent($baraques)

            ->addColumn('baraque', function ($baraque) {
                return "<a href='/verification/show/$baraque->id'>Baraque N ° $baraque->numero</a>";
            })
            ->addColumn('equipe', function ($baraque) {
                return "<span>" . $baraque->equipe->prefix . "</span>";
            })
            ->rawColumns(['baraque', 'equipe'])
            ->only(['baraque', 'equipe'])
            ->tojson();
    }


    public function exportData(Request $request)
    {

        //Baraques
        $baraques_columns = Schema::getColumnListing("baraques");
        $baraques = Baraque::where('active', 1)->get()->toArray();
        $filePath = base_path('files/exports/baraques.csv');
        $file = fopen($filePath, 'w');
        fwrite($file, "\xEF\xBB\xBF");
        fputcsv($file, $baraques_columns, ";");
        foreach ($baraques as $row) {
            fputcsv($file, $row, ";");
        }
        fclose($file);

        //Menages
        $menages_columns = Schema::getColumnListing("menages");
        $menages = Menage::select("menages.*")->join("baraques", "baraques.id", "=", "menages.baraque_id")->where('baraques.active', 1)->get()->toArray();
        $filePath = base_path('files/exports/menages.csv');
        $file = fopen($filePath, 'w');
        fwrite($file, "\xEF\xBB\xBF");
        fputcsv($file, $menages_columns, ";");
        foreach ($menages as $row) {
            fputcsv($file, $row, ";");
        }
        fclose($file);

        //Commerces
        $commerces_columns = Schema::getColumnListing("commerces");
        $commerces = Commerce::select("commerces.*")->join("baraques", "baraques.id", "=", "commerces.baraque_id")->where('baraques.active', 1)->get()->toArray();
        $filePath = base_path('files/exports/commerces.csv');
        $file = fopen($filePath, 'w');
        fwrite($file, "\xEF\xBB\xBF");
        fputcsv($file, $commerces_columns, ";");
        foreach ($commerces as $row) {
            fputcsv($file, $row, ";");
        }
        fclose($file);

        //geojson

        $big_geojson = new stdClass();
        $big_geojson->type = "FeatureCollection";
        $big_geojson->crs = new stdClass();
        $big_geojson->crs->type = "name";
        $big_geojson->crs->properties = new stdClass();
        $big_geojson->crs->properties->name = "urn:ogc:def:crs:OGC:1.3:CRS84";
        $big_geojson->features = [];


        $baraques = Baraque::where('active', 1)->get();
        foreach ($baraques as $baraque) {
            if (!is_null($baraque->geometry)) {
                if (strlen($baraque->geometry) > 6) {
                    $feature = json_decode($baraque->geometry);

                    if (!is_null($feature)) {
                        $feature->properties = new stdClass();
                        $feature->properties->baraque_id = $baraque->id;
                        $feature->properties->numero = $baraque->equipe->prefix . $baraque->numero;
                        $big_geojson->features[] = $feature;
                    }
                }
            }
        }
        $fp = fopen(base_path("files/exports/géométrie.geojson"), 'w');
        fwrite($fp, json_encode($big_geojson));
        fclose($fp);


        $files = [
            base_path('files/exports/baraques.csv'),
            base_path('files/exports/menages.csv'),
            base_path('files/exports/commerces.csv'),
            base_path('files/exports/géométrie.geojson')
        ];

        // Name of the zip file
        $zipFilePath = base_path('files/exports/' . Carbon::now()->format("d-m-Y H:i:s") . ".zip");


        // Initialize ZipArchive
        $zip = new \ZipArchive();

        // Create or open the ZIP file
        if ($zip->open($zipFilePath, \ZipArchive::CREATE | \ZipArchive::OVERWRITE) === true) {
            // Loop through the files and add them to the ZIP
            foreach ($files as $file) {
                if (file_exists($file)) {
                    $zip->addFile($file, basename($file)); // Add the file
                }
            }
            // Close the ZIP file
            $zip->close();

            // Return the ZIP file as a download
            return response()->download($zipFilePath)->deleteFileAfterSend(true);
        }
    }


    public function delete_baraque(Request $request)
    {
        $pwd = "vsb147147";

        if ($request->pwd == $pwd) {
            $baraque = Baraque::where('id', $request->id)->get()->first();
            $baraque->active = 0;
            $baraque->save();
            return Response::json(['success' => 1]);
        } else {
            return Response::json(['success' => 0, 'error' => "WRONG_PWD"]);
        }
    }

    public static function fix_geometry(Request $request)
    {
        return 1;
        ini_set("precision", 6);

        $result = new stdClass();
        $result->not_found = [];

        $result->found = [];

        $json = file_get_contents(base_path('files/fix_geometry/data.geojson'));
        $data = json_decode($json);
        foreach ($data->features as $feature) {

            $baraque_id = $feature->properties->baraque_id;

            $baraque = Baraque::where('id',   $baraque_id)->get()->first();

            if (!is_null($baraque)) {
                $baraque->cmd_fix_geometry = $baraque->geometry;
                $feature->properties = new stdClass();
                $baraque->geometry = json_encode($feature);

                $result->found[] =  $baraque_id;
                $baraque->save();
            } else {
                $result->not_found[] = $baraque_id;
            }
        }

        return $result;
    }

    public function search_by_name(Request $request)
    {
        $matches = ChefMenage::search($request->name)->get();
        return  $matches;
    }

    public function test_tahssine(Request $request)
    {

        $apiUrl = 'https://196.61.236.6/gb/api/recipient/exists/CIN';


        $response = Http::withOptions(['verify' => false])->withHeaders([

            'Content-Type' => 'application/json',
        ])->get($apiUrl, [
            'cin' => $request->cin
        ]);
        return $response;
        $response =  json_decode($response);
        $result = new stdClass();
        $result->cin = $request->cin;
        $result->result = $response->message;
        
        return  $result;
    }
}
