<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class VerifyConseilRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->user()) {
            if ($request->user()->hasRole('CR_PRESIDENT') || $request->user()->hasRole('CR_VICEPRESIDENT') || $request->user()->hasRole('CR_TRESORIER') || $request->user()->hasRole('CR_ASSISTANTE') || $request->user()->hasRole('CN_PRESIDENT') || $request->user()->hasRole('CN_TRESORIER') || $request->user()->hasRole('CN_ASSISTANTE'))
                return $next($request);
        }

        abort(403, 'Unauthorized action.');
    }
}
