<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCompteIGTRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'nom' => 'required|string|max:255',
            'adresse' => 'nullable|string|max:255',
            'email' =>
            [
                'nullable',
                'string',
                'email',
                'max:255'
            ],
            'site' => 'nullable|string|max:255',
            'tel' => 'nullable|string|max:50',
            'fax' => 'nullable|string|max:50',
            'date_creation' => 'nullable|date_format:d/m/Y',
            'rc' => 'nullable|string|max:50',
            'ice' => 'nullable|string|max:50',
            'lat' => 'nullable|float',
            'lng' => 'nullable|float',
            'conseil_id ' => 'nullable|integer',
        ];
    }
}
