<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appartement extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "appartements";


    public function tranche()
    {
        return $this->belongsTo(Tranche::class, 'tranche_id', 'id');
    }

    public function douar()
    {
        return $this->belongsTo(Douar::class, 'doura_id', 'id');
    }

    public function immeuble()
    {
        return $this->belongsTo(Immeuble::class, 'immeuble_id', 'id');
    }

    public function projet()
    {
        return $this->belongsTo(Projet::class, 'projet_id', 'id');
    }

    public function douars()
    {
        return $this->hasMany(AppartementDouar::class, 'appartment_id', 'id');
    }
}
