<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppartementDouar extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "appartements_douars";

    public function appartement()
    {
        return $this->belongsTo(Appartement::class, 'appartment_id', 'id');
    }

    public function douar()
    {
        return $this->belongsTo(Douar::class, 'douar_id', 'id');
    }
}
