<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Baraque extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "baraques";

    protected $connection = 'remote_db';

    protected $fillable = ['COMPROMIS_VENTE_menage_number'];

    public function menages()
    {
        return $this->hasMany(Menage::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function commerces()
    {
        return $this->hasMany(Commerce::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function documents()
    {
        return $this->hasMany(BaraqueDocument::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function equipe()
    {
        return $this->hasOne(Equipe::class, 'id', 'equipe_id')->where('active', 1);
    }
    public function douar()
    {

        return $this->hasOne(Douar::class, 'id', 'douar_vf_id');
    }

    public function secteur()
    {
        return $this->hasOne(Secteur::class, 'id', 'secteur_id');
    }

    public function annexe_administrative()
    {
        return $this->hasOne(AnnexeAdministrative::class, 'id', 'annexe_administrative_id');
    }

    public function arrondissement()
    {
        return $this->hasOne(Arrondissement::class, 'id', 'arrondissement_id');
    }

    public function province()
    {
        return $this->hasOne(Province::class, 'id', 'province_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id')->where('active', 1);
    }


    public function  specific_document(string $type)
    {
        $document = BaraqueDocument::where([['type_document', $type], ['baraque_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get()->first();
        return   $document;
    }
    public function  specific_documents(string $type)
    {
        $document = BaraqueDocument::where([['type_document', $type], ['baraque_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get();
        return   $document;
    }

    public function zones_pa()
    {
        return $this->hasMany(BaraquePA::class, 'baraque_id', 'id');
    }

    public function titres()
    {
        return $this->hasMany(BaraqueTitre::class, 'baraque_id', 'id');
    }
    public function orthophotos()
    {
        return $this->hasMany(Ortophoto::class, 'baraque_id', 'id');
    }
}
