<?php

namespace App\Models;

use Carbon\Carbon;
use Laravel\Scout\Searchable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use stdClass;

class ChefMenage extends Model
{
    use Searchable;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "chefs_menage";


    public function situations_solaire()
    {
        return $this->hasMany(SituationScolarite::class, 'chef_menage_id', 'id')->where('active', 1);
    }

    public function conjoints()
    {
        $conjoints = [];

        $index = 0;

        $conjoint1 = new stdClass();
        $conjoint1->cin = $this->conjoint_cin;
        $conjoint1->nom = $this->conjoint_nom;
        $conjoint1->prenom = $this->conjoint_prenom;

        if ($conjoint1->cin != null) {
            $conjoints[] =  $conjoint1;
            $index++;
            $conjoint1->index = $index;
            $conjoint1->resultat_tahssine = $this->tahssine_conj;
        }

        $conjoint2 = new stdClass();
        $conjoint2->cin = $this->conjoint2_cin;
        $conjoint2->nom = $this->conjoint2_nom;
        $conjoint2->prenom = $this->conjoint2_prenom;
        if ($conjoint2->cin != null) {
            $conjoints[] =  $conjoint2;
            $index++;
            $conjoint2->index = $index;
            $conjoint2->resultat_tahssine = $this->tahssine_conj2;
        }

        $conjoint3 = new stdClass();
        $conjoint3->cin = $this->conjoint3_cin;
        $conjoint3->nom = $this->conjoint3_nom;
        $conjoint3->prenom = $this->conjoint3_prenom;
        if ($conjoint3->cin != null) {
            $conjoints[] =  $conjoint3;
            $index++;
            $conjoint3->index = $index;
            $conjoint3->resultat_tahssine = $this->tahssine_conj3;
        }

        $conjoint4 = new stdClass();
        $conjoint4->cin = $this->conjoint4_cin;
        $conjoint4->nom = $this->conjoint4_nom;
        $conjoint4->prenom = $this->conjoint4_prenom;
        if ($conjoint4->cin != null) {
            $conjoints[] =  $conjoint4;
            $index++;
            $conjoint4->index = $index;
            $conjoint4->resultat_tahssine = $this->tahssine_conj4;
        }


        return  $conjoints;
    }

    public function menage()
    {
        return $this->belongsTo(Menage::class, 'id_menage', 'id');
    }
    public function enq()
    {
        return $this->hasOne(EnqMenage::class, 'id', 'enq_menage_id');
    }

    public function sitatations_scolarite()
    {
        return $this->hasMany(SituationScolarite::class, 'id', 'chef_menage_id');
    }
    public function resultat_tahssine_html()
    {

        if ($this->tahssine_cm == 0) {
            return '<span style="color:#628a1a"><i class="fa-solid fa-check mr-2"></i>éligible</span>';
        }
        if ($this->tahssine_cm == 1) {
            return '<span style="color:#f94646"><i class="fa-solid fa-xmark mr-2"></i>Non éligible</span>';
        }
        if ($this->tahssine_cm == -1) {
            return '<span style="color:#829aac"><i class="fa-solid fa-circle-exclamation mr-2"></i>Non transmis</span>';
        }
    }

    public function resultat_tahssine_conjoint_html($index)
    {
        if ($index == 1) {
            if ($this->tahssine_conj == 0) {
                return '<span style="color:#628a1a"><i class="fa-solid fa-check mr-2"></i>éligible</span>';
            }
            if ($this->tahssine_conj == 1) {
                return '<span style="color:#f94646"><i class="fa-solid fa-xmark mr-2"></i>Non éligible</span>';
            }
            if ($this->tahssine_conj == -1) {
                return '<span style="color:#829aac"><i class="fa-solid fa-circle-exclamation mr-2"></i>Non transmis</span>';
            }
        }
        if ($index == 2) {
            if ($this->tahssine_conj2 == 0) {
                return '<span style="color:#628a1a"><i class="fa-solid fa-check mr-2"></i>éligible</span>';
            }
            if ($this->tahssine_conj2 == 1) {
                return '<span style="color:#f94646"><i class="fa-solid fa-xmark mr-2"></i>Non éligible</span>';
            }
            if ($this->tahssine_conj2 == -1) {
                return '<span style="color:#829aac"><i class="fa-solid fa-circle-exclamation mr-2"></i>Non transmis</span>';
            }
        }
        if ($index == 3) {
            if ($this->tahssine_conj3 == 0) {
                return '<span style="color:#628a1a"><i class="fa-solid fa-check mr-2"></i>éligible</span>';
            }
            if ($this->tahssine_conj3 == 1) {
                return '<span style="color:#f94646"><i class="fa-solid fa-xmark mr-2"></i>Non éligible</span>';
            }
            if ($this->tahssine_conj3 == -1) {
                return '<span style="color:#829aac"><i class="fa-solid fa-circle-exclamation mr-2"></i>Non transmis</span>';
            }
        }
        if ($index == 4) {
            if ($this->tahssine_conj4 == 0) {
                return '<span style="color:#628a1a"><i class="fa-solid fa-check mr-2"></i>éligible</span>';
            }
            if ($this->tahssine_conj4 == 1) {
                return '<span style="color:#f94646"><i class="fa-solid fa-xmark mr-2"></i>Non éligible</span>';
            }
            if ($this->tahssine_conj4 == -1) {
                return '<span style="color:#829aac"><i class="fa-solid fa-circle-exclamation mr-2"></i>Non transmis</span>';
            }
        }
    }

    public function resultat_tahssine_fdate()
    {

        if (is_null($this->tahssine_cm_date)) {
            return "";
        } else {
            return Carbon::createFromFormat('Y-m-d H:i:s', $this->tahssine_cm_date)->format('d/m/Y H:i');
        }
    }

    public function resultat_tahssine_conjoint_fdate($index)
    {
        if ($index == 1) {
            if (is_null($this->tahssine_conj_date)) {
                return "";
            } else {
                return Carbon::createFromFormat('Y-m-d H:i:s', $this->tahssine_conj_date)->format('d/m/Y H:i');
            }
        }
        if ($index == 2) {
            if (is_null($this->tahssine_conj2_date)) {
                return "";
            } else {
                return Carbon::createFromFormat('Y-m-d H:i:s', $this->tahssine_conj2_date)->format('d/m/Y H:i');
            }
        }
        if ($index == 3) {
            if (is_null($this->tahssine_conj3_date)) {
                return "";
            } else {
                return Carbon::createFromFormat('Y-m-d H:i:s', $this->tahssine_conj3_date)->format('d/m/Y H:i');
            }
        }
        if ($index == 4) {
            if (is_null($this->tahssine_conj4_date)) {
                return "";
            } else {
                return Carbon::createFromFormat('Y-m-d H:i:s', $this->tahssine_conj4_date)->format('d/m/Y H:i');
            }
        }
    }

    public function chef_menage_modifs()
    {
        return $this->hasMany(ChefMenageModif::class, 'chef_menage_id', 'id')->orderBy('created_at', 'asc');
    }

    public function chef_menage_modified()
    {
        return $this->chef_menage_modifs->count() > 0;
    }


    public function last_modif()
    {
        return $this->hasMany(ChefMenageModif::class, 'chef_menage_id', 'id')->orderBy('created_at', 'desc')->get()->first();
    }


    public function  specific_document(string $type)
    {
        $document = MenageDocument::where([['type_document', $type], ['chef_menage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get()->first();
        return   $document;
    }
    public function  specific_documents(string $type)
    {
        $document = MenageDocument::where([['type_document', $type], ['chef_menage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get();
        return   $document;
    }

    public function document_can_be_imported(string $type)
    {
        if ($this->validation == "Validé" && (
            $type == "CM_MENAGE_CIN" ||
            $type == "CM_ACT_DECES" ||
            str_starts_with($type, 'CM_CIN_CONJOINT_') ||
            str_starts_with($type, 'CM_ACT_MARIAGE_') ||
            str_starts_with($type, 'CM_ACT_DIVORCE_')           
        

        )) {
            return false;
        }

        $document = $this->specific_document($type);
        if (is_null($document)) {
            return true;
        } else {
            // if(   str_starts_with($type, 'ATTESTATION_RESIDENCE_CONJOINT_')  ||
            // str_starts_with($type, 'ATTESTATION_NON_IMPOSITION_CONJOINT_') )
            // {

            // }
            if ($document->decision == "Rejeté") {
                return true;
            } else {
                return false;
            }
        }
    }

    public function decision_color()
    {
        if ($this->validation == 'En attente') {
            return "#DBBB24";
        }
        if ($this->validation == 'Validé') {
            return "#779E25";
        }
        if ($this->validation == 'Rejeté') {
            return "#F44141";
        }
    }
}
