<?php

namespace App\Models;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use stdClass;


class ChefMenageModif extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "chefs_menage_modifs";


    public function conjoints()
    {
        $index = 0;
        $conjoints = [];

        $conjoint1 = new stdClass();
        $conjoint1->cin = $this->conjoint_cin;
        $conjoint1->nom = $this->conjoint_nom;
        $conjoint1->prenom = $this->conjoint_prenom;
        if ($conjoint1->cin != null) {
            $conjoints[] =  $conjoint1;
            $index++;
            $conjoint1->index = $index;
        }

        $conjoint2 = new stdClass();
        $conjoint2->cin = $this->conjoint2_cin;
        $conjoint2->nom = $this->conjoint2_nom;
        $conjoint2->prenom = $this->conjoint2_prenom;
        if ($conjoint2->cin != null) {
            $conjoints[] =  $conjoint2;
            $index++;
            $conjoint2->index = $index;
        }

        $conjoint3 = new stdClass();
        $conjoint3->cin = $this->conjoint3_cin;
        $conjoint3->nom = $this->conjoint3_nom;
        $conjoint3->prenom = $this->conjoint3_prenom;
        if ($conjoint3->cin != null) {
            $conjoints[] =  $conjoint3;
            $index++;
            $conjoint3->index = $index;
        }

        $conjoint4 = new stdClass();
        $conjoint4->cin = $this->conjoint4_cin;
        $conjoint4->nom = $this->conjoint4_nom;
        $conjoint4->prenom = $this->conjoint4_prenom;
        if ($conjoint4->cin != null) {
            $conjoints[] =  $conjoint4;
            $index++;
            $conjoint4->index = $index;
        }


        return  $conjoints;
    }
    public function chef_menage()
    {
        return $this->hasOne(ChefMenage::class, 'id', 'chef_menage_id');
    }
    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }  
}
