<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Commerce extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "commerces";


     public function ratissage()
    {
        return $this->belongsTo(Ratissage::class);
    }

    public function verrification_etat_color()
    {
        if ($this->verrification_etat == "En attente") {
            return "#5b5b5b";
        }
        if ($this->verrification_etat == "Validé") {
            return "#218f21";
        }
        if ($this->verrification_etat == "Rejeté") {
            return "#ff4a4a";
        }
    }

    public function verrification_2_etat_color()
    {
        if ($this->verrification_2_etat == "En attente") {
            return "#5b5b5b";
        }
        if ($this->verrification_2_etat == "Validé") {
            return "#218f21";
        }
        if ($this->verrification_2_etat == "Rejeté") {
            return "#ff4a4a";
        }
    }


      public function documents()
    {
        return $this->hasMany(MenageDocument::class, 'commerce_id');
    }
    public function specific_document($type_document)
    {
        return $this->documents()->where('type_document', $type_document)->latest()->first();
    }
    public function document_can_be_imported($type_document)
    {
        $doc = $this->specific_document($type_document);
        
        if (!$doc) {
            return 1;
        }
        
        if ($doc->decision == 'Validé') {
            return 0;
        }
        
        return 1;
    }
   
    public function getCommerceFilesListAttribute()
    {
        $files_list = [];
        // CIN Commerce
        $files_list[] = [
            'type_document' => 'COMMERCE_CIN',
            'name' => "CIN Commerce",
            'document' => $this->specific_document('COMMERCE_CIN'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $this->document_can_be_imported('COMMERCE_CIN'),
            'validation' => 1,
            'date_doc' => 1,
            'show' => 1,
            'break' => 0
        ];
        // Patente Commerce
        // $files_list[] = [
        //     'type_document' => 'COMMERCE_PATENTE',
        //     'name' => "Patente Commerce",
        //     'document' => $this->specific_document('COMMERCE_PATENTE'),
        //     'file_type' => 'pdf',
        //     'w_roles' => '',
        //     'r_roles' => 'all',
        //     'active' => $this->document_can_be_imported('COMMERCE_PATENTE'),
        //     'validation' => 1,
        //     'date_doc' => 1,
        //     'show' => 1,
        //     'break' => 0
        // ];
        // // Registre Commerce
        // $files_list[] = [
        //     'type_document' => 'COMMERCE_REGISTRE',
        //     'name' => "Registre de Commerce",
        //     'document' => $this->specific_document('COMMERCE_REGISTRE'),
        //     'file_type' => 'pdf',
        //     'w_roles' => '',
        //     'r_roles' => 'all',
        //     'active' => $this->document_can_be_imported('COMMERCE_REGISTRE'),
        //     'validation' => 1,
        //     'date_doc' => 1,
        //     'show' => 1,
        //     'break' => 0
        // ];
        // Attestation Demolition Commerce
        $files_list[] = [
            'type_document' => 'COMMERCE_ATTESTATION_DEMOLITION',
            'name' => "Attestation de Démolition",
            'document' => $this->specific_document('COMMERCE_ATTESTATION_DEMOLITION'),
            'file_type' => 'pdf',
            'w_roles' => '',
            'r_roles' => 'all',
            'active' => $this->document_can_be_imported('COMMERCE_ATTESTATION_DEMOLITION'),
            'validation' => 1,
            'date_doc' => 0,
            'show' => 1,
            'break' => 1
        ];
        return $files_list;
    }
}
