<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Douar extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "douars";

    protected $connection = 'mysql';

    public function secteur()
    {
        return $this->belongsTo(Secteur::class, 'secteur_id', 'id');
    }

    public function annexe_administrative()
    {
        return $this->belongsTo(AnnexeAdministrative::class, 'annexe_administrative_id', 'id');
    }

    public function arrondissement()
    {
        return $this->belongsTo(Arrondissement::class, 'arrondissement_id', 'id');
    }


    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id', 'id');
    }
}