<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EtudePV extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "pv_etudes";

    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id');
    }

    public function arrondissement()
    {
        return $this->belongsTo(Arrondissement::class, 'arrondissement_id');
    }
    public function  annexe_administrative()
    {
        return $this->belongsTo(AnnexeAdministrative::class, 'annexe_administrative_id');
    }

    public function dossiers()
    {
        return $this->hasMany(EtudePV_Dossier::class, 'pv_id', 'id')->where('active', 1);
    }
    public function membres()
    {
        return $this->hasMany(EtudePV_Membre::class, 'pv_id', 'id')->where('active', 1);
    }

    public function generated_pv_etude()
    {
        return $this->hasOne(QR_Code::class, 'target_id', 'id');
    }

    public function pv_documentPath()
    {
        return  base_path('files/generated/' . $this->id . '/'.$this->reference.'.pdf');
    }

    public function pv_documentUrl()
    {
        return  asset('files/generated/' .  $this->id . '/'.$this->reference.'.pdf');
    }

    
    public function pv_generation_html()
    {
        if ($this->pv_generating == 1) {
            return '<span style="font-weight:500"><i class="fa-solid fa-hourglass-start fa-spin mr-1"></i>En cours de génération...</span> ';
        }

        if ($this->pv_generated == 1) {
            return '<a  class="etude_pv_generated_download" id="' . $this->pv_generated_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' . $this->pv_generated_at . '</span></a>';
        } else {
        }
    }
}
