<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GBaraque extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "g_baraques";

   
    public function menages()
    {
        return $this->hasMany(GMenage::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function commerces()
    {
        return $this->hasMany(GCommerce::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function documents()
    {
        return $this->hasMany(GBaraqueDocument::class, 'baraque_id', 'id')->where('active', 1);
    }
    public function equipe()
    {
        return $this->hasOne(Equipe::class, 'id', 'equipe_id')->where('active', 1);
    }
    

    public function  specific_document(string $type)
    {
        $document = GBaraqueDocument::where([['type_document', $type], ['baraque_id', $this->id]])->orderBy('created_at', 'desc')->get()->first();
        return   $document;
    }

}
