<?php
namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GBaraqueDocument extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "g_baraques_documents";
    //

    public function baraque()
    {
        return $this->hasOne(GBaraque::class, 'id', 'baraque_id');
    }

    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }
    public function formated_date_document()
    {
        return Carbon::createFromFormat('Y-m-d', $this->date_document)->format('d/m/Y');
    }

    public function documentPath()
    {
        return  base_path('files/baraques_documents/' . $this->id . '/' . $this->filename);
    }

    public function documentUrl()
    {
        return  asset('files/baraques_documents/' .  $this->id . '/' . $this->filename);
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }


 
}
