<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lot extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "lots";

    public function lotissement()
    {
        return $this->belongsTo(Lotissement::class, 'lotissement_id', 'id');
    }

    public function type()
    {
        if ($this->client_formulaire_type == "VILLA") {
            return "Villa";
        }
        if ($this->client_formulaire_type == "R+2") {
            return "R+2";
        }
        if ($this->client_formulaire_type == "IMMEUBLE") {
            return "Immeuble";
        }
    }
}
