<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Lotissement extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "lotissements";

    public function lots()
    {
        return $this->hasMany(Lot::class,'lotissement_id','id');
    }
    public function filiale()
    {
        return $this->belongsTo(Filiale::class,'filiale_id','id');
    }
    public function ville()
    {
        return $this->belongsTo(Ville::class,'ville_id','id');
    }
    public function region()
    {
        return $this->belongsTo(Region::class,'region_id','id');
    }
    public function province()
    {
        return $this->belongsTo(Province::class,'province_id','id');
    }
}
