<?php



namespace App\Models;



use Laravel\Scout\Searchable;

use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

use stdClass;



class Menage extends Model

{

    use Searchable;

    use HasFactory;

    protected $keyType = 'string';

    public $incrementing = false;

    protected $table = "menages";



    protected $fillable = [

        'photo'

    ];

    

    public function ratissage()
    {
        return $this->hasOne(Ratissage::class, 'id', 'ratissage_id');
    }


    public function chefs_menage()

    {

        return $this->hasMany(ChefMenage::class, 'id_menage', 'id')->where('active', 1);
    }



    public function chefs_menage_cin()

    {

        $cins_list = [];



        foreach ($this->chefs_menage as $chef_menage) {

            $cins_list[] = $chef_menage->chef_menage_cin;
        }

        return  join(',', $cins_list);
    }



    public function situations_solaire()

    {

        return $this->hasMany(SituationScolarite::class, 'menage_id', 'id')->where('active', 1);
    }



    public function verified()

    {



        foreach ($this->chefs_menage as $chef_menage) {

            if ($chef_menage->validation == "En attente") {

                return false;
            }
        }

        return true;
    }



    public function getDossierNumberAttribute()

    {

        if (!$this->baraque || !$this->baraque->menages || !$this->baraque->equipe) {

            return null;
        }



        $menagesInBaraque = $this->baraque->menages->sortBy('id');

        $order = $menagesInBaraque->search(fn($m) => $m->id === $this->id) + 1;



        return "DO" . $this->baraque->equipe->prefix . $this->baraque->numero . $order;
    }



    public function dossier_financement()

    {

        return $this->hasOne(DossierFinancement::class, 'id', 'dossier_financement_id');
    }





    public function baraque()

    {

        return $this->hasOne(Baraque::class, 'id', 'baraque_id');
    }



    public function ratissages_documents()

    {

        return $this->hasMany(RatissageDocument::class, 'menage_id', 'id');
    }



    public function douar()

    {

        return $this->hasOne(Douar::class, 'id', 'douar_id');
    }





    public function secteur()

    {

        return $this->hasOne(Secteur::class, 'id', 'secteur_id');
    }



    public function annexe_administrative()

    {

        return $this->hasOne(AnnexeAdministrative::class, 'id', 'annexe_administrative_id');
    }



    public function arrondissement()

    {

        return $this->hasOne(Arrondissement::class, 'id', 'arrondissement_id');
    }



    public function province()

    {

        return $this->hasOne(Province::class, 'id', 'province_id');
    }



    public function recensement()

    {

        return $this->hasOne(Recensement::class, 'id', 'istimara');
    }





    public function projet()

    {

        return $this->hasOne(Projet::class, 'id', 'projet_id');
    }



    public function immeuble()

    {

        return $this->hasOne(Immeuble::class, 'id', 'immeuble_id');
    }



    public function appartement()

    {

        return $this->hasOne(Appartement::class, 'id', 'appartement_id');
    }





    public function notaire()

    {

        return $this->hasOne(User::class, 'id', 'notaire_id');
    }



    public function notaire_etude()

    {

        return $this->hasOne(User::class, 'id', 'notaire_etude_id');
    }



    public function bet()

    {

        return $this->hasOne(User::class, 'id', 'bet_id');
    }





    public function banque()

    {

        return $this->hasOne(User::class, 'id', 'banque_id');
    }







    public function verrification_etat_color()

    {

        if ($this->verrification_etat == "En attente") {

            return "#5b5b5b";
        }

        if ($this->verrification_etat == "Validé") {

            return "#218f21";
        }

        if ($this->verrification_etat == "Rejeté") {

            return "#ff4a4a";
        }
    }



    public function verrification_2_etat_color()

    {

        if ($this->verrification_2_etat == "En attente") {

            return "#5b5b5b";
        }

        if ($this->verrification_2_etat == "Validé") {

            return "#218f21";
        }

        if ($this->verrification_2_etat == "Rejeté") {

            return "#ff4a4a";
        }
    }





    public function dossier_log()

    {

        return $this->hasMany(DossierLog::class, 'menage_id', 'id');
    }



    public function check_step_in_log(string $step_name)

    {

        $steps = $this->dossier_log;



        foreach ($steps  as  $step) {

            if ($step->step == $step_name) {

                return true;
            }
        }

        return false;
    }





    public function  menages_documents()

    {

        return $this->hasMany(MenageDocument::class, 'menage_id', 'id')->where('active', 1)->orderBy('created_at', 'desc');
    }



    public function documents()

    {

        return $this->hasMany(MenageDocument::class, 'menage_id', 'id')->where('active', 1);
    }

    public function  specific_document(string $type)

    {

        $document = MenageDocument::where([['type_document', $type], ['menage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get()->first();

        return   $document;
    }

    public function  specific_documents(string $type)

    {

        $document = MenageDocument::where([['type_document', $type], ['menage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get();

        return   $document;
    }





    public function document_can_be_imported(string $type)

    {

        $document = $this->specific_document($type);

        if (is_null($document)) {

            return true;
        } else {

            if ($document->decision == "Rejeté") {

                return true;
            } else {

                return false;
            }
        }
    }



    public function projets_destination()

    {

        return $this->hasMany(ProjetDouar::class, 'douar_id', 'douar_id')->where('active', 1);
    }



    public function toSearchableArray()

    {

        $array = $this->toArray();



        // Add chef names to the search index

        $array['chefs_names'] = $this->chefs_menage->pluck('chef_menage_prenom')->toArray();



        return $array;
    }
}
