<?php

namespace App\Models;



use Carbon\Carbon;

use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;



class MenageDocument extends Model

{

    use HasFactory;

    protected $keyType = 'string';

    public $incrementing = false;

    protected $table = "menages_documents";

    

    protected $fillable = [

        'id',

        'menage_id',

        'commerce_id',

        'type_document'       

    ];





    public function menage()

    {

        return $this->hasOne(Projet::class, 'id', 'menage_id');

    }


    public function commerce()
    {
        return $this->belongsTo(Commerce::class);
    }



    public function formated_created_at()

    {

        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');

    }

    public function formated_date_document()

    {

        return Carbon::createFromFormat('Y-m-d', $this->date_document)->format('d/m/Y');

    }



    public function documentDirPath()

    {

        return  base_path('files/menages_documents/' . $this->id  );

    }



    public function documentPath()

    {

        return  base_path('files/menages_documents/' . $this->id . '/' . $this->filename);

    }



    public function documentThumbnailPath()

    {

        return  base_path('files/menages_documents/' . $this->id . '/thumbnail.jpg');

    }



    public function documentThumbnailUrl()

    {

        return  asset('files/menages_documents/' . $this->id . '/thumbnail.jpg');

    }



    public function documentUrl()

    {

        return  asset('files/menages_documents/' .  $this->id . '/' . $this->filename);

    }



    public function user()

    {

        return $this->hasOne(User::class, 'id', 'user_id');

    }  



    public function decision_color()

    {

        if ($this->decision == 'En attente') {

            return "#DBBB24";

        }

        if ($this->decision == 'Validé') {

            return "#779E25";

        }

        if ($this->decision == 'Rejeté') {

            return "#F44141";

        }

    }





    public function decision_full()

    {

        if ($this->decision == 'Rejeté') {

            return $this->decision . " (" . $this->motif_rejet . ")";

        }

        return $this->decision;

    }





 

}

