<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PV_TAS extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "pv_tas";

    public function province()
    {
        return $this->belongsTo(Province::class, 'province_id');
    }

    public function projet()
    {
        return $this->hasOne(Projet::class, 'id', 'projet_id');
    }

    public function projets_tas()
    {
        return $this->hasMany(PV_TAS_Projet::class, 'pv_tas_id', 'id');
    }

    public function immeuble()
    {
        return $this->hasOne(Immeuble::class, 'id', 'immeuble_id');
    }
    public function arrondissement()
    {
        return $this->belongsTo(Arrondissement::class, 'arrondissement_id');
    }
    public function  annexe_administrative()
    {
        return $this->belongsTo(AnnexeAdministrative::class, 'annexe_administrative_id');
    }

    public function dossiers()
    {
        return $this->hasMany(PV_TAS_Dossier::class, 'pv_id', 'id')->where('active', 1)->orderBy('menage_id','DESC');
    }
    public function membres()
    {
        return $this->hasMany(PV_TAS_Membre::class, 'pv_id', 'id')->where('active', 1)->orderBy('membre_id','DESC');
    }

    public function generated_pv()
    {
        return $this->hasOne(QR_Code::class, 'target_id', 'id');
    }

    public function stock_generation_html()
    {
      
        if ($this->stock_generating == 1) {
            return '<span style="font-weight:500"><i class="fa-solid fa-hourglass-start fa-spin mr-1"></i>En cours de génération...</span> ';
        }

        if ($this->stock_generated == 1) {
            return '<a  class="pv_tas_stock_generated_download" id="' . $this->stock_generated_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' .$this->stock_generated_at . '</span></a>';
        } else {
            return '<span style="font-weight:500;color:gray">Aucun fichier generé</span>';
        }
    }

    public function pv_generation_html()
    {
        if ($this->pv_generating == 1) {
            return '<span style="font-weight:500"><i class="fa-solid fa-hourglass-start fa-spin mr-1"></i>En cours de génération...</span> ';
        }

        if ($this->pv_generated == 1) {
            return '<a  class="tas_pv_generated_download" id="' . $this->pv_generated_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' . $this->pv_generated_at . '</span></a>';
        } else {
            return '<span style="font-weight:500;color:gray">Aucun fichier generé</span>';
        }
    }

    public function bons_generation_html()
    {
      
        if ($this->bons_generating == 1) {
            return '<span style="font-weight:500"><i class="fa-solid fa-hourglass-start fa-spin mr-1"></i>En cours de génération...</span> ';
        }

        if ($this->bons_generated == 1) {
            return '<a  class="pv_tas_bons_generated_download" id="' . $this->bons_generated_id . '" href="javascript:;"><span style="font-weight:500"><i class="fa-solid fa-download mr-1"></i>' .$this->bons_generated_at . '</span></a>';
        } else {
            return '<span style="font-weight:500;color:gray">Aucun fichier generé</span>';
        }
    }


    public function stock_documentPath()
    {
        return  base_path('files/generated/' . $this->id . '/'.$this->reference.' - Stock.pdf');
    }

    public function stock_documentUrl()
    {
        return  asset('files/generated/' .  $this->id . '/'.$this->reference.' - Stock.pdf');
    }

    public function pv_documentPath()
    {
        return  base_path('files/generated/' . $this->id . '/'.$this->reference.'.pdf');
    }

    public function pv_documentUrl()
    {
        return  asset('files/generated/' .  $this->id . '/'.$this->reference.'.pdf');
    }

    public function bons_documentPath()
    {
        return  base_path('files/generated/' . $this->id . '/'.$this->reference.'-Bons.pdf');
    }

    public function bons_documentUrl()
    {
        return  asset('files/generated/' .  $this->id . '/'.$this->reference.'-Bons.pdf');
    }
    
}
