<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Paiement extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "paiements";
    
    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function decision_color()
    {
        if ($this->decision == 'En attente') {
            return "#F7BC44";
        }
        if ($this->decision == 'Validé') {
            return "#779E25";
        }      
        
        if ($this->decision == 'Rejeté') {
            return "#F44141";
        }
    }
    public function decision_client_color()
    {
        if ($this->decision_client == 'En attente') {
            return "#F7BC44";
        }
        
        if ($this->decision_client == 'Validé') {
            return "#779E25";
        }
        if ($this->decision_client == 'Rejeté') {
            return "#F44141";
        }
        
    }
     
}
