<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use stdClass;

class Projet extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "projets";

    public function appartements_douars()
    {
        return $this->hasMany(AppartementDouar::class, 'projet_id', 'id');
    }

    public function projet_douars()
    {
        $douars_list = [];
        $projet_douars = [];
        foreach ($this->douars as $douar) {

            $exists = false;
            foreach ($douars_list as $douar_l) {

                if ($douar_l == $douar->douar_id) {
                    $exists = true;
                }
            }

            if (!$exists) {
                $douars_list[] = $douar->douar_id;
            }
        }

        foreach ($douars_list  as $douar_id) {

            $projet_douar = new stdClass();
            $projet_douar->douar = Douar::where('id', $douar_id)->get()->first();

            $projet_douar->nbr_appartements =  AppartementDouar::where('projet_id', $this->id)->where('douar_id', $douar_id)->count();

            $projet_douars[] = $projet_douar;
        }
        return $projet_douars;
    }

    public function etages()
    {
        $etage_numeros = [];

        foreach ($this->appartements as $appartement) {
            if (!isset($appartement->niveau)) {
                continue;
            }

            $numero = (int)$appartement->niveau;
            $etage_numeros[] = $numero;
        }

        // Keep unique and sort
        $etage_numeros = array_unique($etage_numeros);
        sort($etage_numeros); // ascending

        $etages = [];

        foreach ($etage_numeros as $numero) {
            $etage = new stdClass();
            $etage->numero = $numero;
            $etage->numero_words = self::numberToFrenchOrdinal($numero) . " étage";
            $etages[] = $etage;
        }

        return   $etages;
    }

    function numberToFrenchOrdinal($number)
    {
        $ordinals = [
            1 => 'Premier',
            2 => 'Deuxième',
            3 => 'Troisième',
            4 => 'Quatrième',
            5 => 'Cinquième',
            6 => 'Sixième',
            7 => 'Septième',
            8 => 'Huitième',
            9 => 'Neuvième',
            10 => 'Dixième',
            11 => 'Onzième',
            12 => 'Douzième',
            13 => 'Treizième',
            14 => 'Quatorzième',
            15 => 'Quinzième',
            16 => 'Seizième',
            17 => 'Dix-septième',
            18 => 'Dix-huitième',
            19 => 'Dix-neuvième',
            20 => 'Vingtième',
        ];

        return $ordinals[$number] ?? $number . 'ᵉ'; // fallback: 21 → "21ᵉ"
    }


    public function douars()
    {
        return $this->hasMany(AppartementDouar::class, 'projet_id', 'id');
    }

    public function tranches()
    {
        return $this->hasMany(Tranche::class, 'projet_id', 'id')->orderBy('numero', 'ASC');
    }

    public function immeubles()
    {
        return $this->hasMany(Immeuble::class, 'projet_id', 'id');
    }


    public function appartements()
    {
        return $this->hasMany(Appartement::class, 'projet_id', 'id');
    }

    public function projets_douars()
    {
        return $this->hasMany(ProjetDouar::class, 'projet_id', 'id');
    }

    public function province()
    {
        return $this->hasOne(Province::class, 'id', 'province_id');
    }

    public function promoteur()
    {
        return $this->hasOne(Promoteur::class, 'id', 'promoteur_id');
    }

    public function banque()
    {
        return $this->hasOne(Banque::class, 'id', 'banque_id');
    }

    public function  specific_document(string $type)
    {
        $document = ProjetDocument::where([['type_document', $type], ['projet_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get()->first();
        return   $document;
    }


    public function  specific_photos(string $type)
    {
        $photos = ProjetDocument::where([['active', 1], ['type_document', $type], ['projet_id', $this->id]])->get();
        return   $photos;
    }

    public function document_can_be_imported(string $type)
    {
        $document = $this->specific_document($type);
        if (is_null($document)) {
            return true;
        } else {
            if ($document->decision == "Rejeté") {
                return true;
            } else {
                return false;
            }
        }
    }

    public function formated_ouverture_chantier_date_previsionnelle()
    {
        if (is_null($this->ouverture_chantier_date_previsionnelle))
            return "-";
        return Carbon::createFromFormat('Y-m-d', $this->ouverture_chantier_date_previsionnelle)->format('d/m/Y');
    }
}
