<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Carbon\Carbon;

class Ratissage extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "ratissages";

    protected $fillable = ['numero', 'adresse', 'occupation', 'usage_batisse', 'typologie', 'niveau', 'mitoyente', 'regime_foncier', 'surface', 'estimation_couts', 'classe'];

    public function dossier()
    {
        return $this->hasOne(Dossier::class, 'ratissage_id', 'id');
    }
    public function menages()
    {
        return $this->hasMany(Menage::class, 'ratissage_id', 'id')->where('active', 1);
    }

    public function commerces()
    {
        return $this->hasMany(Commerce::class, 'ratissage_id', 'id')->where('active', 1);
    }

    public function residents()
    {
        return $this->hasMany(Resident::class, 'ratissage_id', 'id')->where('active', 1);
    }

    public function risques()
    {
        return $this->belongsToMany(Risque::class, 'ratissages_risques', 'ratissage_id', 'risque_id')
            ->withTimestamps();
    }

    public function mesures_urgences()
    {
        return $this->belongsToMany(MesureUrgence::class, 'ratissages_mesures_urgences', 'ratissage_id', 'mesure_urgence_id')
            ->withTimestamps();
    }

    public function documents()
    {
        return $this->hasMany(RatissageDocument::class, 'ratissage_id', 'id')->where('active', 1);
    }

    public function quartier()
    {
        return $this->hasOne(Quartier::class, 'id', 'quartier_id');
    }

      public function arrondissement()
    {
        return $this->hasOne(Arrondissement::class, 'id', 'arrondissement_id');
    }

    public function annexe_administrative()
    {
        return $this->hasOne(AnnexeAdministrative::class, 'id', 'annexe_administrative_id');
    }

  

    public function province()
    {
        return $this->hasOne(Province::class, 'id', 'province_id');
    }

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id')->where('active', 1);
    }

    public function  specific_document(string $type)
    {
        $document = RatissageDocument::where([['type_document', $type], ['ratissage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get()->first();
        return   $document;
    }

    public function  specific_documents(string $type)
    {
        $document = RatissageDocument::where([['type_document', $type], ['ratissage_id', $this->id]])->orderBy('created_at', 'desc')->where('active', 1)->get();
        return   $document;
    }

    public function document_can_be_imported(string $type)
    {
        $document = $this->specific_document($type);
        if (is_null($document)) {
            return true;
        } else {
            if ($document->decision == "Rejeté") {
                return true;
            } else {
                return false;
            }
        }
    }

    public function  specific_photos(string $type)
    {
        $photos = RatissageDocument::where([['active', 1], ['type_document', $type], ['ratissage_id', $this->id]])->get();
        return   $photos;
    }


    public function architecte()
    {
        return $this->hasOne(User::class, 'id', 'architecte_id');
    }

    public function igt()
    {
        return $this->hasOne(User::class, 'id', 'igt_id');
    }

    public function bet()
    {
        return $this->hasOne(User::class, 'id', 'bet_id');
    }

    public function laboratoire()
    {
        return $this->hasOne(User::class, 'id', 'laboratoire_id');
    }


    public function getStepInfo($document_type)
    {
        $document = $this->specific_document($document_type);
        $has_document = !is_null($document);

        return [
            'class' => $has_document ? 'success' : 'pending',
            'date' => $has_document && $document->date_document
                ? Carbon::parse($document->date_document)->format('d/m/Y')
                : '',
            'has_document' => $has_document,
            'document' => $document
        ];
    }
}
