<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RatissageDocument extends Model
{
    use HasFactory;
    protected $keyType = 'string';
    public $incrementing = false;
    protected $table = "ratissages_documents";

    public function ratissage()
    {
        return $this->hasOne(Ratissage::class, 'id', 'ratissage_id');
    }
 
    public function formated_created_at()
    {
        return Carbon::createFromFormat('Y-m-d H:i:s', $this->created_at)->format('d/m/Y H:i');
    }
    public function formated_date_document()
    {
        if ($this->type_document == "PLAN_COTE_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_COTE_DWG") {
            return "-";
        }
        if ($this->type_document == "PLAN_ARCHITECTE_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_ARCHITECTE_DWG") {
            return "-";
        }
        if ($this->type_document == "LIMITE_PLLE") {
            return "-";
        }
        if ($this->type_document == "PLAN_BETON_ARME_PDF") {
            return "-";
        }
        if ($this->type_document == "PLAN_BETON_ARME_DWG") {
            return "-";
        }
        return Carbon::createFromFormat('Y-m-d', $this->date_document)->format('d/m/Y');
    }

    public function documentPath()
    {       
        return  base_path('files/ratissages_docs/' .  $this->id . '/' . $this->filename);      
    }

    public function documentUrl()
    {
        return  asset('files/ratissages_docs/' .  $this->id . '/' . $this->filename);
    }

    public function decision_color()
    {
        if ($this->decision == 'En attente') {
            return "#DBBB24";
        }
        if ($this->decision == 'Validé') {
            return "#779E25";
        }
        if ($this->decision == 'Rejeté') {
            return "#F44141";
        }
    }

    public function decision_full()
    {
        if ($this->decision == 'Rejeté') {
            return $this->decision . " (" . $this->motif_rejet . ")";
        }
        return $this->decision;
    }

    public function verificateur()
    {
        $v_user = User::where('id', $this->verified_by)->get()->first();

        if (is_null($v_user)) {
            return ' inconnu';
        } else {
            return  $v_user->nom . ' ' . $v_user->prenom;
        }
    }

  

    public function user()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }


    public function documentDirPath()
    {
        return  base_path('files/ratissages_docs/' . $this->id  );
    }

  

    public function documentThumbnailPath()
    {
        return  base_path('files/ratissages_docs/' . $this->id . '/thumbnail.jpg');
    }

    public function documentThumbnailUrl()
    {
        return  asset('files/ratissages_docs/' . $this->id . '/thumbnail.jpg');
    }


}
