<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Carbon\Carbon;

class User extends Authenticatable
{
    protected $keyType = 'string';
    public $incrementing = false;
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',

    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'token'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    public function has_role(string $roles)
    {
        $roles_array = explode(',', $roles);
        foreach ($roles_array as $role) {
            if ($this->role->name == $role) {
                return true;
            }
        }
        return false;
    }

    public function guichet()
    {
        return $this->hasOne(Guichet::class, 'id', 'guichet_id');
    }

    public function avatar()
    {
        $profile_pic = base_path('files/users/' . $this->id . '/profile/profile.png');
        if (file_exists($profile_pic)) {
            $profile_pic = asset('files/users/' . $this->id . '/profile/profile.png');
        } else {
            $profile_pic = asset('images/default_profile.png');
        }
        $profile_pic = $profile_pic . '?t=' . time();
        return $profile_pic;
    }

    public function is_prestataire()
    {
        return $this->role->is_prestataire;
    }

    public function loginSecurity()
    {
        return $this->hasOne(LoginSecurity::class);
    }
 

    public function notifications_count()
    {
        return Notification::where('user_id', $this->id)->count();
    }

    public function invitation_status()
    {
        if ($this->validation_completed_date != null) {
            return '<b style="color:#769C25">Validé le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_completed_date)->format('d/m/Y H:i') . '</b>';
        }
        if ($this->validation_read_date != null) {
            return '<b style="color:#E8A824">Lus le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_read_date)->format('d/m/Y H:i') . '</b>';
        }
        if ($this->validation_sent_date != null) {
            return '<b style="color:#29ABE2">Envoyé le ' . Carbon::createFromFormat('Y-m-d H:i:s', $this->validation_sent_date)->format('d/m/Y H:i') . '</b>';
        }


        return '<b style="color:#949494">Aucune invitation n\'a été envoyée.</b>';
    }

    public function notifications()
    {
        return $this->hasMany(Notification::class, 'user_id', 'id')->orderBy('created_at','DESC');
    }

    public function equipe()
    {
        return $this->hasOne(Equipe::class, 'id', 'equipe_id');
    }

    public function membre_province()
    {
        return $this->belongsTo(Province::class,'membre_province_id');
    }

    public function membre_arrondissement()
    {
        return $this->belongsTo(Arrondissement::class,'membre_arrondissement_id');
    }
    public function membre_annexe_administrative()
    {
        return $this->belongsTo(AnnexeAdministrative::class,'membre_annexe_administrative_id');
    }
}
