<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('email')->unique()->index();
            $table->string('nom');
            $table->string('prenom');
            $table->string('tel')->nullable();
            $table->string('cine')->nullable();
            $table->string('sexe')->nullable();
            $table->string('date_naissance')->nullable();
            $table->string('ville')->nullable();
            $table->double('porte_monnaie')->nullable();
            $table->string('inscription_igt')->nullable();
            $table->string('rcp')->nullable();
            $table->text('diplome')->nullable();
            $table->boolean('confirmed')->default(0);
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
