<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('prestations', function (Blueprint $table) {
            $table->unsignedBigInteger('prestation_categorie_id')->nullable();
            $table->foreign('prestation_categorie_id')->references('id')->on('prestations_categories');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('prestations', function (Blueprint $table) {
            $table->dropForeign(['prestation_categorie_id']);
            $table->dropColumn(['prestation_categorie_id']);
        });
    }
};
