<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('collaborateurs', function (Blueprint $table) {
            $table->id();
            $table->string('nom_complet');
            $table->string('cine');
            $table->string('fonction');
            $table->string('cnss');
            $table->date('date_emploi');
            $table->string('contrat');
            $table->boolean('igt');
            $table->string('inscription_igt');
            $table->string('rcp');
            $table->unsignedBigInteger('compte_id')->nullable();
            $table->timestamps();

            $table->foreign('compte_id')->references('id')->on('comptes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('collaborateurs');
    }
};
