    <?php

    use Illuminate\Database\Migrations\Migration;
    use Illuminate\Database\Schema\Blueprint;
    use Illuminate\Support\Facades\Schema;

    return new class extends Migration
    {
        /**
         * Run the migrations.
         */
        public function up(): void
        {
            Schema::create('chiffres_affaires', function (Blueprint $table) {
                $table->id();
                $table->integer('annee');
                $table->double('ca');
                $table->string('justificatif');
                $table->date('date_depot');
                $table->unsignedBigInteger('compte_id')->nullable();

                $table->timestamps();
                $table->foreign('compte_id')->references('id')->on('comptes');
            });
        }

        /**
         * Reverse the migrations.
         */
        public function down(): void
        {
            Schema::dropIfExists('chiffres_affaires');
        }
    };
