<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commandes_publiques', function (Blueprint $table) {
            $table->id();
            $table->string('num');
            $table->string('maitre_ouvrage');
            $table->string('objet');
            $table->string('ville');
            $table->double('estimation');
            $table->double('offre_retenue');
            $table->double('ecart');
            $table->double('duree');
            $table->double('vignette');
            $table->double('solde');
            $table->unsignedBigInteger('prestation_id')->nullable();
            $table->timestamps();

            $table->foreign('prestation_id')->references('id')->on('prestations');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commandes_publiques');
    }
};
