<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('situations_regulieres', function (Blueprint $table) {
            $table->id();
            $table->integer('annee');
            $table->string('statut');
            $table->string('attestation_document');
            $table->double('solde_calcule');
            $table->double('solde_valide');
            $table->unsignedBigInteger('compte_id')->nullable();
            $table->timestamps();

            $table->foreign('compte_id')->references('id')->on('comptes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('situations_regulieres');
    }
};
