<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('soldes', function (Blueprint $table) {
            $table->unsignedBigInteger('trimestre_id')->nullable();
            $table->foreign('trimestre_id')->references('id')->on('trimestres');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('solde', function (Blueprint $table) {
            $table->dropForeign(['trimestre_id']);
            $table->dropColumn(['trimestre_id']);
        });
    }
};
