<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('trimestres', function (Blueprint $table) {
            $table->unsignedBigInteger('solde_trimestre_collab_id')->nullable();
            $table->foreign('solde_trimestre_collab_id')->references('id')->on('soldes_trimestres_collabs');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('trimestres', function (Blueprint $table) {
            $table->dropForeign(['solde_trimestre_collab_id']);
            $table->dropColumn(['solde_trimestre_collab_id']);
        });
    }
};
