<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('commande_publique_trimistre', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('commande_publique_id')->nullable();
            $table->unsignedBigInteger('trimestre_id')->nullable();
            $table->double("solde_min_par_trimestre");
            $table->double("solde_consomme_par_trimestre");

            $table->foreign('commande_publique_id')->references('id')->on('commandes_publiques');
            $table->foreign('trimestre_id')->references('id')->on('trimestres');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('commande_publique_trimistre');
    }
};
