<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('situation_reguliere_materiel', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('situation_reguliere_id')->nullable();
            $table->unsignedBigInteger('materiel_id')->nullable();
            $table->string("remarque");
            $table->timestamps();

            $table->foreign('situation_reguliere_id')->references('id')->on('situations_regulieres');
            $table->foreign('materiel_id')->references('id')->on('materiels');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('situation_reguliere_materiel');
    }
};
