<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('prestations_categories', function (Blueprint $table) {
            $table->unsignedBigInteger('prestation_type_id')->nullable();
            $table->foreign('prestation_type_id')->references('id')->on('prestations_types');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('prestations_categories', function (Blueprint $table) {
            $table->dropForeign(['prestation_type_id']);
            $table->dropColumn(['prestation_type_id']);
        });
    }
};
