<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contrats', function (Blueprint $table) {
            $table->unsignedBigInteger('qualification_hj_id')->nullable();
            $table->foreign('qualification_hj_id')->references('id')->on('qualifications_hjs');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contrats', function (Blueprint $table) {
            $table->dropForeign(['qualification_hj_id']);
            $table->dropColumn(['qualification_hj_id']);
        });
    }
};
