<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('intervales', function (Blueprint $table) {
            $table->unsignedBigInteger('choix_id')->nullable();
            $table->foreign('choix_id')->references('id')->on('choix');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('intervales', function (Blueprint $table) {
            $table->dropForeign(['choix_id']);
            $table->dropColumn(['choix_id']);
        });
    }
};
