<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('commandes_publiques', function (Blueprint $table) {
            $table->unsignedBigInteger('etape_id')->nullable();
            $table->foreign('etape_id')->references('id')->on('etapes');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('commandes_publiques', function (Blueprint $table) {
            $table->dropForeign(['etape_id']);
            $table->dropColumn(['etape_id']);
        });
    }
};
